/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Recipe.RecipePattern;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.RotaryCraft.API.RecipeInterface;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesBlastFurnace
extends RecipeHandler
implements RecipeInterface.BlastFurnaceManager {
    private static final RecipesBlastFurnace BlastFurnaceBase = new RecipesBlastFurnace();
    private final ArrayList<BlastRecipe> recipeList = new ArrayList();
    private final ArrayList<BlastCrafting> craftingList = new ArrayList();

    private RecipesBlastFurnace() {
        super(MachineRegistry.BLASTFURNACE);
        RecipeInterface.blastfurn = this;
        BlastInput in1 = new BlastInput(Items.field_151044_h, 100.0f, 1);
        BlastInput in2 = new BlastInput(Items.field_151016_H, 3.6f, 1);
        BlastInput in3 = new BlastInput((Block)Blocks.field_150354_m, 0.2f, 1);
        BlastRecipe hsla = new BlastRecipe(in1, in2, in3, Items.field_151042_j, ItemStacks.steelingot, false, 0.6f, 600);
        this.addRecipe(hsla, RecipeHandler.RecipeLevel.CORE);
        in1 = new BlastInput(new ItemStack(Items.field_151044_h, 1, 1), 100.0f, 1);
        in2 = new BlastInput(Items.field_151016_H, 3.2f, 1);
        in3 = new BlastInput((Block)Blocks.field_150354_m, 0.2f, 1);
        BlastRecipe hsla1b = new BlastRecipe(in1, in2, in3, Items.field_151042_j, ItemStacks.steelingot, false, 0.6f, 600);
        this.addRecipe(hsla1b, RecipeHandler.RecipeLevel.CORE);
        in1 = new BlastInput(ItemStacks.coke, 100.0f, 1);
        in2 = new BlastInput(Items.field_151016_H, 1.8f, 1);
        in3 = new BlastInput((Block)Blocks.field_150354_m, 0.1f, 1);
        BlastRecipe hsla2 = new BlastRecipe(in1, in2, in3, Items.field_151042_j, ItemStacks.steelingot, true, 0.6f, 600);
        this.addRecipe(hsla2, RecipeHandler.RecipeLevel.CORE);
        in1 = new BlastInput(ItemStacks.bedrockdust, 100.0f, 4);
        in2 = new BlastInput((ItemStack)null, 0.0f, 1);
        in3 = new BlastInput((ItemStack)null, 0.0f, 1);
        BlastRecipe bedrock = new BlastRecipe(in1, in2, in3, ItemStacks.steelingot, 1, ItemStacks.bedingot, false, 0.0f, 1000);
        this.addRecipe(bedrock.setAlloy(), RecipeHandler.RecipeLevel.CORE);
        in1 = new BlastInput((ItemStack)null, 0.0f, 1);
        in2 = new BlastInput((ItemStack)null, 0.0f, 1);
        in3 = new BlastInput((ItemStack)null, 0.0f, 1);
        BlastRecipe scrap = new BlastRecipe(in1, in2, in3, ItemStacks.scrap, 9, ItemStacks.steelingot, false, 0.0f, 600);
        this.addRecipe(scrap, RecipeHandler.RecipeLevel.PROTECTED);
        in1 = new BlastInput((ItemStack)null, 0.0f, 1);
        in2 = new BlastInput((ItemStack)null, 0.0f, 1);
        in3 = new BlastInput((ItemStack)null, 0.0f, 1);
        BlastRecipe coke = new BlastRecipe(in1, in2, in3, new ItemStack(Items.field_151044_h), ItemStacks.coke, false, 0.0f, 400);
        this.addRecipe(coke, RecipeHandler.RecipeLevel.CORE);
        in1 = ConfigRegistry.OREALUDUST.getState() ? new BlastInput("dustAluminum", 25.0f, 1) : new BlastInput(ItemStacks.aluminumpowder, 25.0f, 1);
        in2 = new BlastInput(Items.field_151065_br, 2.5f, 1);
        in3 = new BlastInput((ItemStack)null, 0.0f, 1);
        BlastRecipe sili = new BlastRecipe(in1, in2, in3, (Block)Blocks.field_150354_m, ItemStacks.silicondust, true, 0.0f, 700);
        this.addRecipe(sili, RecipeHandler.RecipeLevel.CORE);
        in1 = new BlastInput(ItemStacks.coke, 75.0f, 1);
        in2 = new BlastInput(Items.field_151137_ax, 40.0f, 1);
        in3 = new BlastInput((ItemStack)null, 0.0f, 1);
        BlastRecipe spring = new BlastRecipe(in1, in2, in3, ItemStacks.steelingot, ItemStacks.springingot, false, 0.0f, 1150);
        this.addRecipe(spring, RecipeHandler.RecipeLevel.CORE);
        in1 = new BlastInput(ItemStacks.silicondust, 20.0f, 1);
        in2 = new BlastInput((ItemStack)null, 0.0f, 1);
        in3 = new BlastInput((ItemStack)null, 0.0f, 1);
        BlastRecipe silu = new BlastRecipe(in1, in2, in3, "ingotAluminum", ItemStacks.silumin, false, 0.0f, 900);
        this.addRecipe(silu, RecipeHandler.RecipeLevel.CORE);
    }

    private void addRecipe(BlastRecipe br, RecipeHandler.RecipeLevel rl) {
        this.recipeList.add(br);
        this.onAddRecipe(br, rl);
    }

    public static final RecipesBlastFurnace getRecipes() {
        return BlastFurnaceBase;
    }

    public void addRecipe(ItemStack out, int temperature, IRecipe in, int speed, float xp) {
        BlastCrafting c = new BlastCrafting(out, temperature, speed, in, xp);
        this.addCrafting(c, RecipeHandler.RecipeLevel.CORE);
    }

    public void addAlloyingRecipe(ItemStack out, int temperature, IRecipe in, int speed, float xp) {
        BlastCrafting c = new BlastCrafting(out, temperature, speed, in, xp).setAlloying();
        this.addCrafting(c, RecipeHandler.RecipeLevel.CORE);
    }

    public void add3x3AlloyingRecipe(ItemStack out, int temperature, IRecipe in, int speed, float xp) {
        ShapedRecipes r = ReikaRecipeHelper.getShapedRecipeFor((ItemStack)out, (Object[])new Object[]{in});
        BlastCrafting c = new BlastCrafting(out, temperature, speed, (IRecipe)r, xp).setAlloying();
        this.addCrafting(c, RecipeHandler.RecipeLevel.CORE);
    }

    public void add3x3Crafting(ItemStack out, int temperature, int speed, float xp, Object ... in) {
        ShapedRecipes r = ReikaRecipeHelper.getShapedRecipeFor((ItemStack)out, (Object[])in);
        BlastCrafting c = new BlastCrafting(out, temperature, speed, (IRecipe)r, xp);
        this.addCrafting(c, RecipeHandler.RecipeLevel.CORE);
    }

    private void addCrafting(BlastCrafting cr, RecipeHandler.RecipeLevel rl) {
        this.craftingList.add(cr);
        this.onAddRecipe(cr, rl);
    }

    public BlastCrafting getCrafting(ItemStack[] main, int temp) {
        RecipePattern ic = new RecipePattern(main);
        for (int i = 0; i < this.craftingList.size(); ++i) {
            BlastCrafting c = this.craftingList.get(i);
            if (!c.matches((InventoryCrafting)ic, temp)) continue;
            return c;
        }
        return null;
    }

    public BlastRecipe getRecipe(ItemStack in1, ItemStack in2, ItemStack in3, ItemStack[] main, int temp) {
        for (int i = 0; i < this.recipeList.size(); ++i) {
            BlastRecipe r = this.recipeList.get(i);
            if (temp < r.temperature || !this.matchRecipe(r, in1, in2, in3, main)) continue;
            return r;
        }
        return null;
    }

    private boolean matchRecipe(BlastRecipe r, ItemStack in1, ItemStack in2, ItemStack in3, ItemStack[] main) {
        if (!r.primary.match(in1)) {
            return false;
        }
        if (!r.secondary.match(in2)) {
            return false;
        }
        if (!r.tertiary.match(in3)) {
            return false;
        }
        int num = 0;
        for (int i = 0; i < main.length; ++i) {
            ItemStack is = main[i];
            if (is == null) continue;
            if (r.isValidMainItem(is)) {
                ++num;
                continue;
            }
            return false;
        }
        return r.matchNumberExactly ? num == r.mainRequired : num >= r.mainRequired;
    }

    public boolean isProduct(ItemStack result) {
        for (int i = 0; i < this.recipeList.size(); ++i) {
            BlastRecipe r = this.recipeList.get(i);
            if (!ReikaItemHelper.matchStacks((ItemStack)result, (ItemStack)r.outputItem())) continue;
            return true;
        }
        return false;
    }

    public boolean isInput(ItemStack ingredient) {
        return this.getInputTypeForItem(ingredient) >= 0;
    }

    public int getInputTypeForItem(ItemStack is) {
        for (int i = 0; i < this.recipeList.size(); ++i) {
            BlastRecipe r = this.recipeList.get(i);
            if (r.isValidMainItem(is)) {
                return 0;
            }
            if (r.primary.match(is)) {
                return 1;
            }
            if (r.secondary.match(is)) {
                return 2;
            }
            if (!r.tertiary.match(is)) continue;
            return 3;
        }
        return -1;
    }

    public ArrayList<BlastRecipe> getAllRecipesUsing(ItemStack is) {
        ArrayList<BlastRecipe> li = new ArrayList<BlastRecipe>();
        for (int i = 0; i < this.recipeList.size(); ++i) {
            BlastRecipe r = this.recipeList.get(i);
            if (r.isValidMainItem(is)) {
                li.add(r);
            }
            if (r.primary.match(is)) {
                li.add(r);
            }
            if (r.secondary.match(is)) {
                li.add(r);
            }
            if (!r.tertiary.match(is)) continue;
            li.add(r);
        }
        return li;
    }

    public ArrayList<BlastRecipe> getAllRecipesMaking(ItemStack is) {
        ArrayList<BlastRecipe> li = new ArrayList<BlastRecipe>();
        for (int i = 0; i < this.recipeList.size(); ++i) {
            BlastRecipe r = this.recipeList.get(i);
            if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)r.outputItem())) continue;
            li.add(r);
        }
        return li;
    }

    public ArrayList<BlastCrafting> getAllCraftingUsing(ItemStack is) {
        ArrayList<BlastCrafting> li = new ArrayList<BlastCrafting>();
        for (int i = 0; i < this.craftingList.size(); ++i) {
            BlastCrafting r = this.craftingList.get(i);
            if (!r.usesItem(is)) continue;
            li.add(r.copy());
        }
        return li;
    }

    public ArrayList<BlastCrafting> getAllCraftingMaking(ItemStack is) {
        ArrayList<BlastCrafting> li = new ArrayList<BlastCrafting>();
        for (int i = 0; i < this.craftingList.size(); ++i) {
            BlastCrafting r = this.craftingList.get(i);
            if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)r.outputItem())) continue;
            li.add(r.copy());
        }
        return li;
    }

    public ArrayList<BlastFurnacePattern> getAllAlloyingRecipes() {
        ArrayList<BlastFurnacePattern> li = new ArrayList<BlastFurnacePattern>();
        for (BlastRecipe br : this.recipeList) {
            if (!br.isAlloying()) continue;
            li.add(br);
        }
        for (BlastCrafting bc : this.craftingList) {
            if (!bc.isAlloying()) continue;
            li.add(bc);
        }
        return li;
    }

    public Collection<BlastRecipe> getAllMainlineRecipes() {
        return Collections.unmodifiableCollection(this.recipeList);
    }

    public Collection<BlastCrafting> getAllCraftingRecipes() {
        return Collections.unmodifiableCollection(this.craftingList);
    }

    public Collection<BlastFurnacePattern> getAllRecipes() {
        ArrayList<BlastFurnacePattern> c = new ArrayList<BlastFurnacePattern>();
        c.addAll(this.recipeList);
        c.addAll(this.craftingList);
        return c;
    }

    @Override
    public void addAPIAlloying(ItemStack in1, float c1, int decr1, ItemStack in2, float c2, int decr2, ItemStack in3, float c3, int decr3, ItemStack main, ItemStack out, int req, boolean bonus, float xp, int temp) {
        BlastInput b1 = new BlastInput(in1, in1 != null ? c1 : 0.0f, decr1);
        BlastInput b2 = new BlastInput(in2, in2 != null ? c2 : 0.0f, decr2);
        BlastInput b3 = new BlastInput(in3, in3 != null ? c3 : 0.0f, decr3);
        BlastRecipe br = req > 0 ? new BlastRecipe(b1, b2, b3, main, req, out, bonus, xp, temp) : new BlastRecipe(b1, b2, b3, main, out, bonus, xp, temp);
        this.addRecipe(br, RecipeHandler.RecipeLevel.API);
    }

    @Override
    public void addAPIRecipe(ItemStack out, int temperature, IRecipe in, int speed, float xp) {
        BlastCrafting bc = new BlastCrafting(out, temperature, speed, in, xp);
        this.addCrafting(bc, RecipeHandler.RecipeLevel.API);
    }

    @Override
    public void addPostLoadRecipes() {
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        return this.recipeList.remove(recipe) | this.craftingList.remove(recipe);
    }

    public static final class BlastRecipe
    implements BlastFurnacePattern {
        public final BlastInput primary;
        public final BlastInput secondary;
        public final BlastInput tertiary;
        private final HashSet<KeyedItemStack> main = new HashSet();
        private final ArrayList<ItemStack> mainDisplay = new ArrayList();
        public final int mainRequired;
        private boolean matchNumberExactly;
        private final ItemStack output;
        public final boolean hasBonus;
        public final float xp;
        public final int temperature;
        private boolean alloy;

        private BlastRecipe(BlastInput in1, BlastInput in2, BlastInput in3, Item main, ItemStack out, boolean bonus, float xp, int temp) {
            this(in1, in2, in3, new ItemStack(main), out, bonus, xp, temp);
        }

        private BlastRecipe(BlastInput in1, BlastInput in2, BlastInput in3, Block main, ItemStack out, boolean bonus, float xp, int temp) {
            this(in1, in2, in3, new ItemStack(main), out, bonus, xp, temp);
        }

        private BlastRecipe(BlastInput in1, BlastInput in2, BlastInput in3, Collection<ItemStack> main, ItemStack out, boolean bonus, float xp, int temp) {
            this(in1, in2, in3, main, 1, out, bonus, xp, temp);
            this.matchNumberExactly = false;
        }

        private BlastRecipe(BlastInput in1, BlastInput in2, BlastInput in3, String main, ItemStack out, boolean bonus, float xp, int temp) {
            this(in1, in2, in3, main, 1, out, bonus, xp, temp);
            this.matchNumberExactly = false;
        }

        private BlastRecipe(BlastInput in1, BlastInput in2, BlastInput in3, ItemStack main, ItemStack out, boolean bonus, float xp, int temp) {
            this(in1, in2, in3, main, 1, out, bonus, xp, temp);
            this.matchNumberExactly = false;
        }

        private BlastRecipe(BlastInput in1, BlastInput in2, BlastInput in3, ItemStack main, int req, ItemStack out, boolean bonus, float xp, int temp) {
            this(in1, in2, in3, ReikaJavaLibrary.makeListFrom((Object)main), req, out, bonus, xp, temp);
        }

        private BlastRecipe(BlastInput in1, BlastInput in2, BlastInput in3, String main, int req, ItemStack out, boolean bonus, float xp, int temp) {
            this(in1, in2, in3, OreDictionary.getOres((String)main), req, out, bonus, xp, temp);
        }

        private BlastRecipe(BlastInput in1, BlastInput in2, BlastInput in3, Collection<ItemStack> main, int req, ItemStack out, boolean bonus, float xp, int temp) {
            this.primary = in1;
            this.secondary = in2;
            this.tertiary = in3;
            this.hasBonus = bonus;
            this.mainRequired = req;
            this.xp = xp;
            this.output = out;
            this.matchNumberExactly = true;
            this.temperature = temp;
            for (ItemStack is : main) {
                this.main.add(new KeyedItemStack(is).setSimpleHash(true).lock());
            }
            if (main.isEmpty()) {
                throw new IllegalArgumentException("Empty item list for main item in Blast Recipe " + this.toString());
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                this.mainDisplay.addAll(main);
            }
        }

        private BlastRecipe setAlloy() {
            this.alloy = true;
            return this;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack mainItemForDisplay() {
            int tick = (int)(System.currentTimeMillis() / 1000L % (long)this.mainDisplay.size());
            return this.mainDisplay.get(tick);
        }

        @Override
        public ItemStack outputItem() {
            return this.output != null ? this.output.func_77946_l() : null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.primary + " + ");
            sb.append(this.secondary + " + ");
            sb.append(this.tertiary + " + ");
            sb.append(this.matchNumberExactly ? "== " : ">= ");
            sb.append(this.mainRequired + " of ");
            sb.append(this.main);
            sb.append(" >> ");
            sb.append(this.output);
            if (this.hasBonus) {
                sb.append("*");
            }
            return sb.toString();
        }

        public int getNumberProduced(int main) {
            return this.mainRequired > 1 ? main / this.mainRequired : main;
        }

        public boolean matchInputExactly() {
            return this.matchNumberExactly;
        }

        public ArrayList<Integer> getValidInputNumbers() {
            ArrayList<Integer> li = new ArrayList<Integer>();
            for (int i = this.mainRequired; i <= 9; i += this.mainRequired) {
                if (i != this.mainRequired && this.matchInputExactly()) continue;
                li.add(i);
            }
            return li;
        }

        @Override
        public boolean isValidInputForSlot(int slot, ItemStack is) {
            if (slot == 0) {
                return this.primary.match(is);
            }
            if (slot == 11) {
                return this.secondary.match(is);
            }
            if (slot == 14) {
                return this.tertiary.match(is);
            }
            if (slot >= 1 && slot < 10) {
                return this.isValidMainItem(is);
            }
            return false;
        }

        public boolean isValidMainItem(ItemStack is) {
            return this.main.contains(new KeyedItemStack(is).setSimpleHash(true));
        }

        public Collection<ItemStack> getMainItems() {
            ArrayList<ItemStack> c = new ArrayList<ItemStack>();
            for (KeyedItemStack ks : this.main) {
                c.add(ks.getItemStack());
            }
            return c;
        }

        @Override
        public float getXPPerProduct() {
            return this.xp;
        }

        @Override
        public boolean isAlloying() {
            return this.alloy;
        }

        @Override
        public int getRequiredTemperature() {
            return this.temperature;
        }

        @Override
        public String getUniqueID() {
            return "RECIPE/" + this.primary + "&" + this.secondary + "&" + this.tertiary + ">" + RecipeHandler.fullIDKeys(this.main) + "^" + RecipeHandler.fullID(this.output) + "?" + this.hasBonus;
        }

        @Override
        public String getAllInfo() {
            return "Mainline production, " + this.toString();
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            if (this.primary != null) {
                li.addAll(this.primary.getItems());
            }
            if (this.secondary != null) {
                li.addAll(this.secondary.getItems());
            }
            if (this.tertiary != null) {
                li.addAll(this.tertiary.getItems());
            }
            li.addAll(this.getMainItems());
            li.add(this.output);
            return li;
        }
    }

    public static final class BlastInput {
        private final HashSet<KeyedItemStack> items = new HashSet();
        public final float chanceToUse;
        public final int numberToUse;
        private final ArrayList<ItemStack> display = new ArrayList();

        private BlastInput(Block in, float chance, int toDecr) {
            this(new ItemStack(in), chance, toDecr);
        }

        private BlastInput(Item in, float chance, int toDecr) {
            this(new ItemStack(in), chance, toDecr);
        }

        private BlastInput(ItemStack in, float chance, int toDecr) {
            this(in != null ? ReikaJavaLibrary.makeListFrom((Object)in) : null, chance, toDecr);
        }

        private BlastInput(String ore, float chance, int toDecr) {
            this(OreDictionary.getOres((String)ore), chance, toDecr);
        }

        private BlastInput(Collection<ItemStack> in, float chance, int toDecr) {
            if (in != null) {
                for (ItemStack is : in) {
                    this.items.add(new KeyedItemStack(is).setSimpleHash(true).lock());
                }
            }
            this.chanceToUse = chance / 100.0f;
            this.numberToUse = toDecr;
            if (in != null && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                this.display.addAll(in);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack getItemForDisplay() {
            if (!this.exists()) {
                return null;
            }
            int tick = (int)(System.currentTimeMillis() / 1000L % (long)this.display.size());
            return ReikaItemHelper.getSizedItemStack((ItemStack)this.display.get(tick), (int)this.numberToUse);
        }

        public String toString() {
            return RecipeHandler.fullIDKeys(this.items) + " x" + this.numberToUse + "@" + this.chanceToUse + "%";
        }

        public boolean match(ItemStack in) {
            return !this.exists() ? in == null : this.isItemCorrect(in) && in.field_77994_a >= this.numberToUse;
        }

        private boolean isItemCorrect(ItemStack in) {
            return in != null && this.items.contains(new KeyedItemStack(in).setSimpleHash(true));
        }

        public boolean exists() {
            return !this.items.isEmpty();
        }

        public Collection<ItemStack> getItems() {
            ArrayList<ItemStack> c = new ArrayList<ItemStack>();
            for (KeyedItemStack ks : this.items) {
                c.add(ks.getItemStack());
            }
            return c;
        }
    }

    public static interface BlastFurnacePattern
    extends RecipeHandler.MachineRecipe {
        public ItemStack outputItem();

        public boolean isValidInputForSlot(int var1, ItemStack var2);

        public float getXPPerProduct();

        public boolean isAlloying();

        public int getRequiredTemperature();
    }

    public static final class BlastCrafting
    implements BlastFurnacePattern {
        public final int temperature;
        private final IRecipe recipe;
        private final ItemStack output;
        public final int speed;
        public final float xp;
        private boolean alloy;

        private BlastCrafting(ItemStack out, int temp, int speed, IRecipe ir, float xp) {
            this.recipe = ir;
            this.output = out;
            this.temperature = temp;
            this.speed = speed;
            this.xp = xp;
        }

        private BlastCrafting setAlloying() {
            this.alloy = true;
            return this;
        }

        @Override
        public final ItemStack outputItem() {
            return this.output.func_77946_l();
        }

        public BlastCrafting copy() {
            BlastCrafting bc = new BlastCrafting(this.output, this.temperature, this.speed, this.recipe, this.xp);
            bc.alloy = this.alloy;
            return bc;
        }

        public boolean matches(InventoryCrafting ic, int temperature) {
            return temperature >= this.temperature && this.recipe.func_77569_a(ic, null);
        }

        public boolean usesItem(ItemStack is) {
            return ReikaItemHelper.collectionContainsItemStack((Collection)ReikaRecipeHelper.getAllItemsInRecipe((IRecipe)this.recipe), (ItemStack)is);
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack[] getArrayForDisplay() {
            return ReikaRecipeHelper.getPermutedRecipeArray((IRecipe)this.recipe);
        }

        @Override
        public boolean isValidInputForSlot(int slot, ItemStack is) {
            if (slot == 0 || slot > 9) {
                return false;
            }
            return ReikaRecipeHelper.getRecipeLocationIndices((IRecipe)this.recipe, (ItemStack)is).contains(slot - 1);
        }

        @Override
        public float getXPPerProduct() {
            return this.xp;
        }

        @Override
        public boolean isAlloying() {
            return this.alloy;
        }

        @Override
        public int getRequiredTemperature() {
            return this.temperature;
        }

        @Override
        public String getUniqueID() {
            return "CRAFT/" + this.recipe.getClass().getName() + "^" + ReikaRecipeHelper.toString((IRecipe)this.recipe) + ">" + this.output;
        }

        @Override
        public String getAllInfo() {
            return "Crafting " + this.output + ", Recipe=" + ReikaRecipeHelper.toString((IRecipe)this.recipe) + " @ " + this.temperature + "C; xp=" + this.xp + ", speed=" + this.speed + ", alloy:" + this.alloy;
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>(ReikaRecipeHelper.getAllItemsInRecipe((IRecipe)this.recipe));
            li.add(this.output);
            return li;
        }
    }
}

