/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.SensitiveFluidRegistry;
import Reika.DragonAPI.ModInteract.DeepInteract.SensitiveItemRegistry;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public abstract class RecipeHandler {
    private static final boolean enableRegistries = ConfigRegistry.RECIPEMOD.getState();
    private final MultiMap<RecipeLevel, String> recipesByLevel = new MultiMap((MultiMap.CollectionFactory)new MultiMap.HashSetFactory());
    private final HashMap<String, RecipeLevel> recipeLevels = new HashMap();
    private final HashBiMap<MachineRecipe, String> recipeKeys = HashBiMap.create();
    public final MachineRegistry machine;

    protected RecipeHandler(MachineRegistry m) {
        this.machine = m;
    }

    protected final void onAddRecipe(MachineRecipe recipe, RecipeLevel rl) {
        if (enableRegistries) {
            String s = (String)this.recipeKeys.get((Object)recipe);
            if (s == null) {
                this.generateKey(recipe);
            }
            this.recipesByLevel.addValue((Object)rl, (Object)s);
            this.recipeLevels.put(s, rl);
        }
    }

    private void generateKey(MachineRecipe recipe) {
        String s = this.machine.name() + "$" + recipe.getClass().getSimpleName() + "#(" + recipe.getUniqueID();
        if (RotaryCraft.logger.shouldDebug()) {
            ReikaJavaLibrary.pConsole((Object)("Recipe Loaded: " + recipe + "=" + s));
        }
        if (this.recipeKeys.containsValue((Object)s)) {
            MachineRecipe pre = (MachineRecipe)this.recipeKeys.inverse().get((Object)s);
            if (pre == null || pre.equals(recipe)) {
                return;
            }
            RotaryCraft.logger.logError((Object)("Found duplicate recipe key when adding recipe " + recipe.getAllInfo() + " in place of " + pre.getAllInfo()));
            RotaryCraft.logger.log((Object)"Original Recipe Items:");
            for (ItemStack is : pre.getAllUsedItems()) {
                RotaryCraft.logger.log((Object)(is + " from mod '" + ReikaItemHelper.getRegistrantMod((ItemStack)is) + "', NBT=" + is.field_77990_d));
            }
            RotaryCraft.logger.log((Object)"New Recipe Items:");
            for (ItemStack is : recipe.getAllUsedItems()) {
                RotaryCraft.logger.log((Object)(is + " from mod '" + ReikaItemHelper.getRegistrantMod((ItemStack)is) + "', NBT=" + is.field_77990_d));
            }
            throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "Two recipes have the same key: '" + s + "'");
        }
        this.recipeKeys.put((Object)recipe, (Object)s);
    }

    protected static final String fullIDKeys(Collection<KeyedItemStack> c) {
        StringBuilder sb = new StringBuilder();
        for (KeyedItemStack is : c) {
            sb.append(RecipeHandler.fullID(is.getItemStack()));
            sb.append("|");
        }
        return sb.toString();
    }

    protected static final String fullID(Collection<ItemStack> c) {
        StringBuilder sb = new StringBuilder();
        for (ItemStack is : c) {
            sb.append(RecipeHandler.fullID(is));
            sb.append("|");
        }
        return sb.toString();
    }

    protected static final String fullID(ItemStack is) {
        if (is == null) {
            return "[null]";
        }
        if (is.func_77973_b() == null) {
            return "[null-item stack]";
        }
        return is.field_77994_a + "x" + Item.field_150901_e.func_148750_c((Object)is.func_77973_b()) + "@" + is.func_77960_j() + "{" + is.field_77990_d + "}[" + ReikaItemHelper.getRegistrantMod((ItemStack)is) + "]";
    }

    protected final Collection getRecipes(RecipeLevel rl) {
        return this.recipesByLevel.get((Object)rl);
    }

    public final RecipeLevel getRecipeLevel(String rec) {
        return this.recipeLevels.get(rec);
    }

    public final boolean removeRecipe(String rec) {
        RecipeLevel rl = this.getRecipeLevel(rec);
        RecipeModificationPower power = RecipeHandler.getModificationPower();
        if (power.canRemove(rl)) {
            MachineRecipe recipe = (MachineRecipe)this.recipeKeys.inverse().get((Object)rec);
            if (rec == null) {
                RotaryCraft.logger.log((Object)("Recipe removal of '" + rec + "' from " + (Object)((Object)this.machine) + " not possible; No such recipe with that key."));
                return false;
            }
            try {
                if (this.removeRecipe(rec)) {
                    this.recipesByLevel.remove((Object)rl, (Object)rec);
                    this.recipeLevels.remove(rec);
                    return true;
                }
                RotaryCraft.logger.log((Object)("Recipe removal of '" + rec + "' from " + (Object)((Object)this.machine) + " failed; Potential code error."));
                return false;
            }
            catch (Exception e) {
                RotaryCraft.logger.log((Object)("Recipe removal of '" + rec + "' from " + (Object)((Object)this.machine) + " failed and threw an exception; Potential code error."));
                e.printStackTrace();
                return false;
            }
        }
        RotaryCraft.logger.log((Object)("Recipe removal of '" + rec + "' from " + (Object)((Object)this.machine) + " rejected; This is a '" + (Object)((Object)rl) + "' recipe and cannot be modified with '" + (Object)((Object)power) + "' modify power."));
        return false;
    }

    public abstract void addPostLoadRecipes();

    protected abstract boolean removeRecipe(MachineRecipe var1);

    private static RecipeModificationPower getRequiredPowerForOutput(ItemStack is) {
        if (!ReikaItemHelper.getNamespace((Item)is.func_77973_b()).contains("RotaryCraft")) {
            return RecipeModificationPower.DEFAULT;
        }
        if (!ReikaItemHelper.getNamespace((Item)is.func_77973_b()).contains("ReactorCraft")) {
            return RecipeModificationPower.DEFAULT;
        }
        if (!ReikaItemHelper.getNamespace((Item)is.func_77973_b()).contains("ElectriCraft")) {
            return RecipeModificationPower.DEFAULT;
        }
        return SensitiveItemRegistry.instance.contains(is) ? RecipeModificationPower.FULL : RecipeModificationPower.NORMAL;
    }

    private static RecipeModificationPower getRequiredPowerForOutput(Fluid f) {
        return SensitiveFluidRegistry.instance.contains(f) ? RecipeModificationPower.FULL : RecipeModificationPower.DEFAULT;
    }

    public static boolean isOutputPermitted(ItemStack is) {
        return RecipeHandler.getModificationPower().ordinal() <= RecipeHandler.getRequiredPowerForOutput(is).ordinal();
    }

    public static boolean isOutputPermitted(Fluid f) {
        return RecipeHandler.getModificationPower().ordinal() <= RecipeHandler.getRequiredPowerForOutput(f).ordinal();
    }

    private static RecipeModificationPower getModificationPower() {
        int get = Math.min(RecipeModificationPower.DEFAULT.ordinal(), Math.max(0, ConfigRegistry.getRecipeModifyPower()));
        return RecipeModificationPower.list[RecipeModificationPower.DEFAULT.ordinal() - get];
    }

    protected static interface MachineRecipe {
        public String getUniqueID();

        public Collection<ItemStack> getAllUsedItems();

        public String getAllInfo();
    }

    private static enum RecipeModificationPower {
        FULL(RecipeLevel.CORE),
        STRONG(RecipeLevel.PROTECTED),
        NORMAL(RecipeLevel.PERIPHERAL),
        DEFAULT(RecipeLevel.CUSTOM);

        private final RecipeLevel maxLevel;
        private static final RecipeModificationPower[] list;

        private RecipeModificationPower(RecipeLevel rl) {
            this.maxLevel = rl;
        }

        public final boolean canRemove(RecipeLevel rl) {
            return rl.ordinal() >= this.maxLevel.ordinal();
        }

        static {
            list = RecipeModificationPower.values();
        }
    }

    public static enum RecipeLevel {
        CORE,
        PROTECTED,
        PERIPHERAL,
        MODINTERACT,
        API,
        CUSTOM;

        private static final RecipeLevel[] list;

        static {
            list = RecipeLevel.values();
        }
    }
}

