/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaLiquidRenderer;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesBlastFurnace;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class MachineRecipeRenderer {
    public static final MachineRecipeRenderer instance = new MachineRecipeRenderer();
    private final FontRenderer font;
    private final RenderItem itemRender;
    private final RenderBlocks rb;
    private final ReikaGuiAPI gui;

    private MachineRecipeRenderer() {
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.itemRender = new RenderItem();
        this.rb = new RenderBlocks();
        this.gui = ReikaGuiAPI.instance;
    }

    private int getIndex(List li) {
        long time = System.currentTimeMillis();
        int index = (int)(time / 500L % (long)li.size());
        return index;
    }

    public void drawCompressor(int x, int y, ItemStack in, int x2, int y2, ItemStack out) {
        int j = this.gui.getScreenXInset();
        int k = this.gui.getScreenYInset();
        if (in != null) {
            for (int ii = 0; ii < 4; ++ii) {
                this.gui.drawItemStackWithTooltip(this.itemRender, this.font, in, x + j, y + k + ii * 18);
            }
        }
        if (out != null) {
            this.gui.drawItemStackWithTooltip(this.itemRender, this.font, out, x2 + j, y2 + k);
        }
    }

    public void drawBlastFurnaceCrafting(int x, int y, int x2, int y2, ItemStack output) {
        ArrayList<RecipesBlastFurnace.BlastCrafting> c = RecipesBlastFurnace.getRecipes().getAllCraftingMaking(output);
        if (c.isEmpty()) {
            RotaryCraft.logger.logError((Object)("Tried drawing a Blast Furnace Crafting of " + output + ", but no recipes for it exist!"));
            return;
        }
        int n = (int)(System.nanoTime() / 1000000000L) % c.size();
        this.drawBlastFurnaceCrafting(x, y, x2, y2, (RecipesBlastFurnace.BlastCrafting)c.get(n));
    }

    public void drawBlastFurnaceCrafting(int x, int y, int x2, int y2, RecipesBlastFurnace.BlastCrafting r) {
        ItemStack[] items = r.getArrayForDisplay();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack is = items[i + j * 3];
                if (is == null) continue;
                this.gui.drawItemStackWithTooltip(this.itemRender, this.font, is, x + 18 * i, y + 18 * j - 8);
            }
        }
        this.gui.drawItemStackWithTooltip(this.itemRender, this.font, r.outputItem(), x2 + 4, y2 - 4);
    }

    public void drawBlastFurnace(int x, int y, int x2, int y2, RecipesBlastFurnace.BlastRecipe r) {
        int j = this.gui.getScreenXInset();
        int k = this.gui.getScreenYInset();
        ArrayList<Integer> inputs = r.getValidInputNumbers();
        int index = this.getIndex(inputs);
        int num = inputs.get(index);
        for (int i = 0; i < 3; ++i) {
            for (int n = 0; n < 3; ++n) {
                if (i * 3 + n >= num) continue;
                ItemStack is = r.mainItemForDisplay();
                this.gui.drawItemStackWithTooltip(this.itemRender, this.font, is, x + j + 18 * n, y + k + i * 18);
            }
        }
        if (r.primary.exists()) {
            this.gui.drawItemStackWithTooltip(this.itemRender, this.font, r.primary.getItemForDisplay(), x + j - 36, y + k + 18);
        }
        if (r.secondary.exists()) {
            this.gui.drawItemStackWithTooltip(this.itemRender, this.font, r.secondary.getItemForDisplay(), x + j - 36, y + k + 37);
        }
        if (r.tertiary.exists()) {
            this.gui.drawItemStackWithTooltip(this.itemRender, this.font, r.tertiary.getItemForDisplay(), x + j - 36, y + k - 1);
        }
        ItemStack out = ReikaItemHelper.getSizedItemStack((ItemStack)r.outputItem(), (int)r.getNumberProduced(num));
        this.gui.drawItemStackWithTooltip(this.itemRender, this.font, out, x2 + j, y2 + k);
    }

    public void drawExtractor(int x, int y, ItemStack[] in, int x2, int y2, ItemStack[] out) {
        int ij;
        int j = this.gui.getScreenXInset();
        int k = this.gui.getScreenYInset();
        for (ij = 0; ij < 4; ++ij) {
            this.gui.drawItemStackWithTooltip(this.itemRender, this.font, in[ij], x + j + 36 * ij, y + k);
        }
        for (ij = 0; ij < 4; ++ij) {
            this.gui.drawItemStackWithTooltip(this.itemRender, this.font, out[ij], x2 + j + 36 * ij, y2 + k);
        }
    }

    public void drawFermenter(int x, int y, ItemStack[] in, int x2, int y2, ItemStack out) {
        int j = this.gui.getScreenXInset();
        int k = this.gui.getScreenYInset();
        ReikaLiquidRenderer.bindFluidTexture((Fluid)FluidRegistry.WATER);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int h = 16 - (int)(System.nanoTime() / 200000000L) % 17;
        this.gui.func_94065_a(x, y + 10 + 16 - h, FluidRegistry.WATER.getStillIcon(), 16, h);
        this.gui.drawItemStackWithTooltip(this.itemRender, this.font, in[0], x + j, y + k);
        this.gui.drawItemStackWithTooltip(this.itemRender, this.font, in[1], x + j, y + 36 + k);
        if (out != null) {
            this.gui.drawItemStackWithTooltip(this.itemRender, this.font, out, x2 + 4 + j, y2 + 4 + k);
        }
    }
}

