/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.DragonOptions;
import Reika.RotaryCraft.Blocks.BlockFlywheel;
import Reika.RotaryCraft.Blocks.BlockGearbox;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.IntHashMap;

public class OldTextureLoader {
    public static final OldTextureLoader instance = new OldTextureLoader();
    private final EnumMap<MachineRegistry, IconSide> machineIcons = new EnumMap(MachineRegistry.class);
    private final IntHashMap textureIndices = new IntHashMap();

    private OldTextureLoader() {
        this.machineIcons.put(MachineRegistry.SHAFT, new IconSide(8).addSideTexture(2, 9).addSideTexture(3, 9));
        this.machineIcons.put(MachineRegistry.GEARBOX, new IconSide(8).addSideTexture(0, 10).addSideTexture(1, 10).addSideTexture(2, 9).addSideTexture(3, 9));
        this.machineIcons.put(MachineRegistry.BEDROCKBREAKER, new IconSide(1).addSideTexture(2, 2).addSideTexture(3, 3).addSideTexture(1, 4));
        this.machineIcons.put(MachineRegistry.FERMENTER, new IconSide(20).addSideTexture(2, 21).addSideTexture(3, 22));
        this.machineIcons.put(MachineRegistry.CLUTCH, new IconSide(25).addSideTexture(2, 26).addSideTexture(3, 26));
        this.machineIcons.put(MachineRegistry.BEVELGEARS, new IconSide(27).addSideTexture(3, 28).addSideTexture(5, 28).addSideTexture(1, 28));
        this.machineIcons.put(MachineRegistry.FLOODLIGHT, new IconSide(29).addSideTexture(3, 31).addSideTexture(4, 30).addSideTexture(5, 30).addSideTexture(0, 30).addSideTexture(1, 30));
        this.machineIcons.put(MachineRegistry.SPLITTER, new IconSide(1).addSideTexture(1, 17).addSideTexture(0, 18).addSideTexture(3, 19).addSideTexture(4, 19).addSideTexture(5, 19));
        this.machineIcons.put(MachineRegistry.GRINDER, new IconSide(49).addSideTexture(2, 50).addSideTexture(3, 51));
        this.machineIcons.put(MachineRegistry.HEATRAY, new IconSide(53).addSideTexture(2, 54));
        this.machineIcons.put(MachineRegistry.BORER, new IconSide(57).addSideTexture(2, 58).addSideTexture(3, 59));
        this.machineIcons.put(MachineRegistry.FLYWHEEL, new IconSide(23).addSideTexture(2, 24));
        this.machineIcons.put(MachineRegistry.ENGINE, new IconSide(1).addSideTexture(2, 14).addSideTexture(3, 15));
        this.machineIcons.put(MachineRegistry.DYNAMOMETER, new IconSide(34).addSideTexture(2, 35).addSideTexture(3, 35));
    }

    public boolean loadOldTextures() {
        if (!DragonOptions.APRIL.getState()) {
            return false;
        }
        Calendar c = Calendar.getInstance();
        return c.get(2) == 3 && c.get(5) <= 2;
    }

    public IIcon getOldTexture(Block b, int meta, int side) {
        return this.getIconByIndex(this.getIndex(b, meta, side));
    }

    public int getIndex(Block b, int meta, int side) {
        int index;
        MachineRegistry m = MachineRegistry.getMachineFromIDandMetadata(b, meta);
        IconSide ics = this.machineIcons.get((Object)m);
        int n = ics == null ? -1 : (index = ics.sideTextures.containsKey(side) ? (Integer)ics.sideTextures.get(side) : ics.fallback);
        if (b instanceof BlockGearbox && index == 10) {
            index += meta;
        }
        if (b instanceof BlockFlywheel) {
            index += 16 * (meta / 4);
        }
        return index;
    }

    private IIcon getIconByIndex(int index) {
        IIcon ico = null;
        ico = index >= 0 ? (IIcon)this.textureIndices.func_76041_a(index) : (IIcon)this.textureIndices.func_76041_a(-1);
        return ico != null ? ico : (IIcon)this.textureIndices.func_76041_a(-1);
    }

    public void reloadOldTextures(TextureMap map) {
        if (map.func_130086_a() == 0) {
            for (int i = 0; i < 256; ++i) {
                this.textureIndices.func_76038_a(i, (Object)map.func_94245_a(this.getName(i)));
            }
            this.textureIndices.func_76038_a(-1, (Object)map.func_94245_a(this.getName(255)));
        }
    }

    private String getName(int idx) {
        int row = idx / 16;
        int col = idx % 16;
        return "rotarycraft:old/tile" + col + "_" + row;
    }

    private static class IconSide {
        public final int fallback;
        private HashMap<Integer, Integer> sideTextures = new HashMap();

        private IconSide(int f) {
            this.fallback = f;
        }

        private IconSide addSideTexture(int side, int tex) {
            this.sideTextures.put(side, tex);
            return this;
        }

        public int getTexture(int idx) {
            return this.sideTextures.containsKey(idx) ? this.sideTextures.get(idx) : 255;
        }
    }
}

