/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thermalexpansion.handlers;

import cofh.thermalexpansion.util.crafting.FurnaceManager;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.thermalexpansion.ThermalHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Furnace")
public class Furnace {
    public static final String name = "Thermal Expansion Furnace";

    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack output) {
        if (input == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (FurnaceManager.recipeExists((ItemStack)InputHelper.toStack(input))) {
            LogHelper.logWarning(String.format("Duplicate %s Recipe found for %s. Command ignored!", name, LogHelper.getStackDescription(InputHelper.toStack(input))));
            return;
        }
        FurnaceManager.RecipeFurnace recipe = ReflectionHelper.getInstance(ThermalHelper.furanceRecipe, InputHelper.toStack(input), InputHelper.toStack(output), energy);
        if (recipe != null) {
            MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
        } else {
            LogHelper.logError(String.format("Error while creating instance for %s recipe.", name));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        LinkedList<FurnaceManager.RecipeFurnace> recipes = new LinkedList<FurnaceManager.RecipeFurnace>();
        for (FurnaceManager.RecipeFurnace recipe : FurnaceManager.getRecipeList()) {
            if (recipe == null || !StackHelper.matches(input, InputHelper.toIItemStack(recipe.getInput()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s.", name, input.toString()));
        }
    }

    @ZenMethod
    public static void refreshRecipes() {
        MineTweakerAPI.apply((IUndoableAction)new Refresh());
    }

    private static class Refresh
    implements IUndoableAction {
        private Refresh() {
        }

        public void apply() {
            FurnaceManager.refreshRecipes();
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Refreshing Thermal Expansion Furnace recipes";
        }

        public void undo() {
        }

        public String describeUndo() {
            return "Ignoring undo of Thermal Expansion Furnace recipe refresh";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    extends BaseListRemoval<FurnaceManager.RecipeFurnace> {
        public Remove(List<FurnaceManager.RecipeFurnace> recipes) {
            super(Furnace.name, null, recipes);
        }

        @Override
        public void apply() {
            for (FurnaceManager.RecipeFurnace recipe : this.recipes) {
                boolean removed = FurnaceManager.removeRecipe((ItemStack)recipe.getInput());
                if (!removed) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (FurnaceManager.RecipeFurnace recipe : this.successful) {
                FurnaceManager.addRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getInput(), (ItemStack)recipe.getOutput(), (boolean)false);
            }
        }

        @Override
        protected boolean equals(FurnaceManager.RecipeFurnace recipe, FurnaceManager.RecipeFurnace otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        protected String getRecipeInfo(FurnaceManager.RecipeFurnace recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }

    private static class Add
    extends BaseListAddition<FurnaceManager.RecipeFurnace> {
        public Add(FurnaceManager.RecipeFurnace recipe) {
            super(Furnace.name, null);
            this.recipes.add(recipe);
        }

        @Override
        public void apply() {
            for (FurnaceManager.RecipeFurnace recipe : this.recipes) {
                boolean applied = FurnaceManager.addRecipe((int)recipe.getEnergy(), (ItemStack)recipe.getInput(), (ItemStack)recipe.getOutput(), (boolean)false);
                if (!applied) continue;
                this.successful.add(recipe);
            }
        }

        @Override
        public void undo() {
            for (FurnaceManager.RecipeFurnace recipe : this.recipes) {
                FurnaceManager.removeRecipe((ItemStack)recipe.getInput());
            }
        }

        @Override
        protected boolean equals(FurnaceManager.RecipeFurnace recipe, FurnaceManager.RecipeFurnace otherRecipe) {
            return ThermalHelper.equals(recipe, otherRecipe);
        }

        @Override
        protected String getRecipeInfo(FurnaceManager.RecipeFurnace recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }
}

