/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.research;

import minetweaker.IUndoableAction;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.thaumcraft.ThaumcraftHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionEnchantmentRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;

public class AddPage
implements IUndoableAction {
    String key;
    String tab;
    ResearchPage page;
    ResearchPage[] oldPages;
    ResearchPage.PageType type;
    ItemStack target;
    Enchantment enchant;

    public AddPage(String res, ResearchPage.PageType a, Object b) {
        this.key = res;
        this.tab = ThaumcraftHelper.getResearchTab(this.key);
        this.type = a;
        if (this.type == ResearchPage.PageType.TEXT) {
            this.page = new ResearchPage((String)b);
        } else if (this.type == ResearchPage.PageType.INFUSION_ENCHANTMENT) {
            this.enchant = (Enchantment)b;
        }
        if (b instanceof ItemStack) {
            this.target = (ItemStack)b;
        }
    }

    public void apply() {
        IRecipe theCraft;
        if (this.type == ResearchPage.PageType.NORMAL_CRAFTING) {
            for (Object craft : CraftingManager.func_77594_a().func_77592_b()) {
                if (!(craft instanceof IRecipe) || (theCraft = (IRecipe)craft).func_77571_b() == null || !StackHelper.areEqual(theCraft.func_77571_b(), this.target)) continue;
                this.page = new ResearchPage(theCraft);
                break;
            }
        } else if (this.type == ResearchPage.PageType.ARCANE_CRAFTING) {
            for (Object craft : ThaumcraftApi.getCraftingRecipes()) {
                if (!(craft instanceof IArcaneRecipe) || (theCraft = (IArcaneRecipe)craft).getRecipeOutput() == null || !StackHelper.areEqual(theCraft.getRecipeOutput(), this.target)) continue;
                this.page = new ResearchPage((IArcaneRecipe)theCraft);
                break;
            }
        } else if (this.type == ResearchPage.PageType.CRUCIBLE_CRAFTING) {
            for (Object craft : ThaumcraftApi.getCraftingRecipes()) {
                if (!(craft instanceof CrucibleRecipe) || (theCraft = (CrucibleRecipe)craft).getRecipeOutput() == null || !StackHelper.areEqual(theCraft.getRecipeOutput(), this.target)) continue;
                this.page = new ResearchPage((CrucibleRecipe)theCraft);
                break;
            }
        } else if (this.type == ResearchPage.PageType.INFUSION_CRAFTING) {
            for (Object craft : ThaumcraftApi.getCraftingRecipes()) {
                if (!(craft instanceof InfusionRecipe) || (theCraft = (InfusionRecipe)craft).getRecipeOutput() == null || !(theCraft.getRecipeOutput() instanceof ItemStack) || !StackHelper.areEqual((ItemStack)theCraft.getRecipeOutput(), this.target)) continue;
                this.page = new ResearchPage((InfusionRecipe)theCraft);
                break;
            }
        } else if (this.type == ResearchPage.PageType.INFUSION_ENCHANTMENT) {
            for (Object craft : ThaumcraftApi.getCraftingRecipes()) {
                if (!(craft instanceof InfusionEnchantmentRecipe) || (theCraft = (InfusionEnchantmentRecipe)craft).getEnchantment() == null || theCraft.getEnchantment() != this.enchant) continue;
                this.page = new ResearchPage((InfusionEnchantmentRecipe)theCraft);
                break;
            }
        }
        if (this.page == null) {
            return;
        }
        this.oldPages = ((ResearchItem)((ResearchCategoryList)ResearchCategories.researchCategories.get((Object)this.tab)).research.get(this.key)).getPages();
        if (this.oldPages == null) {
            this.oldPages = new ResearchPage[0];
        }
        ResearchPage[] newPages = new ResearchPage[this.oldPages.length + 1];
        for (int x = 0; x < this.oldPages.length; ++x) {
            newPages[x] = this.oldPages[x];
        }
        newPages[this.oldPages.length] = this.page;
        ((ResearchItem)((ResearchCategoryList)ResearchCategories.researchCategories.get((Object)this.tab)).research.get(this.key)).setPages(newPages);
    }

    public String describe() {
        return "Adding Research Page to " + this.key;
    }

    public boolean canUndo() {
        return this.oldPages != null;
    }

    public void undo() {
        ((ResearchItem)((ResearchCategoryList)ResearchCategories.researchCategories.get((Object)this.tab)).research.get(this.key)).setPages(this.oldPages);
    }

    public String describeUndo() {
        return "Removing Page from " + this.key;
    }

    public String getOverrideKey() {
        return null;
    }
}

