/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.World;

import Reika.DragonAPI.Interfaces.OreGenerator;
import Reika.DragonAPI.Interfaces.Registry.OreEnum;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.ReactorCraft.Registry.ReactorOres;
import Reika.ReactorCraft.World.BasicReactorOreGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class ReactorOreGenerator
implements RetroactiveGenerator {
    public static final ReactorOreGenerator instance = new ReactorOreGenerator();
    public final ArrayList<OreGenerator> generators = new ArrayList();

    private ReactorOreGenerator() {
        this.generators.add(new BasicReactorOreGenerator());
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkgen, IChunkProvider provider) {
        for (int i = 0; i < ReactorOres.oreList.length; ++i) {
            ReactorOres ore = ReactorOres.oreList[i];
            if (!ore.canGenerateInChunk(world, chunkX, chunkZ)) continue;
            for (OreGenerator gen : this.generators) {
                gen.generateOre((OreEnum)ore, random, world, chunkX, chunkZ);
            }
        }
    }

    public String getIDString() {
        return "ReactorCraft Ores";
    }

    public boolean canGenerateAt(Random rand, World world, int chunkX, int chunkZ) {
        return true;
    }
}

