/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.FlyingBlocksExplosion;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Power.ReikaEUHelper;
import Reika.DragonAPI.ModInteract.Power.ReikaRFHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.PowerTypes;
import Reika.ReactorCraft.Auxiliary.MultiBlockTile;
import Reika.ReactorCraft.Base.BlockMultiBlock;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityTurbineCore;
import Reika.RotaryCraft.API.Interfaces.Screwdriverable;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"cofh.api.energy.IEnergyHandler", "ic2.api.energy.tile.IEnergySource"})
public class TileEntityReactorGenerator
extends TileEntityReactorBase
implements IEnergyHandler,
IEnergySource,
Screwdriverable,
MultiBlockTile {
    private ForgeDirection facingDir;
    private long power;
    private int torquein;
    private int omegain;
    private Modes mode = Modes.RF;
    private boolean hasMultiblock;

    @Override
    public boolean hasMultiBlock() {
        return this.hasMultiblock || DragonAPICore.debugtest;
    }

    @Override
    public void setHasMultiBlock(boolean has) {
        if (this.hasMultiblock && !has) {
            this.testBreakageFailure();
        }
        this.hasMultiblock = has;
    }

    private void testBreakageFailure() {
        if (this.omegain > 1024) {
            this.fail(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.func_72820_D() % 128L == 0L) {
            ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
        }
        if (this.hasMultiblock || DragonAPICore.debugtest) {
            this.getPower(world, x, y, z, meta);
        } else {
            this.torquein = 0;
            this.omegain = 0;
        }
        this.power = (long)this.omegain * (long)this.torquein;
        if (this.power > 0L) {
            ForgeDirection write = this.getFacing().getOpposite();
            TileEntity tile = this.getAdjacentTileEntity(write);
            switch (this.mode) {
                case RF: {
                    if (tile instanceof IEnergyReceiver) {
                        IEnergyReceiver rc = (IEnergyReceiver)tile;
                        int used = rc.receiveEnergy(this.getFacing(), (int)this.getGenUnits(), false);
                        break;
                    }
                    if (!(tile instanceof IEnergyHandler)) break;
                    IEnergyHandler rc = (IEnergyHandler)tile;
                    int used = rc.receiveEnergy(this.getFacing(), (int)this.getGenUnits(), false);
                    break;
                }
                case EU: {
                    IEnergySink rc;
                    if (!(tile instanceof IEnergySink) || !(rc = (IEnergySink)tile).acceptsEnergyFrom((TileEntity)this, this.getFacing())) break;
                    double leftover = rc.injectEnergy(this.getFacing(), (double)((int)this.getGenUnits()), (double)this.getSourceTier());
                }
            }
        }
    }

    private void fail(World world, int x, int y, int z) {
        int l = this.getGeneratorLength() / 2;
        world.func_147468_f(x, y, z);
        double dx = (double)x + 0.5 + (double)(this.getFacing().offsetX * l);
        double dz = (double)z + 0.5 + (double)(this.getFacing().offsetZ * l);
        new FlyingBlocksExplosion(world, dx, (double)y + 0.5, dz, 12.0f).doExplosion();
    }

    public static int getGeneratorLength() {
        return 10;
    }

    private void getPower(World world, int x, int y, int z, int meta) {
        int dz;
        int dy;
        int len = this.getGeneratorLength();
        int dx = x + this.getFacing().offsetX * len;
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, dx, dy = y + this.getFacing().offsetY * len, dz = z + this.getFacing().offsetZ * len);
        if (r != null && r.isTurbine()) {
            TileEntityTurbineCore te = (TileEntityTurbineCore)this.getTileEntity(dx, dy, dz);
            this.power = te.getPower();
            this.omegain = te.getOmega();
            this.torquein = te.getTorque();
        } else {
            this.torquein = 0;
            this.omegain = 0;
            this.power = 0L;
        }
    }

    public ForgeDirection getFacing() {
        return this.facingDir != null ? this.facingDir : ForgeDirection.EAST;
    }

    public void setFacing(ForgeDirection dir) {
        this.facingDir = dir;
    }

    @Override
    public int getIndex() {
        return ReactorTiles.GENERATOR.ordinal();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + 0.5 * ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omegain + 1), (int)2), (double)1.05));
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.facingDir = this.dirs[NBT.func_74762_e("face")];
        this.hasMultiblock = NBT.func_74767_n("multi");
        this.power = NBT.func_74763_f("pwr");
        if (NBT.func_74764_b("mode")) {
            this.mode = Modes.list[NBT.func_74762_e("mode")];
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("face", this.getFacing().ordinal());
        NBT.func_74757_a("multi", this.hasMultiblock);
        NBT.func_74772_a("pwr", this.power);
        NBT.func_74768_a("mode", this.mode.ordinal());
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.mode == Modes.RF ? (int)this.getGenUnits() : 0;
    }

    public double getGenUnits() {
        return (double)this.power * this.mode.ratio;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == this.getFacing().getOpposite();
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return Integer.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int l = this.getGeneratorLength();
        int x1 = this.field_145851_c + 1 + this.getFacing().offsetX * l;
        int z1 = this.field_145849_e + 1 + this.getFacing().offsetZ * l;
        int mx = Math.min(x1, this.field_145851_c);
        int mz = Math.min(z1, this.field_145849_e);
        int mx2 = Math.max(x1, this.field_145851_c);
        int mz2 = Math.max(z1, this.field_145849_e);
        return AxisAlignedBB.func_72330_a((double)mx, (double)(this.field_145848_d - 2), (double)mz, (double)mx2, (double)(this.field_145848_d + 3), (double)mz2).func_72314_b(6.0, 6.0, 6.0);
    }

    public Modes stepType() {
        int o = this.mode.ordinal();
        Modes m = Modes.list[o];
        do {
            if (o < Modes.list.length - 1) {
                ++o;
                continue;
            }
            o = 0;
        } while (!(m = Modes.list[o]).exists());
        this.mode = m;
        return this.mode;
    }

    public String getUnitSymbol() {
        return this.mode.name();
    }

    public Modes getMode() {
        return this.mode;
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection dir) {
        return this.mode == Modes.EU;
    }

    public double getOfferedEnergy() {
        return this.mode == Modes.EU ? this.getGenUnits() : 0.0;
    }

    public void drawEnergy(double amount) {
    }

    public int getSourceTier() {
        return 5;
    }

    public void onFirstTick(World world, int x, int y, int z) {
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.addTileToNet();
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.IC2)
    private void addTileToNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalidate) {
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.removeTileFromNet();
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.IC2)
    private void removeTileFromNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
    }

    public boolean onShiftRightClick(World world, int x, int y, int z, ForgeDirection side) {
        this.stepType();
        return true;
    }

    public boolean onRightClick(World world, int x, int y, int z, ForgeDirection side) {
        if (side.offsetY == 0) {
            this.setFacing(side);
            return true;
        }
        return false;
    }

    public void breakBlock() {
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                int dx = this.field_145851_c + dir.offsetX;
                int dy = this.field_145848_d + dir.offsetY;
                int dz = this.field_145849_e + dir.offsetZ;
                Block b = this.field_145850_b.func_147439_a(dx, dy, dz);
                if (!(b instanceof BlockMultiBlock)) continue;
                ((BlockMultiBlock)b).breakMultiBlock(this.field_145850_b, dx, dy, dz);
            }
        }
    }

    public static enum Modes {
        RF("Redstone Flux", 1.0 / (double)ReikaRFHelper.getWattsPerRF(), PowerTypes.RF),
        EU("EU", 1.0 / ReikaEUHelper.getWattsPerEU(), PowerTypes.EU);

        public final String name;
        private final double ratio;
        public final PowerTypes type;
        private static final Modes[] list;

        private Modes(String s, double r, PowerTypes p) {
            this.name = s;
            this.ratio = r;
            this.type = p;
        }

        public boolean exists() {
            return this.type.isLoaded();
        }

        static {
            list = Modes.values();
        }
    }
}

