/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.ReactorPowerReceiver;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.API.Power.PowerTransferHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityHeavyPump
extends TileEntityReactorBase
implements ReactorPowerReceiver,
IFluidHandler,
PipeConnector {
    public static final int MINPOWER = 65536;
    public static final int MINTORQUE = 512;
    private int torque;
    private int omega;
    private long power;
    private int iotick;
    private static final HashMap<Fluid, Extraction> extractions = new HashMap();
    private StepTimer timer = new StepTimer(20);
    private final HybridTank tank = new HybridTank("heavypump", 8000);

    @Override
    public int getIndex() {
        return ReactorTiles.FLUIDEXTRACTOR.ordinal();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        if (this.power >= 65536L && this.torque >= 512) {
            this.phi += 10.0f;
        }
        this.iotick -= 8;
    }

    public void setOmega(int omega) {
        this.omega = omega;
    }

    public void setTorque(int torque) {
        this.torque = torque;
    }

    public void setPower(long power) {
        this.power = power;
    }

    public int getOmega() {
        return this.omega;
    }

    public int getTorque() {
        return this.torque;
    }

    public long getPower() {
        return this.power;
    }

    public boolean canReadFrom(ForgeDirection dir) {
        return dir.offsetY != 0;
    }

    public boolean isReceiving() {
        return true;
    }

    public void noInputMachine() {
        this.torque = 0;
        this.omega = 0;
        this.power = 0L;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!PowerTransferHelper.checkPowerFrom((TileEntity)this, (ForgeDirection)ForgeDirection.DOWN) && !PowerTransferHelper.checkPowerFrom((TileEntity)this, (ForgeDirection)ForgeDirection.UP)) {
            this.noInputMachine();
        }
        if (this.power >= 65536L && this.torque >= 512) {
            this.timer.setCap(Math.max(1, 20 - 2 * (int)ReikaMathLibrary.logbase((long)this.omega, (int)2)));
            this.timer.update();
            Extraction e = this.getExtraction(world, x, y, z);
            if (e != null) {
                if (this.timer.checkCap() && e.canPerform(world, x, y, z)) {
                    this.harvest(e, world, x, y, z);
                }
            } else {
                this.timer.reset();
            }
        }
    }

    private Extraction getExtraction(World world, int x, int y, int z) {
        Fluid f = null;
        int c = 0;
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dz = z + dir.offsetZ;
            Fluid f2 = ReikaWorldHelper.getFluid((World)world, (int)dx, (int)y, (int)dz);
            if (f2 == null || !ReikaWorldHelper.isLiquidSourceBlock((World)world, (int)dx, (int)y, (int)dz)) continue;
            if (f == null || f2 == f) {
                ++c;
                f = f2;
                continue;
            }
            return null;
        }
        return f != null && c >= 3 ? extractions.get(f) : null;
    }

    private void harvest(Extraction e, World world, int x, int y, int z) {
        if (e instanceof HeavyWaterExtraction) {
            ReactorAchievements.HEAVYWATER.triggerAchievement(this.getPlacer());
        }
        this.tank.fill(new FluidStack(e.output, e.getExtractedAmount(world, x, y, z)), true);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from.offsetY != 0) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.offsetY == 0 && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public boolean hasABucket() {
        return this.tank.getFluid() != null && this.tank.getFluid().amount >= 1000;
    }

    public void subtractBucket() {
        this.tank.drain(1000, true);
    }

    public int getTankLevel() {
        return this.tank.getFluid() != null ? this.tank.getFluid().amount : 0;
    }

    public int getIORenderAlpha() {
        return this.iotick;
    }

    public void setIORenderAlpha(int io) {
        this.iotick = io;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
        this.omega = NBT.func_74762_e("speed");
        this.torque = NBT.func_74762_e("trq");
        this.power = NBT.func_74763_f("pwr");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
        NBT.func_74768_a("speed", this.omega);
        NBT.func_74768_a("trq", this.torque);
        NBT.func_74772_a("pwr", this.power);
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p) && side.offsetY == 0;
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side.offsetY == 0 ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.NONE;
    }

    public int getMinTorque(int available) {
        return 512;
    }

    @Override
    public int getMinTorque() {
        return 512;
    }

    @Override
    public int getMinSpeed() {
        return 1;
    }

    @Override
    public long getMinPower() {
        return 65536L;
    }

    static {
        extractions.put(FluidRegistry.WATER, new HeavyWaterExtraction());
        extractions.put(FluidRegistry.LAVA, new MoltenLithiumExtraction());
    }

    private static class MoltenLithiumExtraction
    extends Extraction {
        private MoltenLithiumExtraction() {
            super(FluidRegistry.getFluid((String)"rc lithium"));
        }

        @Override
        protected boolean canPerform(World world, int x, int y, int z) {
            return y == this.getSurfaceY(world, x, y, z) && this.isLavaSurface(world, x, y, z);
        }

        private boolean isLavaSurface(World world, int x, int y, int z) {
            Block b = world.func_147439_a(x, y - 1, z);
            Block b2 = world.func_147439_a(x, y + 1, z);
            return (b == Blocks.field_150353_l || b == Blocks.field_150356_k) && b2 != Blocks.field_150353_l && b2 != Blocks.field_150356_k;
        }

        private int getSurfaceY(World world, int x, int y, int z) {
            switch (world.field_73011_w.field_76574_g) {
                case 0: {
                    return 10;
                }
                case -1: {
                    return 31;
                }
            }
            return -1;
        }

        @Override
        protected int getExtractedAmount(World world, int x, int y, int z) {
            return world.field_73011_w.field_76574_g == -1 ? 10 + rand.nextInt(21) + rand.nextInt(51) : 10 + rand.nextInt(31);
        }
    }

    public static class HeavyWaterExtraction
    extends Extraction {
        public static final int MAXY = 45;
        public static final int MINDEPTH = 16;

        private HeavyWaterExtraction() {
            super(FluidRegistry.getFluid((String)"rc heavy water"));
        }

        @Override
        protected boolean canPerform(World world, int x, int y, int z) {
            return y < 45 && ReikaBiomeHelper.isOcean((BiomeGenBase)world.func_72807_a(x, z)) && this.isOceanFloor(world, x, y, z);
        }

        private boolean isOceanFloor(World world, int x, int y, int z) {
            for (int i = 0; i < 16; ++i) {
                int dy = y + i;
                for (int a = -1; a <= 1; a += 2) {
                    for (int b = -1; b <= 1; b += 2) {
                        Block id = world.func_147439_a(x + a, dy, z + b);
                        int meta = world.func_72805_g(x + a, dy, z + b);
                        if ((id == Blocks.field_150358_i || id == Blocks.field_150355_j) && meta == 0) continue;
                        return false;
                    }
                }
                if (i < 1) continue;
                Block id = world.func_147439_a(x, dy, z);
                int meta = world.func_72805_g(x, dy, z);
                if ((id == Blocks.field_150358_i || id == Blocks.field_150355_j) && meta == 0) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int getExtractedAmount(World world, int x, int y, int z) {
            return 200;
        }
    }

    private static abstract class Extraction {
        protected final Fluid output;

        private Extraction(Fluid f) {
            this.output = f;
        }

        protected abstract boolean canPerform(World var1, int var2, int var3, int var4);

        protected abstract int getExtractedAmount(World var1, int var2, int var3, int var4);
    }
}

