/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.PowerGen;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Proportionality;
import Reika.ReactorCraft.Auxiliary.SteamTile;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.ReactorType;
import Reika.ReactorCraft.Registry.WorkingFluid;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityReactorBoiler;
import Reika.ReactorCraft.TileEntities.TileEntitySteamDiffuser;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeRenderConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.PumpablePipe;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityPipePump;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySteamLine
extends TileEntityReactorBase
implements PumpablePipe,
SteamTile {
    private int steam;
    private boolean[] connections = new boolean[6];
    private WorkingFluid fluid = WorkingFluid.EMPTY;
    private Proportionality<ReactorType> source = new Proportionality();

    @Override
    public int getIndex() {
        return ReactorTiles.STEAMLINE.ordinal();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.drawFromBoiler(world, x, y, z);
        this.getPipeSteam(world, x, y, z);
        if (this.steam <= 0) {
            this.fluid = WorkingFluid.EMPTY;
        }
    }

    private void drawFromBoiler(World world, int x, int y, int z) {
        TileEntityReactorBoiler te;
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, x, y - 1, z);
        if (r == ReactorTiles.BOILER && this.canTakeInWorkingFluid((te = (TileEntityReactorBoiler)world.func_147438_o(x, y - 1, z)).getWorkingFluid())) {
            this.fluid = te.getWorkingFluid();
            int s = te.removeSteam();
            this.steam += s;
            this.source.addValue((Object)te.getReactorType(), (double)s);
        }
    }

    private boolean canTakeInWorkingFluid(WorkingFluid f) {
        if (f == WorkingFluid.EMPTY) {
            return false;
        }
        if (this.fluid == WorkingFluid.EMPTY) {
            return true;
        }
        return this.fluid == f;
    }

    private void getPipeSteam(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            WorldRift wr;
            TileEntity tile;
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            TileEntity te = world.func_147438_o(dx, dy, dz);
            if (te instanceof TileEntitySteamLine) {
                TileEntitySteamLine tile2 = (TileEntitySteamLine)te;
                if (!this.canTakeInWorkingFluid(tile2.fluid)) continue;
                this.readPipe(tile2);
                continue;
            }
            if (!(te instanceof WorldRift) || !((tile = (wr = (WorldRift)te).getTileEntityFrom(dir)) instanceof TileEntitySteamLine)) continue;
            TileEntitySteamLine ts = (TileEntitySteamLine)tile;
            if (!this.canTakeInWorkingFluid(ts.fluid)) continue;
            this.readPipe(ts);
        }
    }

    private void readPipe(TileEntitySteamLine te) {
        int dS = te.steam - this.steam;
        if (dS > 0) {
            this.steam += dS / 2 + 1;
            te.steam -= dS / 2 + 1;
            this.fluid = te.fluid;
            this.source = te.source;
        }
    }

    public boolean isConnectedOnSideAt(World world, int x, int y, int z, ForgeDirection dir) {
        dir = dir.offsetX == 0 ? dir.getOpposite() : dir;
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        Block id = world.func_147439_a(dx, dy, dz);
        int meta = world.func_72805_g(dx, dy, dz);
        if (id == this.getTileEntityBlockID() && meta == ReactorTiles.STEAMLINE.getBlockMetadata()) {
            return true;
        }
        if (id == ReactorTiles.BOILER.getBlock() && meta == ReactorTiles.BOILER.getBlockMetadata() && dir == ForgeDirection.DOWN) {
            return true;
        }
        if (id == ReactorTiles.GRATE.getBlock() && meta == ReactorTiles.GRATE.getBlockMetadata()) {
            return true;
        }
        if (id == ReactorTiles.BIGTURBINE.getBlock() && meta == ReactorTiles.BIGTURBINE.getBlockMetadata()) {
            return true;
        }
        if (id == ReactorTiles.DIFFUSER.getBlock() && meta == ReactorTiles.DIFFUSER.getBlockMetadata()) {
            boolean flag = ((TileEntitySteamDiffuser)this.getAdjacentTileEntity(dir)).getFacing().getOpposite() == dir;
            return flag;
        }
        if (id == MachineRegistry.PIPEPUMP.getBlock() && meta == MachineRegistry.PIPEPUMP.getBlockMetadata()) {
            boolean flag = ((TileEntityPipePump)this.getAdjacentTileEntity(dir)).canConnectToPipeOnSide(dir);
            return flag;
        }
        return world.func_147438_o(dx, dy, dz) instanceof WorldRift;
    }

    @Override
    public int getSteam() {
        return this.steam;
    }

    public void removeSteam(int amt) {
        this.steam -= amt;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.steam = NBT.func_74762_e("energy");
        this.fluid = WorkingFluid.getFromNBT(NBT);
        for (int i = 0; i < 6; ++i) {
            this.connections[i] = NBT.func_74767_n("conn" + i);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("energy", this.steam);
        this.fluid.saveToNBT(NBT);
        for (int i = 0; i < 6; ++i) {
            NBT.func_74757_a("conn" + i, this.connections[i]);
        }
    }

    public WorkingFluid getWorkingFluid() {
        return this.fluid;
    }

    public boolean isConnectionValidForSide(ForgeDirection dir) {
        if (dir.offsetX == 0 && MinecraftForgeClient.getRenderPass() != 1) {
            dir = dir.getOpposite();
        }
        return this.connections[dir.ordinal()];
    }

    public final AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public void recomputeConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            this.connections[i] = this.isConnected(this.dirs[i]);
            world.func_147479_m(x + this.dirs[i].offsetX, y + this.dirs[i].offsetY, z + this.dirs[i].offsetZ);
        }
        world.func_147479_m(x, y, z);
    }

    public void deleteFromAdjacentConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = x + dir.offsetY;
            int dz = x + dir.offsetZ;
            ReactorTiles m = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (m != this.getMachine()) continue;
            TileEntitySteamLine te = (TileEntitySteamLine)world.func_147438_o(dx, dy, dz);
            te.connections[dir.getOpposite().ordinal()] = false;
            world.func_147479_m(dx, dy, dz);
        }
    }

    public void addToAdjacentConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = x + dir.offsetY;
            int dz = x + dir.offsetZ;
            ReactorTiles m = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (m != this.getMachine()) continue;
            TileEntitySteamLine te = (TileEntitySteamLine)world.func_147438_o(dx, dy, dz);
            te.connections[dir.getOpposite().ordinal()] = true;
            world.func_147479_m(dx, dy, dz);
        }
    }

    private boolean isConnected(ForgeDirection dir) {
        ReactorTiles m2;
        int x = this.field_145851_c + dir.offsetX;
        int y = this.field_145848_d + dir.offsetY;
        int z = this.field_145849_e + dir.offsetZ;
        ReactorTiles m = this.getMachine();
        if (m == (m2 = ReactorTiles.getTE((IBlockAccess)this.field_145850_b, x, y, z))) {
            return true;
        }
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof PipeRenderConnector) {
            return ((PipeRenderConnector)te).canConnectToPipeOnSide(dir);
        }
        return te instanceof WorldRift;
    }

    public int getPacketDelay() {
        return 4 * super.getPacketDelay();
    }

    public boolean canTransferTo(PumpablePipe p, ForgeDirection dir) {
        if (p instanceof TileEntitySteamLine) {
            WorkingFluid f = ((TileEntitySteamLine)p).fluid;
            return f != WorkingFluid.EMPTY ? f == this.fluid : true;
        }
        return false;
    }

    public int getFluidLevel() {
        return this.getSteam();
    }

    public void transferFrom(PumpablePipe from, int amt) {
        ((TileEntitySteamLine)from).steam -= amt;
        this.fluid = ((TileEntitySteamLine)from).fluid;
        this.steam += amt;
        this.source = ((TileEntitySteamLine)from).source;
    }

    public Proportionality<ReactorType> getSourceReactorType() {
        return this.source;
    }
}

