/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Fusion;

import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.ReactorCraft.Auxiliary.FusionReactorToroidPart;
import Reika.ReactorCraft.Auxiliary.MultiBlockTile;
import Reika.ReactorCraft.Auxiliary.NeutronTile;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Entities.EntityPlasma;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorOptions;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Fusion.TileEntityFusionInjector;
import Reika.RotaryCraft.API.Interfaces.Screwdriverable;
import Reika.RotaryCraft.API.Interfaces.Shockable;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Entities.EntityDischarge;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityVanDeGraff;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityToroidMagnet
extends TileEntityReactorBase
implements Screwdriverable,
Shockable,
MultiBlockTile,
FusionReactorToroidPart,
ChunkLoadingTile,
NeutronTile {
    private Aim aim = Aim.N;
    private int alpha = 512;
    protected boolean hasSolenoid = false;
    private int charge = 0;
    private StepTimer chargeTimer = new StepTimer(20);
    private StepTimer reCheckTimer = new StepTimer(20);
    private static final int RATE = ReactorOptions.getToroidChargeRate();
    private final HybridTank tank = new HybridTank("toroid", 8000);
    private boolean hasNext;
    private boolean isActive;
    private int lastPlasma;

    @Override
    public boolean hasMultiBlock() {
        return true;
    }

    @Override
    public void setHasMultiBlock(boolean has) {
    }

    @Override
    public int getIndex() {
        return ReactorTiles.MAGNET.ordinal();
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        if (!this.hasSolenoid) {
            this.checkSurroundingMagnetsAndCopySolenoidState();
        }
        this.hasNext = this.checkCompleteness(world, x, y, z);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.alpha > 0) {
            this.alpha -= 8;
        }
        if (DragonAPICore.debugtest) {
            this.tank.addLiquid(1000, (Fluid)RotaryCraft.nitrogenFluid);
            this.charge = 250000;
        }
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z);
        List li = world.func_72872_a(EntityPlasma.class, box);
        int[] tg = this.getTarget();
        for (EntityPlasma e : li) {
            if (this.canAffect(e)) {
                e.resetEscapeTimer();
                e.setTarget(tg[0], tg[2]);
                e.magnetOrdinal = this.getOrdinal();
                this.tank.removeLiquid(10);
                this.setActive();
                continue;
            }
            ReactorAchievements.ESCAPE.triggerAchievement(this.getPlacer());
        }
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, (int)x, (int)(y + 2), (int)z);
        if (m != null && m.isStandardPipe()) {
            TileEntity te = world.func_147438_o(x, y + 2, z);
            int amt = Math.min(this.tank.getRemainingSpace(), ((TileEntityPiping)te).getFluidLevel());
            if (amt > 0 && FluidRegistry.getFluid((String)"rc liquid nitrogen").equals(((TileEntityPiping)te).getFluidType())) {
                this.tank.addLiquid(amt, FluidRegistry.getFluid((String)"rc liquid nitrogen"));
                ((TileEntityPiping)te).removeLiquid(amt);
            }
        }
        this.chargeTimer.update();
        if (this.chargeTimer.getTick() % RATE == 0) {
            this.distributeCharge(world, x, y, z);
        }
        if (this.chargeTimer.checkCap()) {
            this.updateCharge(world, x, y, z);
        }
        if (this.hasSolenoid) {
            this.reCheckTimer.update();
            if (this.reCheckTimer.checkCap() && !world.field_72995_K) {
                this.hasNext = this.checkCompleteness(world, x, y, z);
            }
        }
        if (this.lastPlasma > 0) {
            --this.lastPlasma;
            if (this.lastPlasma == 0) {
                this.setInactive();
            }
        }
    }

    private void setActive() {
        boolean last = this.isActive;
        this.isActive = true;
        this.lastPlasma = 20;
        if (!last) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (ReactorOptions.CHUNKLOADING.getState()) {
                ChunkManager.instance.loadChunks((ChunkLoadingTile)this);
            }
        }
    }

    private void setInactive() {
        boolean last = this.isActive;
        this.isActive = false;
        if (last) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            ChunkManager.instance.unloadChunks((TileEntity)this);
        }
    }

    private boolean checkCompleteness(World world, int x, int y, int z) {
        FusionReactorToroidPart te = this.getNextPart(world, x, y, z);
        for (int i = 60; te != null && te != this && i >= 0; te = te.getNextPart(world, x, y, z), --i) {
        }
        if (te != this && te instanceof TileEntityToroidMagnet) {
            ((TileEntityToroidMagnet)te).hasNext = false;
        }
        return te == this;
    }

    @Override
    public FusionReactorToroidPart getNextPart(World world, int x, int y, int z) {
        Aim a = this.getAim();
        int dx = this.field_145851_c + a.xOffset;
        int dz = this.field_145849_e + a.zOffset;
        TileEntity te = this.field_145850_b.func_147438_o(dx, y, dz);
        return te instanceof FusionReactorToroidPart ? (FusionReactorToroidPart)te : null;
    }

    public int getCoolant() {
        return this.tank.getLevel();
    }

    public int getCharge() {
        return this.charge;
    }

    private void checkSurroundingMagnetsAndCopySolenoidState() {
        Aim a = this.getAim();
        int dx = this.field_145851_c + a.xOffset;
        int dz = this.field_145849_e + a.zOffset;
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)this.field_145850_b, dx, this.field_145848_d, dz);
        if (r == ReactorTiles.MAGNET) {
            TileEntityToroidMagnet te = (TileEntityToroidMagnet)this.field_145850_b.func_147438_o(dx, this.field_145848_d, dz);
            this.hasSolenoid = te.hasSolenoid;
            te.checkCompleteness(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (r == ReactorTiles.INJECTOR) {
            TileEntity te = this.field_145850_b.func_147438_o(dx += a.xOffset, this.field_145848_d, dz += a.zOffset);
            while (te instanceof TileEntityFusionInjector) {
                te = this.field_145850_b.func_147438_o(dx += a.xOffset, this.field_145848_d, dz += a.zOffset);
            }
            if (te instanceof TileEntityToroidMagnet) {
                this.hasSolenoid = ((TileEntityToroidMagnet)te).hasSolenoid;
            }
        }
    }

    private void collectCharge(World world, int x, int y, int z) {
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, (int)x, (int)(y - 3), (int)z);
        if (m == MachineRegistry.VANDEGRAFF) {
            TileEntityVanDeGraff te = (TileEntityVanDeGraff)world.func_147438_o(x, y - 3, z);
            te.dischargeToBlock(x, y, z, (Shockable)this);
        }
    }

    private boolean distributeCharge(World world, int x, int y, int z) {
        int dC;
        TileEntityToroidMagnet te;
        Aim a = this.getAim();
        int dx = x + a.xOffset;
        int dz = z + a.zOffset;
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, dx, y, dz);
        if (r == ReactorTiles.MAGNET) {
            TileEntityToroidMagnet te2 = (TileEntityToroidMagnet)world.func_147438_o(dx, y, dz);
            int dC2 = this.charge - te2.charge;
            if (dC2 > 0) {
                te2.charge += dC2 / 4;
                this.charge -= dC2 / 4;
                EntityDischarge e1 = new EntityDischarge(world, (double)x + 0.5, (double)y + 2.25, (double)z + 0.5, this.charge, (double)te2.field_145851_c + 0.5, (double)te2.field_145848_d + 2.25, (double)te2.field_145849_e + 0.5);
                EntityDischarge e2 = new EntityDischarge(world, (double)x + 0.5, (double)y - 1.25, (double)z + 0.5, this.charge, (double)te2.field_145851_c + 0.5, (double)te2.field_145848_d - 1.25, (double)te2.field_145849_e + 0.5);
                float ang = this.getAngle();
                float ang2 = te2.getAngle();
                double fx = 1.75 * Math.sin(Math.toRadians(ang));
                double fz = 1.75 * Math.cos(Math.toRadians(ang));
                double fx2 = 1.75 * Math.sin(Math.toRadians(ang2));
                double fz2 = 1.75 * Math.cos(Math.toRadians(ang2));
                EntityDischarge e3 = new EntityDischarge(world, (double)x + 0.5 + fx, (double)y + 0.5, (double)z + 0.5 + fz, this.charge, (double)te2.field_145851_c + 0.5 + fx2, (double)te2.field_145848_d + 0.5, (double)te2.field_145849_e + 0.5 + fz2);
                EntityDischarge e4 = new EntityDischarge(world, (double)x + 0.5 - fx, (double)y + 0.5, (double)z + 0.5 - fz, this.charge, (double)te2.field_145851_c + 0.5 - fx2, (double)te2.field_145848_d + 0.5, (double)te2.field_145849_e + 0.5 - fz2);
                if (!world.field_72995_K && this.shouldSpawnSparks(world)) {
                    world.func_72838_d((Entity)e1);
                    world.func_72838_d((Entity)e2);
                    world.func_72838_d((Entity)e3);
                    world.func_72838_d((Entity)e4);
                }
            }
        } else if (r == ReactorTiles.INJECTOR && (te = (TileEntityToroidMagnet)world.func_147438_o(dx += a.xOffset, y, dz += a.zOffset)) != null && (dC = this.charge - te.charge) > 0) {
            te.charge += dC / 4;
            this.charge -= dC / 4;
            EntityDischarge e1 = new EntityDischarge(world, (double)x + 0.5, (double)(y + 2), (double)z + 0.5, this.charge, (double)te.field_145851_c + 0.5, (double)(te.field_145848_d + 2), (double)te.field_145849_e + 0.5);
            EntityDischarge e2 = new EntityDischarge(world, (double)x + 0.5, (double)(y - 1), (double)z + 0.5, this.charge, (double)te.field_145851_c + 0.5, (double)(te.field_145848_d - 1), (double)te.field_145849_e + 0.5);
            if (!world.field_72995_K && this.shouldSpawnSparks(world)) {
                world.func_72838_d((Entity)e1);
                world.func_72838_d((Entity)e2);
            }
        }
        return false;
    }

    private boolean shouldSpawnSparks(World world) {
        return rand.nextBoolean();
    }

    private void updateCharge(World world, int x, int y, int z) {
        this.charge = this.charge <= 1 ? 0 : (int)((double)this.charge * 0.8);
    }

    private void clearArea(World world, int x, int y, int z) {
        int r = 2;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    Block b = world.func_147439_a(x + i, y + j, z + k);
                    if (b != Blocks.field_150349_c && b != Blocks.field_150346_d) continue;
                    world.func_147468_f(x + i, y + j, z + k);
                }
            }
        }
    }

    private boolean canAffect(EntityPlasma e) {
        if (!this.hasNext) {
            return false;
        }
        if (!this.hasSolenoid) {
            return false;
        }
        if (this.charge <= 1000) {
            return false;
        }
        if (this.tank.isEmpty()) {
            return false;
        }
        int o = this.getOrdinal();
        int p = e.magnetOrdinal;
        if (p == -1) {
            return o % 8 == 0;
        }
        if (o > 30) {
            return p > 28 || p < 1;
        }
        if (p > 30) {
            return o > 28 || o < 1;
        }
        return Math.abs(p - o) <= 2;
    }

    public int[] getTarget() {
        int[] tg = new int[3];
        tg[0] = this.field_145851_c + this.getAim().xOffset;
        tg[2] = this.field_145849_e + this.getAim().zOffset;
        tg[1] = this.field_145848_d;
        return tg;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.aim = this.getAim(NBT.func_74762_e("aim"));
        this.hasSolenoid = NBT.func_74767_n("solenoid");
        this.charge = NBT.func_74762_e("chg");
        this.alpha = NBT.func_74762_e("alp");
        this.tank.readFromNBT(NBT);
        this.hasNext = NBT.func_74767_n("next");
        this.isActive = NBT.func_74767_n("active");
        this.lastPlasma = NBT.func_74762_e("lastplasma");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("aim", this.getAim().ordinal());
        NBT.func_74757_a("solenoid", this.hasSolenoid);
        NBT.func_74768_a("alp", this.alpha);
        NBT.func_74768_a("chg", this.charge);
        this.tank.writeToNBT(NBT);
        NBT.func_74757_a("next", this.hasNext);
        NBT.func_74757_a("active", this.isActive);
        NBT.func_74768_a("lastplasma", this.lastPlasma);
    }

    public Aim getAim() {
        return this.aim != null ? this.aim : Aim.N;
    }

    private Aim getAim(int o) {
        return o > 0 && o < Aim.list.length ? Aim.list[o] : Aim.N;
    }

    public boolean onShiftRightClick(World world, int x, int y, int z, ForgeDirection side) {
        this.alpha = 512;
        this.decrementAim();
        return true;
    }

    public boolean onRightClick(World world, int x, int y, int z, ForgeDirection side) {
        this.alpha = 512;
        this.incrementAim();
        return true;
    }

    public float getAngle() {
        return this.getAim().angle;
    }

    public int getOrdinal() {
        return this.getAim().ordinal();
    }

    public int getPreviousOrdinal() {
        int o = this.getOrdinal();
        return o > 0 ? o : Aim.list.length - 1;
    }

    public int getAlpha() {
        return this.alpha;
    }

    private void incrementAim() {
        int o = this.getAim().ordinal();
        this.aim = o == Aim.list.length - 1 ? Aim.list[0] : Aim.list[o + 1];
        if (!this.hasSolenoid) {
            this.checkSurroundingMagnetsAndCopySolenoidState();
        }
    }

    private void decrementAim() {
        int o = this.getAim().ordinal();
        this.aim = o == 0 ? Aim.list[Aim.list.length - 1] : Aim.list[o - 1];
        if (!this.hasSolenoid) {
            this.checkSurroundingMagnetsAndCopySolenoidState();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(3.0, 3.0, 3.0);
    }

    public void onDischarge(int charge, double range) {
        this.charge += charge;
    }

    public int getMinDischarge() {
        return 8192;
    }

    public float getAimX() {
        return 0.5f;
    }

    public float getAimY() {
        return -1.25f;
    }

    public float getAimZ() {
        return 0.5f;
    }

    public void setAim(Aim a) {
        this.aim = a != null ? a : this.aim;
    }

    public void breakBlock() {
        ChunkManager.instance.unloadChunks((TileEntity)this);
    }

    public Collection<ChunkCoordIntPair> getChunksToLoad() {
        return ChunkManager.getChunkSquare((int)this.field_145851_c, (int)this.field_145849_e, (int)2);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean canDischargeLongRange() {
        return true;
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        return false;
    }

    public static enum Aim {
        N(0.0f, 2, 0),
        NNW1(11.3f, 2, -1),
        NNW2(24.0f, 2, -1),
        NNW3(36.9f, 2, -2),
        NW(45.0f, 2, -2),
        WNW1(53.1f, 1, -2),
        WNW2(66.0f, 1, -2),
        WNW3(78.7f, 0, -2),
        W(90.0f, 0, -2),
        WSW1(101.3f, -1, -2),
        WSW2(114.0f, -1, -2),
        WSW3(126.9f, -2, -2),
        SW(135.0f, -2, -2),
        SSW1(143.1f, -2, -1),
        SSW2(156.0f, -2, -1),
        SSW3(168.7f, -2, 0),
        S(180.0f, -2, 0),
        SSE1(191.3f, -2, 1),
        SSE2(204.0f, -2, 1),
        SSE3(216.9f, -2, 2),
        SE(225.0f, -2, 2),
        ESE1(233.1f, -1, 2),
        ESE2(246.0f, -1, 2),
        ESE3(258.7f, 0, 2),
        E(270.0f, 0, 2),
        ENE1(281.3f, 1, 2),
        ENE2(294.0f, 1, 2),
        ENE3(306.9f, 2, 2),
        NE(315.0f, 2, 2),
        NNE1(323.1f, 2, 1),
        NNE2(336.0f, 2, 1),
        NNE3(348.7f, 2, 0);

        public final float angle;
        public final int xOffset;
        public final int zOffset;
        public static final Aim[] list;

        private Aim(float a, int x, int z) {
            this.angle = a;
            this.xOffset = x;
            this.zOffset = z;
        }

        public Aim getNext() {
            return this.ordinal() < list.length - 1 ? list[this.ordinal() + 1] : list[0];
        }

        public Aim getPrev() {
            return this.ordinal() > 0 ? list[this.ordinal() - 1] : list[list.length - 1];
        }

        public boolean isCardinal() {
            return this.ordinal() % 8 == 0;
        }

        static {
            list = Aim.values();
        }
    }
}

