/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Fission.Thorium;

import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.ReactorCraft.Base.TileEntityTankedReactorMachine;
import Reika.ReactorCraft.Blocks.BlockThoriumFuel;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Fission.Thorium.TileEntityThoriumCore;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityFuelDump
extends TileEntityTankedReactorMachine {
    private int fullTicks = 0;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            TileEntity te = this.getAdjacentTileEntity(ForgeDirection.UP);
            if (te instanceof TileEntityThoriumCore) {
                TileEntityThoriumCore tc = (TileEntityThoriumCore)te;
                if (tc.getTemperature() >= 1100 && tc.hasFuel()) {
                    int rem = this.tank.getRemainingSpace();
                    if (rem > 0) {
                        int fuel = ((TileEntityThoriumCore)te).dumpFuel(this, rem);
                        if (fuel > 0) {
                            this.tank.addLiquid(fuel, ReactorCraft.LIFBe_fuel);
                        }
                        this.fullTicks = 0;
                    } else {
                        ++this.fullTicks;
                        if (this.fullTicks > 200) {
                            this.overload(world, x, y, z);
                        }
                    }
                }
            }
            if (this.tank.getLevel() >= 125 && this.canDumpAt(world, x, y - 1, z)) {
                this.dumpFuel(world, x, y, z);
            }
        }
    }

    private void dumpFuel(World world, int x, int y, int z) {
        int n1 = Math.min(8, this.tank.getLevel() / 125);
        int n2 = n1 - 1;
        if (world.func_147439_a(x, y - 1, z) == ReactorBlocks.THORIUM.getBlockInstance()) {
            int fmeta = world.func_72805_g(x, y - 1, z);
            n1 = Math.min(n1, 7 - fmeta);
            n2 = n1 + fmeta;
        }
        this.tank.removeLiquid(n1 * 125);
        world.func_147465_d(x, y - 1, z, ReactorBlocks.THORIUM.getBlockInstance(), n2, 3);
        this.fullTicks = 0;
        ReikaSoundHelper.playSoundFromServerAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz", (float)1.0f, (float)1.0f, (boolean)true);
    }

    private boolean canDumpAt(World world, int x, int y, int z) {
        return BlockThoriumFuel.canOverwrite(world, x, y, z) || world.func_147439_a(x, y, z) == ReactorBlocks.THORIUM.getBlockInstance() && world.func_72805_g(x, y, z) < 7;
    }

    private void overload(World world, int x, int y, int z) {
        this.delete();
        world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, true, true);
        world.func_147449_b(x, y, z, ReactorBlocks.CORIUMFLOWING.getBlockInstance());
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.hasTile() ? this.getTile().drain(from, resource, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.hasTile() ? this.getTile().drain(from, maxDrain, doDrain) : null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.hasTile() ? this.getTile().canDrain(from, fluid) : false;
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return this.hasTile() ? this.getTile().canConnectToPipe(m) : false;
    }

    private boolean hasTile() {
        return this.getAdjacentTileEntity(ForgeDirection.UP) instanceof TileEntityThoriumCore;
    }

    private TileEntityThoriumCore getTile() {
        return (TileEntityThoriumCore)this.getAdjacentTileEntity(ForgeDirection.UP);
    }

    @Override
    public int getCapacity() {
        return 2000;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return false;
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public int getIndex() {
        return ReactorTiles.FUELDUMP.ordinal();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }
}

