/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Registry;

import java.util.Locale;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public enum WorkingFluid {
    EMPTY(0.0f, 0, ""),
    WATER(1.0f, 100, "water"),
    AMMONIA(2.0f, -33, "rc ammonia");

    public final float efficiency;
    public final int boilingTemp;
    private final String fluidName;
    public static final WorkingFluid[] list;

    private WorkingFluid(float e, int boil, String f) {
        this.efficiency = e;
        this.boilingTemp = boil;
        this.fluidName = f;
    }

    public Fluid getFluid() {
        return FluidRegistry.getFluid((String)this.fluidName);
    }

    public Fluid getLowPressureFluid() {
        return FluidRegistry.getFluid((String)("rc lowp" + this.name().toLowerCase(Locale.ENGLISH)));
    }

    public static WorkingFluid getFromNBT(NBTTagCompound NBT) {
        int val = NBT.func_74762_e("workingfluid");
        if (val >= 0 && val < list.length) {
            return list[val];
        }
        return EMPTY;
    }

    public void saveToNBT(NBTTagCompound NBT) {
        NBT.func_74768_a("workingfluid", this.ordinal());
    }

    public static boolean isWorkingFluid(Fluid f) {
        for (int i = 0; i < list.length; ++i) {
            Fluid fl = list[i].getFluid();
            if (!f.equals(fl)) continue;
            return true;
        }
        return false;
    }

    static {
        list = WorkingFluid.values();
    }
}

