/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Registry;

import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.ReactorCraft.ReactorCraft;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.net.URL;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public enum ReactorSounds implements SoundEnum
{
    TURBINE("#turbine"),
    FUSION("fusion"),
    CONTROL("control"),
    SCRAM("scram");

    public static final ReactorSounds[] soundList;
    public static final String PREFIX = "Reika/ReactorCraft/";
    public static final String SOUND_FOLDER = "Sounds/";
    private static final String SOUND_PREFIX = "Reika.ReactorCraft.Sounds.";
    private static final String SOUND_DIR = "Sounds/";
    private static final String SOUND_EXT = ".ogg";
    private static final String MUSIC_FOLDER = "music/";
    private static final String MUSIC_PREFIX = "music.";
    private final String path;
    private final String name;
    private boolean isVolumed = false;

    private ReactorSounds(String n2) {
        if (n2.startsWith("#")) {
            this.isVolumed = true;
            n2 = n2.substring(1);
        }
        this.name = n2;
        this.path = "Reika/ReactorCraft/Sounds/" + this.name + SOUND_EXT;
    }

    public float getSoundVolume() {
        float vol = ConfigRegistry.MACHINEVOLUME.getFloat();
        if (vol < 0.0f) {
            vol = 0.0f;
        }
        if (vol > 1.0f) {
            vol = 1.0f;
        }
        return vol;
    }

    public float getModulatedVolume() {
        if (!this.isVolumed) {
            return 1.0f;
        }
        return this.getSoundVolume();
    }

    public void playSound(Entity e) {
        this.playSound(e, 1.0f, 1.0f);
    }

    public void playSound(Entity e, float vol, float pitch) {
        this.playSound(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, vol, pitch);
    }

    public void playSound(World world, double x, double y, double z, float vol, float pitch) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            return;
        }
        ReikaSoundHelper.playSound((SoundEnum)this, (String)"ReactorCraftData", (World)world, (double)x, (double)y, (double)z, (float)vol, (float)pitch);
    }

    public void playSoundAtBlock(World world, int x, int y, int z, float vol, float pitch) {
        this.playSound(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, vol, pitch);
    }

    public void playSoundAtBlock(World world, int x, int y, int z) {
        this.playSound(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.0f, 1.0f);
    }

    public void playSoundAtBlock(TileEntity te) {
        this.playSoundAtBlock(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public void playSoundAtBlock(WorldLocation loc) {
        this.playSoundAtBlock(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord);
    }

    public String getName() {
        return this.name();
    }

    public String getPath() {
        return this.path;
    }

    public URL getURL() {
        return ReactorCraft.class.getResource("Sounds/" + this.name + SOUND_EXT);
    }

    public static ReactorSounds getSoundByName(String name) {
        for (int i = 0; i < soundList.length; ++i) {
            if (!soundList[i].name().equals(name)) continue;
            return soundList[i];
        }
        ReactorCraft.logger.logError((Object)("\"" + name + "\" does not correspond to a registered sound!"));
        return null;
    }

    public SoundCategory getCategory() {
        return SoundCategory.MASTER;
    }

    public boolean canOverlap() {
        return this == FUSION;
    }

    public boolean attenuate() {
        return true;
    }

    public boolean preload() {
        return false;
    }

    static {
        soundList = ReactorSounds.values();
    }
}

