/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Registry;

import Reika.DragonAPI.Instantiable.MetadataItemBlock;
import Reika.DragonAPI.Interfaces.Registry.BlockEnum;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.ReactorCraft.Blocks.BlockCoriumFlowing;
import Reika.ReactorCraft.Blocks.BlockDuct;
import Reika.ReactorCraft.Blocks.BlockFluorite;
import Reika.ReactorCraft.Blocks.BlockFluoriteOre;
import Reika.ReactorCraft.Blocks.BlockReactorMat;
import Reika.ReactorCraft.Blocks.BlockReactorOre;
import Reika.ReactorCraft.Blocks.BlockReactorTile;
import Reika.ReactorCraft.Blocks.BlockReactorTileModelled;
import Reika.ReactorCraft.Blocks.BlockSteam;
import Reika.ReactorCraft.Blocks.BlockSteamLine;
import Reika.ReactorCraft.Blocks.BlockThoriumFuel;
import Reika.ReactorCraft.Blocks.BlockTritiumLamp;
import Reika.ReactorCraft.Blocks.Multi.BlockFlywheelMulti;
import Reika.ReactorCraft.Blocks.Multi.BlockGeneratorMulti;
import Reika.ReactorCraft.Blocks.Multi.BlockHeaterMulti;
import Reika.ReactorCraft.Blocks.Multi.BlockInjectorMulti;
import Reika.ReactorCraft.Blocks.Multi.BlockSolenoidMulti;
import Reika.ReactorCraft.Blocks.Multi.BlockTurbineMulti;
import Reika.ReactorCraft.Items.ItemBlockFluorite;
import Reika.ReactorCraft.Items.ItemBlockLampMulti;
import Reika.ReactorCraft.Items.ItemBlockMultiBlock;
import Reika.ReactorCraft.Items.ItemBlockReactorMat;
import Reika.ReactorCraft.Items.ItemBlockReactorOre;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.FluoriteTypes;
import Reika.ReactorCraft.Registry.MatBlocks;
import Reika.ReactorCraft.Registry.ReactorOres;
import Reika.ReactorCraft.Registry.ReactorTiles;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public enum ReactorBlocks implements BlockEnum
{
    REACTOR(BlockReactorTile.class, "Reactor", false),
    MATS(BlockReactorMat.class, ItemBlockReactorMat.class, "Reactor Materials", false),
    CORIUMFLOWING(BlockCoriumFlowing.class, "Molten Corium (Flowing)", false),
    MODELREACTOR(BlockReactorTileModelled.class, "ReactorModelled", true),
    MACHINE(BlockReactorTile.class, "Machine", false),
    MODELMACHINE(BlockReactorTileModelled.class, "MachineModelled", true),
    ORE(BlockReactorOre.class, ItemBlockReactorOre.class, "Ore", false),
    FLUORITE(BlockFluorite.class, ItemBlockFluorite.class, "Fluorite", false),
    FLUORITEORE(BlockFluoriteOre.class, ItemBlockFluorite.class, "Fluorite Ore", false),
    STEAM(BlockSteam.class, "Steam", false),
    DUCT(BlockDuct.class, "Duct", false),
    LINE(BlockSteamLine.class, "Line", false),
    INJECTORMULTI(BlockInjectorMulti.class, ItemBlockMultiBlock.class, "multiblock.injector", false),
    HEATERMULTI(BlockHeaterMulti.class, ItemBlockMultiBlock.class, "multiblock.heater", false),
    SOLENOIDMULTI(BlockSolenoidMulti.class, ItemBlockMultiBlock.class, "multiblock.solenoid", false),
    GENERATORMULTI(BlockGeneratorMulti.class, ItemBlockMultiBlock.class, "multiblock.generator", false),
    TURBINEMULTI(BlockTurbineMulti.class, ItemBlockMultiBlock.class, "multiblock.turbine", false),
    FLYWHEELMULTI(BlockFlywheelMulti.class, ItemBlockMultiBlock.class, "multiblock.flywheel", false),
    LAMP(BlockTritiumLamp.class, ItemBlockLampMulti.class, "reactor.lamp", false),
    THORIUM(BlockThoriumFuel.class, MetadataItemBlock.class, "Thorium Fuel", false);

    private Class blockClass;
    private String blockName;
    private Class itemBlock;
    private boolean model;
    public static final ReactorBlocks[] blockList;
    private static final HashMap<Item, ReactorBlocks> itemMap;

    private ReactorBlocks(Class<? extends Block> cl, Class<? extends ItemBlock> ib, String n2, boolean m) {
        this.blockClass = cl;
        this.blockName = n2;
        this.itemBlock = ib;
        this.model = m;
    }

    private ReactorBlocks(Class<? extends Block> cl, String n2) {
        this(cl, null, n2, false);
    }

    private ReactorBlocks(Class<? extends Block> cl, String n2, boolean m) {
        this(cl, null, n2, m);
    }

    public static ReactorBlocks getFromItem(ItemStack is) {
        return itemMap.get(is.func_77973_b());
    }

    public Material getBlockMaterial() {
        switch (this) {
            case MATS: 
            case ORE: 
            case FLUORITE: 
            case FLUORITEORE: {
                return Material.field_151576_e;
            }
            case CORIUMFLOWING: 
            case THORIUM: {
                return Material.field_151587_i;
            }
            case REACTOR: {
                return Material.field_151573_f;
            }
            case LAMP: {
                return Material.field_151592_s;
            }
        }
        return Material.field_151573_f;
    }

    public Class[] getConstructorParamTypes() {
        return new Class[]{Material.class};
    }

    public Object[] getConstructorParams() {
        return new Object[]{this.getBlockMaterial()};
    }

    public String getUnlocalizedName() {
        return ReikaStringParser.stripSpaces((String)this.blockName);
    }

    public Class getObjectClass() {
        return this.blockClass;
    }

    public String getBasicName() {
        return this.blockName;
    }

    public String getMultiValuedName(int meta) {
        switch (this) {
            case MATS: {
                return MatBlocks.matList[meta].getName();
            }
            case ORE: {
                return ReactorOres.oreList[meta].oreName;
            }
            case FLUORITE: {
                return FluoriteTypes.colorList[meta % 8].getBlockName();
            }
            case FLUORITEORE: {
                return FluoriteTypes.colorList[meta % 8].getOreName();
            }
            case LAMP: {
                return FluoriteTypes.colorList[meta].getName() + " " + StatCollector.func_74838_a((String)this.getBasicName());
            }
        }
        return this.getBasicName();
    }

    public boolean hasMultiValuedName() {
        return true;
    }

    public int getNumberMetadatas() {
        switch (this) {
            case REACTOR: 
            case MODELREACTOR: 
            case MACHINE: 
            case MODELMACHINE: {
                return ReactorTiles.getTilesOfBlock(this).size();
            }
            case MATS: {
                return MatBlocks.matList.length;
            }
            case ORE: {
                return ReactorOres.oreList.length;
            }
            case FLUORITE: 
            case FLUORITEORE: {
                return FluoriteTypes.colorList.length;
            }
        }
        return 1;
    }

    public Class<? extends ItemBlock> getItemBlock() {
        return this.itemBlock;
    }

    public boolean hasItemBlock() {
        return this.itemBlock != null;
    }

    public boolean isDummiedOut() {
        return this.blockClass == null;
    }

    public Block getBlockInstance() {
        return ReactorCraft.blocks[this.ordinal()];
    }

    public boolean isModelled() {
        return this.model;
    }

    public Item getItem() {
        return Item.func_150898_a((Block)this.getBlockInstance());
    }

    public boolean matchItem(ItemStack is) {
        return is.func_77973_b() == this.getItem();
    }

    public ItemStack getStackOfMetadata(int meta) {
        return new ItemStack(this.getBlockInstance(), 1, meta);
    }

    public boolean isMachine() {
        return BlockReactorTile.class.isAssignableFrom(this.blockClass);
    }

    public static void loadMappings() {
        for (int i = 0; i < blockList.length; ++i) {
            ReactorBlocks r = blockList[i];
            Block b = r.getBlockInstance();
            itemMap.put(Item.func_150898_a((Block)b), r);
        }
    }

    static {
        blockList = ReactorBlocks.values();
        itemMap = new HashMap();
    }
}

