/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Models;

import Reika.DragonAPI.Instantiable.Rendering.LODModelPart;
import Reika.RotaryCraft.Base.RotaryModelBase;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class ModelTurbine
extends RotaryModelBase {
    private final LODModelPart shaft1;
    private final LODModelPart shaft1a;
    private final LODModelPart blade;
    protected final int stage;

    public ModelTurbine(int stage) {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.stage = stage;
        this.shaft1 = new LODModelPart((ModelBase)this, 0, 106);
        this.shaft1a = new LODModelPart((ModelBase)this, 0, 106);
        this.blade = new LODModelPart((ModelBase)this, 0, 0);
        this.init();
    }

    private void init() {
        this.shaft1.func_78789_a(-2.0f, -2.0f, 0.0f, 4, 4, 16);
        this.shaft1.func_78793_a(0.0f, 15.0f, -8.0f);
        this.shaft1.func_78787_b(128, 128);
        this.shaft1.field_78809_i = true;
        this.setRotation((ModelRenderer)this.shaft1, 0.0f, 0.0f, 0.7853982f);
        this.shaft1a.func_78789_a(-2.0f, -2.0f, 0.0f, 4, 4, 16);
        this.shaft1a.func_78793_a(0.0f, 15.0f, -8.0f);
        this.shaft1a.func_78787_b(128, 128);
        this.shaft1a.field_78809_i = true;
        this.setRotation((ModelRenderer)this.shaft1a, 0.0f, 0.0f, 0.0f);
        this.blade.func_78789_a(-0.5f, (float)(-this.getBladeLength()), (float)(-this.getBladeWidth()) / 2.0f, 1, this.getBladeLength(), this.getBladeWidth());
        this.blade.func_78793_a(0.0f, 15.0f, 0.0f);
        this.blade.func_78787_b(128, 128);
        this.blade.field_78809_i = true;
        this.setRotation((ModelRenderer)this.blade, 0.0f, 0.0f, 0.0f);
    }

    private void clear() {
        this.shaft1.field_78804_l.clear();
        this.shaft1a.field_78804_l.clear();
        this.blade.field_78804_l.clear();
    }

    protected final void reset() {
        this.clear();
        this.init();
    }

    public void renderAll(TileEntity te, ArrayList li, float phi, float theta) {
        double vo = 0.9375;
        double sep = 10.0;
        double dd = 0.25;
        double sc = this.getScaleFactor();
        int damage = li != null ? (Integer)li.get(0) : 0;
        GL11.glTranslated((double)0.0, (double)vo, (double)0.0);
        GL11.glRotatef((float)phi, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)0.0, (double)(-vo), (double)0.0);
        this.shaft1.render(te, 0.0625f);
        this.shaft1a.render(te, 0.0625f);
        GL11.glTranslated((double)0.0, (double)vo, (double)0.0);
        GL11.glRotatef((float)(-phi), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)0.0, (double)(-vo), (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)dd);
        this.renderBlades(te, damage, vo, phi);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-dd * 2.0));
        GL11.glTranslated((double)0.0, (double)vo, (double)0.0);
        GL11.glScaled((double)sc, (double)sc, (double)1.0);
        GL11.glTranslated((double)0.0, (double)(-vo), (double)0.0);
        this.renderBlades(te, damage, vo, phi);
        GL11.glTranslated((double)0.0, (double)vo, (double)0.0);
        GL11.glScaled((double)(1.0 / sc), (double)(1.0 / sc), (double)1.0);
        GL11.glTranslated((double)0.0, (double)(-vo), (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)dd);
    }

    private void renderBlades(TileEntity te, int damage, double vo, float phi) {
        for (int i = 0; i < 360; i += this.getAngularSeparation() * (damage + 1)) {
            GL11.glTranslated((double)0.0, (double)vo, (double)0.0);
            GL11.glRotatef((float)((float)i + phi), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)0.0, (double)(-vo), (double)0.0);
            GL11.glRotatef((float)(-this.getBladeTwist()), (float)0.0f, (float)1.0f, (float)0.0f);
            this.blade.render(te, 0.0625f);
            GL11.glRotatef((float)this.getBladeTwist(), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)0.0, (double)vo, (double)0.0);
            GL11.glRotatef((float)((float)(-i) - phi), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)0.0, (double)(-vo), (double)0.0);
        }
    }

    public int getBladeLength() {
        switch (this.stage) {
            case 0: {
                return 16;
            }
            case 1: {
                return 24;
            }
            case 2: {
                return 28;
            }
            case 3: {
                return 33;
            }
            case 4: {
                return 40;
            }
        }
        return 4;
    }

    public int getAngularSeparation() {
        switch (this.stage) {
            case 0: {
                return 8;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 6: {
                return 10;
            }
        }
        return 10;
    }

    public int getBladeTwist() {
        switch (this.stage) {
            case 0: {
                return 10;
            }
            case 1: {
                return 15;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 30;
            }
            case 4: {
                return 45;
            }
            case 5: {
                return 45;
            }
            case 6: {
                return 50;
            }
        }
        return 10;
    }

    public int getBladeWidth() {
        switch (this.stage) {
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 8;
            }
        }
        return 2;
    }

    public double getScaleFactor() {
        if (this.stage < 1) {
            return 1.3;
        }
        return 1.1;
    }
}

