/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.BCPipeHandler;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class LiquidHandler {
    @SubscribeEvent
    public void onFluidEntersPipe(FluidEvent.FluidMotionEvent evt) {
        block9: {
            TileEntity te;
            FluidStack liq;
            int z;
            int y;
            int x;
            World world;
            block10: {
                int i;
                world = evt.world;
                x = evt.x;
                y = evt.y;
                z = evt.z;
                liq = evt.fluid;
                if (liq == null) break block9;
                if (!liq.getFluid().equals(FluidRegistry.getFluid((String)"fusion plasma"))) break block10;
                TileEntity te2 = world.func_147438_o(x, y, z);
                if (te2 instanceof TileEntityReactorBase) break block9;
                ForgeDirection[] dirs = ForgeDirection.values();
                BlockArray blocks = new BlockArray();
                for (i = 0; i < 6; ++i) {
                    ForgeDirection dir = dirs[i];
                    int dx = x + dir.offsetX;
                    int dy = y + dir.offsetY;
                    int dz = z + dir.offsetZ;
                    Block id = world.func_147439_a(dx, dy, dz);
                    int meta = world.func_72805_g(dx, dy, dz);
                    TileEntity te22 = world.func_147438_o(dx, dy, dz);
                    if (te22 instanceof TileEntityReactorBase) continue;
                    blocks.recursiveAdd(world, dx, dy, dz, id);
                }
                for (i = 0; i < blocks.getSize(); ++i) {
                    Coordinate c = blocks.getNthBlock(i);
                    TileEntity te23 = world.func_147438_o(c.xCoord, c.yCoord, c.zCoord);
                    if (te23 instanceof TileEntityReactorBase) continue;
                    ReikaSoundHelper.playSoundAtBlock((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (String)"random.fizz", (float)0.4f, (float)1.0f);
                    ReikaParticleHelper.LAVA.spawnAroundBlock(world, c.xCoord, c.yCoord, c.zCoord, 36);
                    c.setBlock(world, (Block)Blocks.field_150356_k);
                    int r = 4;
                    for (int dx = c.xCoord - r; dx <= c.xCoord + r; ++dx) {
                        for (int dy = c.yCoord - r; dy <= c.yCoord + r; ++dy) {
                            for (int dz = c.zCoord - r; dz <= c.zCoord + r; ++dz) {
                                ReikaWorldHelper.temperatureEnvironment((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (int)150000000);
                            }
                        }
                    }
                }
                break block9;
            }
            if (this.isCorrosive(liq.getFluid()) && (te = world.func_147438_o(x, y, z)) instanceof IFluidHandler) {
                int i;
                IFluidHandler ifl = (IFluidHandler)te;
                ForgeDirection[] dirs = ForgeDirection.values();
                BlockArray blocks = new BlockArray();
                for (i = 0; i < 6; ++i) {
                    ForgeDirection dir = dirs[i];
                    int dx = x + dir.offsetX;
                    int dy = y + dir.offsetY;
                    int dz = z + dir.offsetZ;
                    Block id = world.func_147439_a(dx, dy, dz);
                    int meta = world.func_72805_g(dx, dy, dz);
                    TileEntity te2 = world.func_147438_o(dx, dy, dz);
                    if (!(te2 instanceof IFluidHandler)) continue;
                    blocks.recursiveAdd(world, dx, dy, dz, id);
                }
                for (i = 0; i < blocks.getSize(); ++i) {
                    Coordinate c = blocks.getNthBlock(i);
                    if (this.isCorrodable(world, c.xCoord, c.yCoord, c.zCoord)) {
                        ReikaSoundHelper.playSoundAtBlock((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (String)"random.fizz", (float)0.4f, (float)1.0f);
                        ReikaParticleHelper.SMOKE.spawnAroundBlock(world, x, y, z, 6);
                        c.setBlock(world, Blocks.field_150350_a);
                        continue;
                    }
                    if (!this.isExplodable(world, c.xCoord, c.yCoord, c.zCoord)) continue;
                    world.func_72876_a(null, (double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5, 2.0f, true);
                    c.setBlock(world, Blocks.field_150350_a);
                }
            }
        }
    }

    public boolean isCorrosive(Fluid f) {
        if (f.equals(FluidRegistry.getFluid((String)"uranium hexafluoride"))) {
            return true;
        }
        return f.equals(FluidRegistry.getFluid((String)"hydrofluoric acid"));
    }

    public boolean isCorrodable(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (m == MachineRegistry.PIPE) {
            return true;
        }
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        if (id == BCPipeHandler.getInstance().pipeID) {
            BCPipeHandler.Types type = BCPipeHandler.getInstance().getPipeType(te);
            if (type == BCPipeHandler.Types.GOLD) {
                return true;
            }
            if (type == BCPipeHandler.Types.IRON) {
                return true;
            }
        }
        return false;
    }

    public boolean isExplodable(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        if (id == BCPipeHandler.getInstance().pipeID) {
            BCPipeHandler.Types type = BCPipeHandler.getInstance().getPipeType(te);
            if (type == BCPipeHandler.Types.DIAMOND) {
                return true;
            }
            if (type == BCPipeHandler.Types.EMERALD) {
                return true;
            }
        }
        return false;
    }
}

