/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Items;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerMap;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.ReactorCraft.Base.ReactorItemBase;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemIronFinder
extends ReactorItemBase {
    private static final PlayerMap<OreCollection> cache = new PlayerMap();
    private static final OreType[] ores = new OreType[]{ReikaOreHelper.IRON, ReikaOreHelper.REDSTONE, ModOreList.NICKEL, ModOreList.COBALT, ModOreList.CERTUSQUARTZ, ModOreList.NIKOLITE, ModOreList.MAGNETITE, ModOreList.NETHERIRON, ModOreList.NETHERREDSTONE, ModOreList.NETHERNICKEL, ModOreList.NETHERNIKOLITE, ModOreList.TESLATITE};

    public ItemIronFinder(int tex) {
        super(tex);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        return is;
    }

    public void func_77663_a(ItemStack is, World world, Entity e, int par4, boolean isHeld) {
    }

    public static MultiMap<OreType, Coordinate> getOreNearby(EntityPlayer ep, int range) {
        OreCollection c = (OreCollection)cache.get(ep);
        if (c == null || System.currentTimeMillis() - c.time >= 500L) {
            c = new OreCollection(ep, ItemIronFinder.findOreNearby(ep, range, ores));
            cache.put(ep, (Object)c);
        }
        return c.locations;
    }

    private static MultiMap<OreType, Coordinate> findOreNearby(EntityPlayer ep, int range, OreType ... ores) {
        MultiMap m = new MultiMap();
        for (int o = 0; o < ores.length; ++o) {
            OreType ore = ores[o];
            if (!ore.existsInGame()) continue;
            World world = ep.field_70170_p;
            int x = MathHelper.func_76128_c((double)ep.field_70165_t);
            int y = MathHelper.func_76128_c((double)(ep.field_70163_u + (double)ep.func_70047_e()));
            int z = MathHelper.func_76128_c((double)ep.field_70161_v);
            ArrayList c = new ArrayList();
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    for (int k = -range; k <= range; ++k) {
                        int dx = x + i;
                        int dy = y + j;
                        int dz = z + k;
                        ItemStack block = ReikaBlockHelper.getWorldBlockAsItemStack((World)world, (int)dx, (int)dy, (int)dz);
                        if (!ReikaItemHelper.collectionContainsItemStack((Collection)ore.getAllOreBlocks(), (ItemStack)block)) continue;
                        m.addValue((Object)ore, (Object)new Coordinate(dx, dy, dz));
                    }
                }
            }
        }
        return m;
    }

    private static class OreCollection {
        public final long time;
        public final MultiMap<OreType, Coordinate> locations;
        public final String player;

        private OreCollection(EntityPlayer ep, MultiMap<OreType, Coordinate> c) {
            this.locations = c;
            this.player = ep.func_70005_c_();
            this.time = System.currentTimeMillis();
        }
    }
}

