/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Blocks;

import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.RadiationEffects;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.RotaryCraft.Registry.BlockRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidFinite;

public class BlockThoriumFuel
extends BlockFluidFinite {
    private IIcon[] icon;

    public BlockThoriumFuel(Material material) {
        super(ReactorCraft.LIFBe_fuel, material);
        this.func_149711_c(100.0f);
        this.func_149713_g(100);
        this.func_149752_b(500.0f);
        this.func_149647_a((CreativeTabs)(ReactorCraft.instance.isLocked() ? null : ReactorCraft.tabRctr));
        this.setQuantaPerBlock(8);
    }

    public void func_149666_a(Item i, CreativeTabs c, List li) {
        li.add(new ItemStack((Block)this, 1, 7));
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        if (rand.nextInt(4) == 0) {
            // empty if block
        }
        if (ReikaRandomHelper.doWithChance((double)0.005)) {
            RadiationEffects.instance.contaminateArea(world, x, y + ReikaRandomHelper.getSafeRandomInt((int)2), z, 2, 0.25f, 0.0, false, RadiationEffects.RadiationIntensity.MODERATE);
        }
    }

    private void tryAggressiveSpread(World world, int x, int y, int z, Random rand) {
        for (int i = 0; i < 6; ++i) {
            int f;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            if (dir == ForgeDirection.UP) continue;
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (world.func_147439_a(dx, dy, dz) != this) {
                if (!BlockThoriumFuel.canOverwrite(world, dx, dy, dz)) continue;
            }
            if ((f = this.getFillDifference(world, x, y, z, dx, dy, dz)) > 0) {
                this.spreadTo(world, x, y, z, dx, dy, dz);
                return;
            }
            if (f != 0 || rand.nextInt(4) != 0) continue;
            world.func_147465_d(dx, dy, dz, (Block)this, world.func_72805_g(x, y, z), 3);
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            return;
        }
    }

    private void spreadTo(World world, int x, int y, int z, int x2, int y2, int z2) {
        int avg;
        int f1 = this.getFill(world, x, y, z) - 1;
        int f2 = this.getFill(world, x2, y2, z2) - 1;
        int fb1 = avg = f1 + f2;
        int fb2 = avg % 2 == 0 ? avg : avg + 1;
        world.func_147465_d(x, y, z, (Block)this, fb1, 3);
        world.func_147465_d(x2, y2, z2, (Block)this, fb2, 3);
    }

    private int getFillDifference(World world, int x, int y, int z, int x2, int y2, int z2) {
        int f1 = this.getFill(world, x, y, z);
        int f2 = this.getFill(world, x2, y2, z2);
        return f1 - f2;
    }

    private int getFill(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == this ? world.func_72805_g(x, y, z) + 1 : 0;
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        return BlockThoriumFuel.canOverwrite(world, x, y, z);
    }

    public boolean isReplaceable(IBlockAccess world, int i, int j, int k) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("ReactorCraft:fluid/lifbe_fuel");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int s, int meta) {
        return this.field_149761_L;
    }

    private void checkForHarden(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) == this) {
            boolean flag = false;
            if (flag || ReikaWorldHelper.getMaterial((World)world, (int)x, (int)y, (int)(z - 1)) == Material.field_151586_h) {
                flag = true;
            }
            if (flag || ReikaWorldHelper.getMaterial((World)world, (int)x, (int)y, (int)(z + 1)) == Material.field_151586_h) {
                flag = true;
            }
            if (flag || ReikaWorldHelper.getMaterial((World)world, (int)(x - 1), (int)y, (int)z) == Material.field_151586_h) {
                flag = true;
            }
            if (flag || ReikaWorldHelper.getMaterial((World)world, (int)(x + 1), (int)y, (int)z) == Material.field_151586_h) {
                flag = true;
            }
            if (flag || ReikaWorldHelper.getMaterial((World)world, (int)x, (int)(y + 1), (int)z) == Material.field_151586_h) {
                flag = true;
            }
            if (flag) {
                this.func_149695_a(world, x, y, z, (Block)this);
            }
        }
    }

    public void func_149726_b(World world, int par2, int par3, int par4) {
        this.checkForHarden(world, par2, par3, par4);
        world.func_147464_a(par2, par3, par4, (Block)this, this.func_149738_a(world));
    }

    public static boolean canOverwrite(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (b == ReactorBlocks.THORIUM.getBlockInstance()) {
            return false;
        }
        if (b == BlockRegistry.PIPING.getBlockInstance()) {
            return true;
        }
        if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            return true;
        }
        String n = b.getClass().getSimpleName().toLowerCase(Locale.ENGLISH);
        return n.contains("duct") || n.contains("conduit") || n.contains("cable") || n.contains("pipe");
    }
}

