/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Blocks;

import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.ReactorCraft.Blocks.BlockFluorite;
import Reika.ReactorCraft.Registry.FluoriteTypes;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorOptions;
import Reika.ReactorCraft.Registry.ReactorOres;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFluoriteOre
extends BlockFluorite {
    private IIcon rainbowIcon;

    public BlockFluoriteOre(Material par2Material) {
        super(par2Material);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        int count = this.getNumberDrops(fortune);
        for (int i = 0; i < count; ++i) {
            li.add(ReactorItems.FLUORITE.getStackOfMetadata(this.getMetaDropped(metadata)));
        }
        ReikaWorldHelper.splitAndSpawnXP((World)world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), (int)this.droppedXP());
        return li;
    }

    private int getMetaDropped(int metadata) {
        return ReactorOptions.RAINBOW.getState() ? rand.nextInt(FluoriteTypes.colorList.length) : metadata % 8;
    }

    private int getNumberDrops(int fortune) {
        if (ReactorOptions.RAINBOW.getState()) {
            return FluoriteTypes.colorList.length + fortune * 4 + rand.nextInt(11 + fortune * 6);
        }
        return 1 + fortune + rand.nextInt(5 + 2 * fortune);
    }

    private int droppedXP() {
        int factor = ReactorOptions.RAINBOW.getState() ? 6 : 1;
        return ReikaRandomHelper.doWithChance((double)(ReactorOres.FLUORITE.xpDropped * (float)factor)) ? 1 : 0;
    }

    @Override
    public IIcon func_149691_a(int s, int meta) {
        return ReactorOptions.RAINBOW.getState() ? this.rainbowIcon : super.func_149691_a(s, meta);
    }

    public ItemStack getPickBlock(MovingObjectPosition tgt, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) % 8;
        return new ItemStack(ReactorBlocks.FLUORITEORE.getBlockInstance(), 1, meta);
    }

    @Override
    public void func_149651_a(IIconRegister ico) {
        for (int k = 0; k < FluoriteTypes.colorList.length; ++k) {
            this.icons[k] = ico.func_94245_a(FluoriteTypes.colorList[k].getOreTextureName());
        }
        this.rainbowIcon = ico.func_94245_a("ReactorCraft:ore/fluorite_rainbow");
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int color = this.getColorType(world, x, y, z).getColor();
        int l = this.isActivated(world, x, y, z) ? 12 : 6;
        return ModList.COLORLIGHT.isLoaded() ? ReikaColorAPI.getPackedIntForColoredLight((int)color, (int)l) : l;
    }

    public boolean func_149686_d() {
        return true;
    }

    public float func_149685_I() {
        return 0.7f;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return 0;
    }
}

