/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Blocks;

import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.ModList;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.FluoriteTypes;
import Reika.ReactorCraft.Registry.ReactorOres;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFluorite
extends Block {
    protected IIcon[] icons = new IIcon[FluoriteTypes.colorList.length];
    protected static final Random rand = new Random();

    public BlockFluorite(Material par2Material) {
        super(par2Material);
        this.func_149711_c(1.2f);
        this.func_149752_b(4.0f);
        this.func_149647_a((CreativeTabs)(ReactorCraft.instance.isLocked() ? null : ReactorCraft.tabRctr));
        this.func_149675_a(true);
    }

    public int func_149738_a(World world) {
        return 20;
    }

    public final int getHarvestLevel(int meta) {
        return ReactorOres.FLUORITE.harvestLevel;
    }

    public void func_149674_a(World world, int x, int y, int z, Random r) {
        if (this.isActivated((IBlockAccess)world, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)this, this.getColorType((IBlockAccess)world, x, y, z).ordinal(), 3);
        }
    }

    public void func_149651_a(IIconRegister ico) {
        for (int k = 0; k < FluoriteTypes.colorList.length; ++k) {
            this.icons[k] = ico.func_94245_a(FluoriteTypes.colorList[k].getBlockTextureName());
        }
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[meta % FluoriteTypes.colorList.length];
    }

    public int func_149692_a(int meta) {
        return meta % FluoriteTypes.colorList.length;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int color = this.getColorType(world, x, y, z).getColor();
        return this.isActivated(world, x, y, z) ? (ModList.COLORLIGHT.isLoaded() ? ReikaColorAPI.getPackedIntForColoredLight((int)color, (int)15) : 15) : 0;
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        double offset = 0.125;
        int meta = world.func_72805_g(x, y, z);
        FluoriteTypes fl = this.getColorType((IBlockAccess)world, x, y, z);
        double r = (double)fl.red / 255.0;
        double g = (double)fl.green / 255.0;
        double b = (double)fl.blue / 255.0;
        if (fl == FluoriteTypes.WHITE) {
            b = 4.0;
            g = 4.0;
            r = 4.0;
        }
        if (this.isActivated((IBlockAccess)world, x, y, z)) {
            ReikaParticleHelper.spawnColoredParticlesWithOutset((World)world, (int)x, (int)y, (int)z, (double)r, (double)g, (double)b, (int)4, (double)offset);
        }
    }

    public boolean isActivated(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta >= FluoriteTypes.colorList.length;
    }

    public FluoriteTypes getColorType(IBlockAccess world, int x, int y, int z) {
        return FluoriteTypes.colorList[world.func_72805_g(x, y, z) % FluoriteTypes.colorList.length];
    }
}

