/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Base;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.ReactorCraft.Base.TileEntityNuclearBoiler;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.util.Locale;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public abstract class TileEntityIntermediateBoiler
extends TileEntityNuclearBoiler {
    protected StepTimer timer = new StepTimer(20);
    protected final HybridTank output = new HybridTank(this.getName().toLowerCase(Locale.ENGLISH) + "out", this.getCapacity());

    @Override
    public final FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo(), this.output.getInfo()};
    }

    public abstract int getLiquidUsage();

    public abstract int getMinimumTemperature();

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        this.timer.update();
        if (this.timer.checkCap() && this.canHeat()) {
            this.heat();
        }
        if (DragonAPICore.debugtest) {
            this.addLiquid(1000);
        }
        this.transferFluid(world, x, y, z);
    }

    private void transferFluid(World world, int x, int y, int z) {
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, x, y + 1, z);
        if (r == this.getMachine()) {
            int amt;
            TileEntityIntermediateBoiler te = (TileEntityIntermediateBoiler)world.func_147438_o(x, y + 1, z);
            if (!te.tank.isFull() && !this.tank.isEmpty()) {
                amt = Math.min(this.tank.getLevel(), Math.min(100, te.tank.getCapacity() - te.tank.getLevel()));
                te.tank.addLiquid(amt, this.tank.getActualFluid());
                this.tank.removeLiquid(amt);
            }
            if (!te.output.isFull() && !this.output.isEmpty()) {
                amt = Math.min(this.output.getLevel(), Math.min(100, te.output.getCapacity() - te.output.getLevel()));
                te.output.addLiquid(amt, this.output.getActualFluid());
                this.output.removeLiquid(amt);
            }
        }
    }

    protected void heat() {
        int amt = this.getLiquidUsage();
        double c = this.getFluidHeatCapacity();
        this.temperature = (int)((double)this.temperature - (double)amt * c);
        this.tank.removeLiquid(amt);
        this.output.addLiquid(amt, this.getOutputFluid());
    }

    protected abstract Fluid getOutputFluid();

    protected abstract double getFluidHeatCapacity();

    public boolean canHeat() {
        return this.temperature >= this.getMinimumTemperature() && this.tank.getLevel() >= this.getLiquidUsage() && !this.output.isFull() && this.tank.getActualFluid().equals(this.getInputFluid());
    }

    public final boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    public final void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
        this.output.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
        this.output.writeToNBT(NBT);
    }

    @Override
    public final FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.output.drain(resource.amount, doDrain) : null;
    }

    @Override
    public final FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.canDrain(from, null)) {
            return null;
        }
        return this.output.drain(maxDrain, doDrain);
    }

    @Override
    public final boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UP && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    @Override
    public final IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (with == ForgeDirection.UP) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return super.overridePipeConnection(type, with);
    }

    @Override
    public final TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return TileEntityPiping.Flow.OUTPUT;
        }
        return super.getFlowForSide(side);
    }

    @Override
    public final boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return side.offsetY != 0 && this.canConnectToPipe(p);
    }
}

