/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Base;

import Reika.ReactorCraft.Auxiliary.ReactorPowerReceiver;
import Reika.ReactorCraft.Base.TileEntityTankedReactorMachine;
import Reika.RotaryCraft.API.Power.PowerTransferHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TankedReactorPowerReceiver
extends TileEntityTankedReactorMachine
implements ReactorPowerReceiver {
    private long power;
    private int omega;
    private int torque;
    private int iotick;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!PowerTransferHelper.checkPowerFrom((TileEntity)this, (ForgeDirection)ForgeDirection.DOWN)) {
            this.noInputMachine();
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        if (this.iotick > 0) {
            this.iotick -= 8;
        }
    }

    public final int getOmega() {
        return this.omega;
    }

    public final int getTorque() {
        return this.torque;
    }

    public final long getPower() {
        return this.power;
    }

    public final int getIORenderAlpha() {
        return this.iotick;
    }

    public final void setIORenderAlpha(int io) {
        this.iotick = io;
    }

    public final void setOmega(int omega) {
        this.omega = omega;
    }

    public final void setTorque(int torque) {
        this.torque = torque;
    }

    public final void setPower(long power) {
        this.power = power;
    }

    public final boolean isReceiving() {
        return true;
    }

    public final void noInputMachine() {
        this.omega = 0;
        this.torque = 0;
        this.power = 0L;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
        this.omega = NBT.func_74762_e("speed");
        this.torque = NBT.func_74762_e("trq");
        this.power = NBT.func_74763_f("pwr");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
        NBT.func_74768_a("speed", this.omega);
        NBT.func_74768_a("trq", this.torque);
        NBT.func_74772_a("pwr", this.power);
    }

    public final boolean sufficientPower() {
        return this.power >= this.getMinPower() && this.omega >= this.getMinSpeed() && this.torque >= this.getMinTorque();
    }
}

