/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees.generators;

import java.util.Random;
import karob.bigtrees.KTreeCfg;
import karob.bigtrees.compat.WorldWrapper;
import karob.bigtrees.config.BlockAndMeta;
import karob.bigtrees.config.ITreeConfigurable;
import karob.bigtrees.config.TreeConfiguration;
import karob.bigtrees.generators.AbstractWorldGenerator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class KWorldGenTallTree
extends AbstractWorldGenerator
implements ITreeConfigurable {
    private int[][][] check;
    private boolean planted;
    private double branchlessmin;
    private double branchlessmax;
    private double longestbranchp;
    private double branchrot;
    private double taplength;
    private double branchspace;
    private double pitch;
    private double curl;
    private int leafrad;
    private double subbranchdensity;
    private double subbranchinglength;
    private int subbranchingsize;
    private double subbranchangle;
    private double subbranchsize;

    public KWorldGenTallTree(boolean flag) {
        super(flag);
        this.planted = flag;
        this.check = new int[9][9][9];
    }

    @Override
    public void setTreeConfiguration(TreeConfiguration treeConfiguration) {
        super.setTreeConfiguration(treeConfiguration);
        this.branchlessmin = treeConfiguration.getMinBranchless();
        this.branchlessmax = treeConfiguration.getMaxBranchless();
        this.longestbranchp = treeConfiguration.getLongestBranchPercentage();
        this.branchrot = treeConfiguration.getBranchRotation();
        this.taplength = treeConfiguration.getTapLength();
        this.branchspace = treeConfiguration.getBranchSpace();
        this.pitch = treeConfiguration.getPitch();
        this.curl = treeConfiguration.getCurl();
        this.leafrad = treeConfiguration.getLeafRadius();
        this.subbranchdensity = treeConfiguration.getSubBranchDensity();
        this.subbranchinglength = treeConfiguration.getSubBranchingLength();
        this.subbranchingsize = treeConfiguration.getSubBranchingSize();
        this.subbranchangle = treeConfiguration.getSubBranchAngle();
        this.subbranchsize = treeConfiguration.getSubBranchSize();
    }

    @Override
    public boolean generate(WorldWrapper world, Random random, int i, int j, int k) {
        BlockAndMeta zz;
        int ll;
        BlockAndMeta id;
        this.worldObject = world;
        this.rand = random;
        int l = random.nextInt(this.heightmax - this.heightmin) + this.heightmin;
        if (j < 1) {
            return false;
        }
        if (j + l + 1 > 256 && (l = 256 - j - 2) < this.stuntmin) {
            return false;
        }
        if (!this.planted) {
            if (!this.isSupportedBaseBlock(i, j - 1, k)) {
                return false;
            }
            id = this.getBlock(i, j, k);
            if (!id.isAir() && !id.areEqual(this.leaf)) {
                return false;
            }
        }
        for (ll = 0; ll <= l && ((zz = this.getBlock(i, j + ll, k)).isAir() || zz.areEqual(new BlockAndMeta[]{this.wood, this.leaf})); ++ll) {
        }
        if (ll < this.stuntmin) {
            return false;
        }
        int zzz = random.nextInt((int)(100.0 * (this.branchlessmax - this.branchlessmin) + this.branchlessmin));
        int m = l * zzz / 100 + j;
        this.setBlockAndMetadata(i, j, k, this.wood);
        if (KTreeCfg.rootsEnable) {
            int jj = 1;
            while ((double)jj < (double)ll * this.taplength / 100.0 && ((zz = this.getBlock(i, j - jj, k)).isAir() || zz.areEqual(new BlockAndMeta[]{this.wood, this.leaf}) || zz.areEqual(new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150358_i, Blocks.field_150355_j, Blocks.field_150354_m, Blocks.field_150351_n}))) {
                this.setBlockAndMetadata(i, j - jj, k, this.wood);
                ++jj;
            }
        }
        double bd = (double)random.nextFloat() * 2.0 * Math.PI;
        boolean growflag = true;
        int jj = j;
        for (int j1 = j; j1 <= j + l; ++j1) {
            int branchs;
            if (growflag) {
                id = this.getBlock(i, jj + 1, k);
                if (id.isAir() || id.areEqual(new BlockAndMeta[]{this.wood, this.leaf})) {
                    this.setBlockAndMetadata(i, ++jj, k, this.wood);
                } else {
                    growflag = false;
                }
            }
            if ((branchs = (int)(100.0 * this.branchspace)) < 0) {
                branchs = 0;
            }
            if (j1 >= m && random.nextInt(branchs) < 100 * (j1 - m) / (j + l - m + 1)) {
                double bl = (double)l * this.longestbranchp;
                bl = bl * (double)(j + l - jj + 1) / (double)(j + l - m + 1);
                this.treeBranch(i, jj, k, bd, bl, this.pitch, this.curl);
            }
            bd += this.branchrot;
            if (j1 != j + l || this.leafrad <= 0) continue;
            this.treeLeaf(i, jj, k, this.leafrad);
        }
        return true;
    }

    void treeBranch(int i, int j, int k, double dir, double len, double up, double crv) {
        double ll;
        if (len < 1.0) {
            return;
        }
        double xx = Math.cos(dir);
        double yy = up;
        double zz = Math.sin(dir);
        double dd = Math.sqrt(xx * xx + yy * yy + zz * zz);
        int xpol = xx > 0.0 ? 1 : -1;
        int ypol = yy > 0.0 ? 1 : -1;
        int zpol = zz > 0.0 ? 1 : -1;
        xx = Math.abs(xx) / dd;
        yy = Math.abs(yy) / dd;
        zz = Math.abs(zz) / dd;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        int ii = i;
        int jj = j;
        int kk = k;
        for (ll = len; ll > 0.0; ll -= 1.0) {
            boolean chg = false;
            if ((dx += xx) >= 1.0) {
                ii += xpol;
                dx -= 1.0;
                chg = true;
            }
            if ((dy += yy) >= 1.0) {
                jj += ypol;
                dy -= 1.0;
                chg = true;
            }
            if ((dz += zz) >= 1.0) {
                kk += zpol;
                dz -= 1.0;
                chg = true;
            }
            if (chg) {
                BlockAndMeta id = this.getBlock(ii, jj, kk);
                if (!id.isAir() && !id.areEqual(new BlockAndMeta[]{this.wood, this.leaf})) break;
                this.setBlockAndMetadata(ii, jj, kk, this.wood);
            }
            if ((double)this.rand.nextInt(100) < this.subbranchdensity && len >= (double)this.subbranchingsize && ll < len * this.subbranchinglength) {
                if (this.rand.nextInt(10) < 5) {
                    this.treeBranch(ii, jj, kk, dir + this.subbranchangle, ll * this.subbranchsize, yy, crv);
                } else {
                    this.treeBranch(ii, jj, kk, dir - this.subbranchangle, ll * this.subbranchsize, yy, crv);
                }
            }
            xx = Math.cos(dir);
            yy = up += crv;
            zz = Math.sin(dir);
            dd = Math.sqrt(xx * xx + yy * yy + zz * zz);
            xpol = xx > 0.0 ? 1 : -1;
            ypol = yy > 0.0 ? 1 : -1;
            zpol = zz > 0.0 ? 1 : -1;
            xx = Math.abs(xx) / dd;
            yy = Math.abs(yy) / dd;
            zz = Math.abs(zz) / dd;
        }
        if (ll <= len / 2.0 && this.leafrad > 0) {
            int klen = (int)(len / 2.0);
            if (klen >= this.leafrad) {
                this.treeLeaf(ii, jj, kk, this.leafrad);
            } else if (klen >= 1) {
                this.treeLeaf(ii, jj, kk, klen);
            } else {
                this.treeLeaf(ii, jj, kk, 1);
            }
        }
    }

    void treeLeaf(int i, int j, int k, int r) {
        if (r <= 0) {
            return;
        }
        if (r <= 3) {
            for (int ii = -r - 1; ii <= r + 1; ++ii) {
                for (int jj = -2; jj <= r + 1; ++jj) {
                    for (int kk = -r - 1; kk <= r + 1; ++kk) {
                        BlockAndMeta zz = this.getBlock(i + ii, j + jj, k + kk);
                        this.check[ii + 4][jj + 4][kk + 4] = zz.isAir() ? 2 : (zz.areEqual(this.leaf) ? 1 : 0);
                    }
                }
            }
            this.leafShell(i, j, k, 1);
            if (r >= 2) {
                this.leafShell(i, j, k, 2);
            }
            if (r == 3) {
                this.leafShell(i, j, k, 3);
            }
        } else {
            int rr = r * r;
            for (int ii = -r; ii <= r; ++ii) {
                for (int jj = -r / 2; jj <= r; ++jj) {
                    for (int kk = -r; kk <= r; ++kk) {
                        if (ii * ii + jj * jj + kk * kk > rr || !this.getBlock(i + ii, j + jj, k + kk).isAir() || this.rand.nextInt(3) != 0) continue;
                        this.setBlockAndMetadata(i + ii, j + jj, k + kk, this.leaf);
                    }
                }
            }
        }
    }

    void leafShell(int i, int j, int k, int r) {
        int rr = r * r + 1;
        int rrr = (r - 1) * (r - 1);
        for (int ii = 0; ii <= r; ++ii) {
            for (int jj = 0; jj <= r; ++jj) {
                for (int kk = 0; kk <= r; ++kk) {
                    int zz = ii * ii + jj * jj + kk * kk;
                    if (zz > rr || zz <= rrr) continue;
                    this.plotLeaf(i, j, k, ii, jj, kk, r);
                    this.plotLeaf(i, j, k, ii, jj, -kk, r);
                    this.plotLeaf(i, j, k, -ii, jj, kk, r);
                    this.plotLeaf(i, j, k, -ii, jj, -kk, r);
                    if (jj < 1) {
                        this.plotLeaf(i, j, k, ii, -jj, kk, r);
                        this.plotLeaf(i, j, k, ii, -jj, -kk, r);
                        this.plotLeaf(i, j, k, -ii, -jj, kk, r);
                        this.plotLeaf(i, j, k, -ii, -jj, -kk, r);
                        continue;
                    }
                    if (jj != 1) continue;
                    if (this.rand.nextInt(3) > 0) {
                        this.plotLeaf(i, j, k, ii, -jj, kk, r);
                    }
                    if (this.rand.nextInt(3) > 0) {
                        this.plotLeaf(i, j, k, ii, -jj, -kk, r);
                    }
                    if (this.rand.nextInt(3) > 0) {
                        this.plotLeaf(i, j, k, -ii, -jj, kk, r);
                    }
                    if (this.rand.nextInt(3) <= 0) continue;
                    this.plotLeaf(i, j, k, -ii, -jj, -kk, r);
                }
            }
        }
    }

    void plotLeaf(int i, int j, int k, int ii, int jj, int kk, int r) {
        if (this.check[ii + 4][jj + 4][kk + 4] != 2) {
            return;
        }
        boolean flag = false;
        if (r == 1) {
            flag = true;
        } else {
            if (this.check[ii + 3][jj + 4][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 5][jj + 4][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 3][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 5][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 4][kk + 3] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 4][kk + 5] == 1) {
                flag = true;
            }
            if (this.check[ii + 3][jj + 3][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 3][jj + 5][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 3][jj + 4][kk + 3] == 1) {
                flag = true;
            }
            if (this.check[ii + 3][jj + 4][kk + 5] == 1) {
                flag = true;
            }
            if (this.check[ii + 5][jj + 3][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 5][jj + 5][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 5][jj + 4][kk + 3] == 1) {
                flag = true;
            }
            if (this.check[ii + 5][jj + 4][kk + 5] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 3][kk + 3] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 3][kk + 5] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 5][kk + 3] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 5][kk + 5] == 1) {
                flag = true;
            }
        }
        if (flag) {
            this.setBlockAndMetadata(i + ii, j + jj, k + kk, this.leaf);
            this.check[ii + 4][jj + 4][kk + 4] = 1;
        }
    }
}

