/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees.generators;

import java.util.Random;
import karob.bigtrees.KTreeCfg;
import karob.bigtrees.compat.WorldWrapper;
import karob.bigtrees.config.BlockAndMeta;
import karob.bigtrees.config.ITreeConfigurable;
import karob.bigtrees.generators.AbstractWorldGenerator;
import net.minecraft.init.Blocks;

public class KWorldGenHatTree
extends AbstractWorldGenerator
implements ITreeConfigurable {
    private int[][][] check;
    private boolean planted;
    private int baseY;

    public KWorldGenHatTree(boolean flag) {
        super(flag);
        this.planted = flag;
        this.check = new int[9][9][9];
        this.rootRand = 0;
        this.rootAlt = 0;
    }

    @Override
    public boolean generate(WorldWrapper world, Random random, int i, int j, int k) {
        return this.generateCustom(world, random, i, j, k, 4, 30);
    }

    public boolean generateCustom(WorldWrapper world, Random random, int i, int j, int k, int hatBase, int hatHeight) {
        int n;
        this.worldObject = world;
        this.rand = random;
        this.baseY = j;
        int l = random.nextInt(this.heightmax - this.heightmin) + this.heightmin;
        if (j < 1) {
            return false;
        }
        if (j + l + 1 > 256 && (l = 256 - j - 2) < this.stuntmin) {
            return false;
        }
        if (!this.planted) {
            if (!this.isSupportedBaseBlock(i, j - 1, k)) {
                return false;
            }
            BlockAndMeta id = this.getBlock(i, j, k);
            if (!id.isAir() && !id.areEqual(this.leaf)) {
                return false;
            }
        }
        double pitch = 1.2566370614359172;
        double pbias = 0.0;
        double dir = (double)this.rand.nextFloat() * Math.PI / 2.0;
        double spin = 3.8830085198369844;
        double grow = 10.0;
        double shrink = 0.618;
        double len = l;
        double y = l;
        double rootSlope = 0.0;
        this.growRoot(i, j, k - 1, 0.6625, rootSlope);
        this.growRoot(i + 1, j, k - 1, 0.8375, rootSlope);
        this.growRoot(i + 2, j, k, 0.9125, rootSlope);
        this.growRoot(i + 2, j, k + 1, 0.0875, rootSlope);
        this.growRoot(i + 1, j, k + 2, 0.1625, rootSlope);
        this.growRoot(i, j, k + 2, 0.3375, rootSlope);
        this.growRoot(i - 1, j, k + 1, 0.4125, rootSlope);
        this.growRoot(i - 1, j, k, 0.5875, rootSlope);
        if (hatBase == 4) {
            for (n = 0; n < l; ++n) {
                this.setBlockAndMetadata(i, j + n, k - 1, this.wood);
                this.setBlockAndMetadata(i + 1, j + n, k - 1, this.wood);
                this.setBlockAndMetadata(i + 2, j + n, k, this.wood);
                this.setBlockAndMetadata(i + 2, j + n, k + 1, this.wood);
                this.setBlockAndMetadata(i + 1, j + n, k + 2, this.wood);
                this.setBlockAndMetadata(i, j + n, k + 2, this.wood);
                this.setBlockAndMetadata(i - 1, j + n, k + 1, this.wood);
                this.setBlockAndMetadata(i - 1, j + n, k, this.wood);
            }
        } else if (hatBase == 5) {
            for (n = 0; n < l - 1; ++n) {
                this.setBlockAndMetadata(i + 2, j + n, k - 1, this.wood);
                this.setBlockAndMetadata(i + 2, j + n, k, this.wood);
                this.setBlockAndMetadata(i + 2, j + n, k + 1, this.wood);
                this.setBlockAndMetadata(i - 2, j + n, k - 1, this.wood);
                this.setBlockAndMetadata(i - 2, j + n, k, this.wood);
                this.setBlockAndMetadata(i - 2, j + n, k + 1, this.wood);
                this.setBlockAndMetadata(i - 1, j + n, k + 2, this.wood);
                this.setBlockAndMetadata(i, j + n, k + 2, this.wood);
                this.setBlockAndMetadata(i + 1, j + n, k + 2, this.wood);
                this.setBlockAndMetadata(i - 1, j + n, k - 2, this.wood);
                this.setBlockAndMetadata(i, j + n, k - 2, this.wood);
                this.setBlockAndMetadata(i + 1, j + n, k - 2, this.wood);
            }
        } else if (hatBase == 7) {
            for (n = 0; n < l - 2; ++n) {
                this.setBlockAndMetadata(i + 3, j + n, k - 1, this.leaf);
                this.setBlockAndMetadata(i + 3, j + n, k, this.leaf);
                this.setBlockAndMetadata(i + 3, j + n, k + 1, this.leaf);
                this.setBlockAndMetadata(i - 3, j + n, k - 1, this.leaf);
                this.setBlockAndMetadata(i - 3, j + n, k, this.leaf);
                this.setBlockAndMetadata(i - 3, j + n, k + 1, this.leaf);
                this.setBlockAndMetadata(i - 1, j + n, k + 3, this.leaf);
                this.setBlockAndMetadata(i, j + n, k + 3, this.leaf);
                this.setBlockAndMetadata(i + 1, j + n, k + 3, this.leaf);
                this.setBlockAndMetadata(i - 1, j + n, k - 3, this.leaf);
                this.setBlockAndMetadata(i, j + n, k - 3, this.leaf);
                this.setBlockAndMetadata(i + 1, j + n, k - 3, this.leaf);
                this.setBlockAndMetadata(i + 2, j + n, k + 2, this.leaf);
                this.setBlockAndMetadata(i + 2, j + n, k - 2, this.leaf);
                this.setBlockAndMetadata(i - 2, j + n, k + 2, this.leaf);
                this.setBlockAndMetadata(i - 2, j + n, k - 2, this.leaf);
            }
        }
        for (n = 0; n < l; ++n) {
            this.growBranch(i, j + n, k, (double)(l - n) * 0.8, dir, 0.0, pbias, 0.0, 1);
            this.growBranch(i, j + n, k, (double)(l - n) * 0.8, dir + Math.PI, 0.0, pbias, 0.0, 1);
            dir += spin;
            pbias = (pbias - 1.5707963267948966) * 0.9 + 1.5707963267948966;
        }
        for (n = 0; n < l - 1; ++n) {
            this.setBlockAndMetadata(i, j + n, k, new BlockAndMeta(Blocks.field_150350_a));
            this.setBlockAndMetadata(i + 1, j + n, k, new BlockAndMeta(Blocks.field_150350_a));
            this.setBlockAndMetadata(i + 1, j + n, k + 1, new BlockAndMeta(Blocks.field_150350_a));
            this.setBlockAndMetadata(i, j + n, k + 1, new BlockAndMeta(Blocks.field_150350_a));
        }
        if (hatBase >= 5) {
            for (n = 0; n < l - 2; ++n) {
                this.setBlockAndMetadata(i - 1, j + n, k + 1, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i - 1, j + n, k, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i - 1, j + n, k - 1, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i, j + n, k - 1, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i + 1, j + n, k - 1, new BlockAndMeta(Blocks.field_150350_a));
            }
        }
        if (hatBase == 7) {
            for (n = 0; n < l - 3; ++n) {
                this.setBlockAndMetadata(i - 2, j + n, k - 1, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i - 2, j + n, k, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i - 2, j + n, k + 1, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i + 2, j + n, k - 1, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i + 2, j + n, k, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i + 2, j + n, k + 1, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i - 1, j + n, k - 2, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i, j + n, k - 2, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i + 1, j + n, k - 2, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i - 1, j + n, k + 2, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i, j + n, k + 2, new BlockAndMeta(Blocks.field_150350_a));
                this.setBlockAndMetadata(i + 1, j + n, k + 2, new BlockAndMeta(Blocks.field_150350_a));
            }
        }
        return true;
    }

    private void growBulk(int i, int j, int k, double l, double dir, double pitch, double pbias, double pbias2, double grow) {
        double y = 0.0;
        double shrink = 0.9416;
        this.growBranch(i + 1, j + (int)y, k, l, dir + 0.0, pitch, pbias, pbias2, 0);
        this.growBranch(i + 1, j + (int)(y += (grow /= 8.0)), k + 1, l *= shrink, dir + 0.7853981633974483, pitch, pbias, pbias2, 0);
        this.growBranch(i, j + (int)(y += grow), k + 1, l *= shrink, dir + 1.5707963267948966, pitch, pbias, pbias2, 0);
        this.growBranch(i - 1, j + (int)(y += grow), k + 1, l *= shrink, dir + 2.356194490192345, pitch, pbias, pbias2, 0);
        this.growBranch(i - 1, j + (int)(y += grow), k, l *= shrink, dir + Math.PI, pitch, pbias, pbias2, 0);
        this.growBranch(i - 1, j + (int)(y += grow), k - 1, l *= shrink, dir + 3.9269908169872414, pitch, pbias, pbias2, 0);
        this.growBranch(i, j + (int)(y += grow), k - 1, l *= shrink, dir + 4.71238898038469, pitch, pbias, pbias2, 0);
        this.growBranch(i + 1, j + (int)(y += grow), k - 1, l *= shrink, dir + 5.497787143782138, pitch, pbias, pbias2, 0);
    }

    private void growBranch(int i, int j, int k, double len, double dir, double pitch, double pbias, double pbias2, int size) {
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        double spin = 0.0;
        double heave = 0.0;
        double blen = len * 0.75;
        this.plotWood(i, j, k, size);
        while (len > 1.0) {
            dy += Math.sin(pitch);
            double dd = Math.cos(pitch);
            dx += Math.cos(dir) * dd;
            dz += Math.sin(dir) * dd;
            boolean step = false;
            if (dx >= 1.0) {
                ++i;
                dx -= 1.0;
                step = true;
            } else if (dx <= -1.0) {
                --i;
                dx += 1.0;
                step = true;
            }
            if (dy >= 1.0) {
                ++j;
                dy -= 1.0;
                step = true;
            } else if (dy <= -1.0) {
                --j;
                dy += 1.0;
                step = true;
            }
            if (dz >= 1.0) {
                ++k;
                dz -= 1.0;
                step = true;
            } else if (dz <= -1.0) {
                --k;
                dz += 1.0;
                step = true;
            }
            if (step) {
                BlockAndMeta id = this.getBlock(i, j, k);
                if (!id.isAir() && !id.areEqual(new BlockAndMeta[]{this.wood, this.leaf})) break;
                this.plotWood(i, j, k, size);
            }
            heave += (double)this.rand.nextFloat() * 0.1 - 0.05;
            dir += (spin += (double)this.rand.nextFloat() * 0.1 - 0.05);
            heave = pitch > pbias ? (heave -= 0.01) : (heave += 0.01);
            if (heave > 0.2) {
                heave = 0.2;
            }
            if (heave < -0.2) {
                heave = -0.2;
            }
            pitch += heave;
            pitch = (pitch - pbias2) * 0.8 + pbias2;
            len -= 1.0;
        }
        this.treeLeaf(i, j, k, 3);
    }

    private void plotWood(int i, int j, int k, int size) {
        this.setBlockAndMetadata(i, j, k, this.wood);
        if (size <= 1) {
            this.setBlockAndMetadata(i + 1, j, k, this.wood);
            this.setBlockAndMetadata(i + 1, j, k + 1, this.wood);
            this.setBlockAndMetadata(i, j, k + 1, this.wood);
            if (size == 0) {
                this.setBlockAndMetadata(i, j + 1, k, this.wood);
                this.setBlockAndMetadata(i + 1, j + 1, k, this.wood);
                this.setBlockAndMetadata(i + 1, j + 1, k + 1, this.wood);
                this.setBlockAndMetadata(i, j + 1, k + 1, this.wood);
            }
        }
    }

    private void treeLeaf(int i, int j, int k, int r) {
        if (r <= 0) {
            return;
        }
        int rr = r * r + 1;
        int rrr = (r - 1) * (r - 1);
        for (int ii = 0; ii <= r; ++ii) {
            for (int jj = -r / 2; jj <= r; ++jj) {
                for (int kk = 0; kk <= r; ++kk) {
                    int zz = ii * ii + jj * jj + kk * kk;
                    if (zz > rr) continue;
                    boolean flag = zz >= rrr;
                    this.treeLeafSpot(i + ii, j + jj, k + kk, flag);
                    this.treeLeafSpot(i + ii, j + jj, k - kk, flag);
                    this.treeLeafSpot(i - ii, j + jj, k + kk, flag);
                    this.treeLeafSpot(i - ii, j + jj, k - kk, flag);
                }
            }
        }
        for (int n = -r; n <= r; ++n) {
            if (this.getBlock(i + r, j, k).areEqual(this.leaf)) {
                this.plotVine(i + r, j, k, 1);
                this.plotVine(i + r, j, k, 4);
            }
            if (!this.getBlock(i, j, k + r).areEqual(this.leaf)) continue;
            this.plotVine(i, j, k + r, 2);
            this.plotVine(i, j, k + r, 8);
        }
    }

    private void treeLeafSpot(int i, int j, int k, boolean flag) {
        if (this.getBlock(i, j, k).isAir()) {
            this.setBlockAndMetadata(i, j, k, this.leaf);
        }
    }

    private void plotVine(int i, int j, int k, int l) {
        int kk;
        int ii;
        if (l == 2) {
            ii = 1;
            kk = 0;
        } else if (l == 1) {
            ii = 0;
            kk = -1;
        } else if (l == 4) {
            ii = 0;
            kk = 1;
        } else {
            ii = -1;
            kk = 0;
            l = 8;
        }
        BlockAndMeta id = this.getBlock(i + ii, j, k + kk);
        for (int n = 0; n < 4 && id.areEqual(this.leaf); ++n) {
            id = this.getBlock((i += ii) + ii, j, (k += kk) + kk);
        }
        if (!id.isAir()) {
            return;
        }
        this.setBlockAndMetadataWithNotify(i, j, k, new BlockAndMeta(Blocks.field_150395_bd, l));
        for (int i1 = 20; this.getBlock(i, --j, k).isAir() && i1 > 0; --i1) {
            this.setBlockAndMetadataWithNotify(i, j, k, new BlockAndMeta(Blocks.field_150395_bd, l));
        }
    }

    @Override
    void growRoot(int l, int m, int n, double theta, double phi) {
        if (!KTreeCfg.rootsEnable) {
            return;
        }
        if (this.rootAlt == 1) {
            this.rootRand = this.rand.nextInt(2);
            m -= this.rootRand;
            this.rootAlt = 2;
        } else if (this.rootAlt == 2) {
            if (this.rootRand == 0) {
                --m;
            }
            this.rootAlt = 0;
        } else if (this.rootAlt == 10) {
            m -= this.rand.nextInt(2);
        }
        ++m;
        double direction = Math.PI * 2 * (theta += (double)this.rand.nextFloat() * 0.1 - 0.05);
        double curl = this.rand.nextFloat() * 0.4f - 0.2f;
        double pitch = Math.PI * 2 * (phi -= (double)this.rand.nextFloat() * 0.05);
        int length = 14 + this.rand.nextInt(2);
        double x = l > 0 ? (double)l + 0.5 : (double)l - 0.5;
        double y = (double)m + 0.5;
        double z = n > 0 ? (double)n + 0.5 : (double)n - 0.5;
        int i = (int)x;
        int j = (int)y;
        int k = (int)z;
        int med = this.getMedium(i, j, k);
        int cnt = 0;
        while ((double)length > 0.0) {
            --length;
            curl = curl + (double)(this.rand.nextFloat() * 0.06f) - (double)0.03f;
            pitch = med == 1 ? (pitch + 1.5707963267948966) * 0.7 - 1.5707963267948966 : (pitch + 1.5707963267948966) * 0.9 - 1.5707963267948966;
            double hoz = Math.cos(pitch);
            double x2 = x + Math.cos(direction) * hoz;
            double y2 = y + Math.sin(pitch);
            double z2 = z + Math.sin(direction) * hoz;
            int i2 = (int)x2;
            int j2 = (int)y2;
            int k2 = (int)z2;
            if (i2 == i && j2 == j && k2 == k) continue;
            this.setBlockAndMetadata(i, j, k, this.wood);
            if (++cnt < 4 && (j2 != j - 1 || i2 != i || k2 != k)) {
                this.setBlockAndMetadata(i, j - 1, k, this.wood);
            }
            if ((med = this.getMedium(i2, j2, k2)) != 0) {
                x = x2;
                y = y2;
                z = z2;
                i = i2;
                j = j2;
                k = k2;
                continue;
            }
            med = this.getMedium(i, j - 1, k);
            if (med != 0) {
                y -= 1.0;
                --j;
                pitch = -1.5707963267948966;
                continue;
            }
            x2 = x + Math.cos(direction);
            i2 = (int)x2;
            med = this.getMedium(i2, j, k2 = (int)(z2 = z + Math.sin(direction)));
            if (med != 0) {
                x = x2;
                z = z2;
                i = i2;
                k = k2;
                pitch = 0.0;
                continue;
            }
            int dir = (int)(direction * 8.0 / Math.PI);
            dir = dir < 0 ? 15 - (15 - dir) % 16 : (dir %= 16);
            int pol = dir % 2;
            int di = i2 - i;
            int dk = k2 - k;
            int[] tdir = new int[]{0, 0, 0, 0};
            if (di == 0 && dk == 0) {
                if (dir < 1) {
                    di = 1;
                    dk = 0;
                } else if (dir < 3) {
                    di = 1;
                    dk = 1;
                } else if (dir < 5) {
                    di = 0;
                    dk = 1;
                } else if (dir < 7) {
                    di = -1;
                    dk = 1;
                } else if (dir < 9) {
                    di = -1;
                    dk = 0;
                } else if (dir < 11) {
                    di = -1;
                    dk = -1;
                } else if (dir < 13) {
                    di = 0;
                    dk = -1;
                } else if (dir < 15) {
                    di = 1;
                    dk = -1;
                } else {
                    di = 1;
                    dk = 0;
                }
            }
            if (dk == 0) {
                if (di > 0) {
                    if (pol == 1) {
                        tdir[0] = 2;
                        tdir[1] = 14;
                        tdir[2] = 4;
                        tdir[3] = 12;
                    } else {
                        tdir[0] = 14;
                        tdir[1] = 2;
                        tdir[2] = 12;
                        tdir[3] = 4;
                    }
                } else if (pol == 1) {
                    tdir[0] = 6;
                    tdir[1] = 10;
                    tdir[2] = 4;
                    tdir[3] = 12;
                } else {
                    tdir[0] = 10;
                    tdir[1] = 6;
                    tdir[2] = 12;
                    tdir[3] = 4;
                }
            } else if (di == 0) {
                if (dk > 0) {
                    if (pol == 1) {
                        tdir[0] = 2;
                        tdir[1] = 6;
                        tdir[2] = 0;
                        tdir[3] = 8;
                    } else {
                        tdir[0] = 6;
                        tdir[1] = 2;
                        tdir[2] = 8;
                        tdir[3] = 0;
                    }
                } else if (pol == 1) {
                    tdir[0] = 10;
                    tdir[1] = 14;
                    tdir[2] = 8;
                    tdir[3] = 0;
                } else {
                    tdir[0] = 14;
                    tdir[1] = 10;
                    tdir[2] = 0;
                    tdir[3] = 8;
                }
            } else if (dk > 0) {
                if (di > 0) {
                    if (pol == 1) {
                        tdir[0] = 0;
                        tdir[1] = 4;
                        tdir[2] = 14;
                        tdir[3] = 6;
                    } else {
                        tdir[0] = 4;
                        tdir[1] = 0;
                        tdir[2] = 6;
                        tdir[3] = 14;
                    }
                } else if (pol == 1) {
                    tdir[0] = 4;
                    tdir[1] = 8;
                    tdir[2] = 2;
                    tdir[3] = 10;
                } else {
                    tdir[0] = 8;
                    tdir[1] = 4;
                    tdir[2] = 10;
                    tdir[3] = 2;
                }
            } else if (di > 0) {
                if (pol == 1) {
                    tdir[0] = 12;
                    tdir[1] = 0;
                    tdir[2] = 10;
                    tdir[3] = 2;
                } else {
                    tdir[0] = 0;
                    tdir[1] = 12;
                    tdir[2] = 2;
                    tdir[3] = 10;
                }
            } else if (pol == 1) {
                tdir[0] = 8;
                tdir[1] = 12;
                tdir[2] = 6;
                tdir[3] = 14;
            } else {
                tdir[0] = 12;
                tdir[1] = 8;
                tdir[2] = 14;
                tdir[3] = 6;
            }
            for (int q = 0; q < 4; ++q) {
                if (tdir[q] == 0) {
                    di = 1;
                    dk = 0;
                } else if (tdir[q] == 2) {
                    di = 1;
                    dk = 1;
                } else if (tdir[q] == 4) {
                    di = 0;
                    dk = 1;
                } else if (tdir[q] == 6) {
                    di = -1;
                    dk = 1;
                } else if (tdir[q] == 8) {
                    di = -1;
                    dk = 0;
                } else if (tdir[q] == 10) {
                    di = -1;
                    dk = -1;
                } else if (tdir[q] == 12) {
                    di = 0;
                    dk = -1;
                } else {
                    di = 1;
                    dk = -1;
                }
                i2 = i + di;
                k2 = k + dk;
                med = this.getMedium(i2, j, k2);
                if (med == 0) continue;
                i = i2;
                k = k2;
                x = (double)i + 0.5;
                z = (double)k + 0.5;
                pitch = 0.0;
                direction = (double)tdir[q] * 2.0 * Math.PI / 16.0;
                break;
            }
            if (med != 0) continue;
            return;
        }
    }
}

