/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees.generators;

import java.util.Random;
import karob.bigtrees.KTreeCfg;
import karob.bigtrees.compat.WorldWrapper;
import karob.bigtrees.config.BlockAndMeta;
import karob.bigtrees.config.ITreeConfigurable;
import karob.bigtrees.generators.AbstractWorldGenerator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;

public class KWorldGenBigTree
extends AbstractWorldGenerator
implements ITreeConfigurable {
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    int tapRootRand;
    int[] basePos = new int[]{0, 0, 0};
    int heightLimit;
    int height;
    double heightAttenuation;
    double branchDensity;
    double branchSlope;
    double scaleWidth;
    double leafDensity;
    int trunkSize;
    int heightLimitLimit;
    int leafDistanceLimit;
    int[][] leafNodes;

    public KWorldGenBigTree(boolean doBlockNotify) {
        super(doBlockNotify);
        this.rand = new Random();
        this.rootRand = 0;
        this.rootAlt = 0;
        this.tapRootRand = 0;
        this.heightLimit = 0;
        this.heightAttenuation = 0.318;
        this.branchDensity = 1.0;
        this.branchSlope = 0.618;
        this.scaleWidth = 1.0;
        this.leafDensity = 1.0;
        this.trunkSize = 1;
        this.heightLimitLimit = 12;
        this.leafDistanceLimit = 4;
    }

    private boolean generateLeafNodeList() {
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if (this.basePos[1] + this.heightLimit > 252) {
            this.height /= 2;
            this.heightLimit /= 2;
            if (this.height >= this.heightLimit) {
                this.height = this.heightLimit - 1;
            }
            if (this.height < 1) {
                return false;
            }
            if (this.basePos[1] + this.heightLimit > 252) {
                return false;
            }
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int[][] ai = new int[i * this.heightLimit][4];
        int j = this.basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int k = 1;
        int l = this.basePos[1] + this.height;
        int i1 = j - this.basePos[1];
        ai[0][0] = this.basePos[0];
        ai[0][1] = j--;
        ai[0][2] = this.basePos[2];
        ai[0][3] = l;
        while (i1 >= 0) {
            int j1 = 0;
            float f = this.layerSize(i1);
            if (k >= i * this.heightLimit) {
                f = -1.0f;
            }
            if (f < 0.0f) {
                --j;
                --i1;
                continue;
            }
            double d0 = 0.5;
            while (j1 < i) {
                int[] ai2;
                int l1;
                double d2;
                double d1 = this.scaleWidth * ((double)f * ((double)this.rand.nextFloat() + 0.328));
                int k1 = MathHelper.func_76128_c((double)(d1 * Math.sin(d2 = (double)this.rand.nextFloat() * 2.0 * Math.PI) + (double)this.basePos[0] + d0));
                int[] ai1 = new int[]{k1, j, l1 = MathHelper.func_76128_c((double)(d1 * Math.cos(d2) + (double)this.basePos[2] + d0))};
                if (this.checkBlockLine(ai1, ai2 = new int[]{k1, j + this.leafDistanceLimit, l1}) == -1) {
                    int[] ai3 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                    double d3 = Math.sqrt(Math.pow(Math.abs(this.basePos[0] - ai1[0]), 2.0) + Math.pow(Math.abs(this.basePos[2] - ai1[2]), 2.0));
                    double d4 = d3 * this.branchSlope;
                    ai3[1] = (double)ai1[1] - d4 > (double)l ? l : (int)((double)ai1[1] - d4);
                    if (this.checkBlockLine(ai3, ai1) == -1) {
                        ai[k][0] = k1;
                        ai[k][1] = j;
                        ai[k][2] = l1;
                        ai[k][3] = ai3[1];
                        ++k;
                    }
                }
                ++j1;
            }
            --j;
            --i1;
        }
        this.leafNodes = new int[k][4];
        System.arraycopy(ai, 0, this.leafNodes, 0, k);
        return true;
    }

    void func_523_a(int i, int j, int k, float f, byte byte0) {
        int i1 = (int)((double)f + 0.618);
        byte byte1 = otherCoordPairs[byte0];
        byte byte2 = otherCoordPairs[byte0 + 3];
        int[] ai = new int[]{i, j, k};
        int[] ai1 = new int[]{0, 0, 0};
        int k1 = -i1;
        ai1[byte0] = ai[byte0];
        for (int j1 = -i1; j1 <= i1; ++j1) {
            ai1[byte1] = ai[byte1] + j1;
            int l1 = -i1;
            while (l1 <= i1) {
                double d = Math.sqrt(Math.pow((double)Math.abs(j1) + 0.5, 2.0) + Math.pow((double)Math.abs(l1) + 0.5, 2.0));
                if (d > (double)f) {
                    ++l1;
                    continue;
                }
                ai1[byte2] = ai[byte2] + l1;
                BlockAndMeta i2 = this.getBlock(ai1[0], ai1[1], ai1[2]);
                if (!i2.areEqual(new Block[]{Blocks.field_150350_a, Blocks.field_150362_t})) {
                    ++l1;
                    continue;
                }
                this.setBlockAndMetadata(ai1[0], ai1[1], ai1[2], this.leaf);
                ++l1;
            }
        }
    }

    float layerSize(int i) {
        if (this.trunkSize == 0) {
            return (float)this.heightLimit - this.rand.nextFloat();
        }
        if (this.trunkSize != 3 && this.trunkSize > 1 && this.rand.nextFloat() > 0.7f) {
            return -1.618f;
        }
        if (this.trunkSize == 3 && (double)i < (double)this.heightLimit * 0.19999999999999998) {
            return -1.618f;
        }
        if (this.trunkSize < 3 && (double)i < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        if (this.trunkSize == 4 && (double)i < (double)this.heightLimit * 0.16) {
            return -1.618f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = (float)this.heightLimit / 2.0f - (float)i;
        float f2 = f1 == 0.0f ? f : (Math.abs(f1) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f1), 2.0)));
        return f2 *= 0.5f;
    }

    float leafSize(int i) {
        if (i < 0 || i >= this.leafDistanceLimit) {
            return -1.0f;
        }
        return i != 0 && i != this.leafDistanceLimit - 1 ? 3.0f : 2.0f;
    }

    void generateLeafNode(int i, int j, int k) {
        int i1 = j + this.leafDistanceLimit;
        for (int l = j; l < i1; ++l) {
            float f = this.leafSize(l - j);
            this.func_523_a(i, l, k, f, (byte)1);
        }
    }

    void placeBlockLine(int[] ai, int[] ai1) {
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.setBlockAndMetadata(ai3[0], ai3[1], ai3[2], this.wood);
        }
    }

    void generateLeaves() {
        int j = this.leafNodes.length;
        for (int i = 0; i < j; ++i) {
            int k = this.leafNodes[i][0];
            int l = this.leafNodes[i][1];
            int i1 = this.leafNodes[i][2];
            this.generateLeafNode(k, l, i1);
        }
    }

    boolean leafNodeNeedsBase(int i) {
        if (this.trunkSize != 2) {
            return true;
        }
        return (double)i >= (double)this.heightLimit * 0.2;
    }

    void generateTrunk() {
        int i = this.basePos[0];
        int j = this.basePos[1];
        int k = this.basePos[1] + this.height + 2;
        int l = this.basePos[2];
        int[] ai = new int[]{i, j, l};
        int[] ai1 = new int[]{i, k, l};
        if (this.trunkSize == 1) {
            this.placeBlockLine(ai, ai1);
        }
        if (this.trunkSize == 2) {
            this.rootAlt = 0;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1] - 2, ai[2], 0.625, -0.0625);
            this.rootAlt = 1;
            this.growRoot(ai[0], ai[1], ai[2], 0.7125, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1], ai[2], 0.7875, -0.0625);
            this.growRoot(ai[0], ai[1] - 2, ai[2], 0.875, -0.0625);
            this.rootAlt = 1;
            this.growRoot(ai[0], ai[1], ai[2], 0.9625, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1], ai[2], 0.0375, -0.0625);
            this.growRoot(ai[0], ai[1] - 2, ai[2], 0.125, -0.0625);
            this.rootAlt = 1;
            this.growRoot(ai[0], ai[1], ai[2], 0.2125, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1], ai[2], 0.2875, -0.0625);
            this.growRoot(ai[0], ai[1] - 2, ai[2], 0.375, -0.0625);
            this.rootAlt = 1;
            this.growRoot(ai[0], ai[1], ai[2], 0.4625, -0.0625);
            this.placeBlockLine(ai, ai1);
            this.growRoot(ai[0], ai[1], ai[2] - 1, 0.5375, -0.0625);
        }
        if (this.trunkSize == 3) {
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.placeBlockLine(ai, ai1);
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.placeBlockLine(ai, ai1);
            ai[2] = ai[2] - 1;
            ai1[2] = ai1[2] - 1;
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.placeBlockLine(ai, ai1);
            ai[2] = ai[2] - 1;
            ai1[2] = ai1[2] - 1;
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.placeBlockLine(ai, ai1);
        }
        if (this.trunkSize == 4) {
            this.rootAlt = 10;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.625, -0.0625);
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.875, -0.0625);
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.125, -0.0625);
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.375, -0.0625);
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            ai[2] = ai[2] - 1;
            ai1[2] = ai1[2] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.55, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            ai[2] = ai[2] - 1;
            ai1[2] = ai1[2] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.7, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.8, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.95, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.05, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.2, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.3, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            ai[2] = ai[2] - 1;
            ai1[2] = ai1[2] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.45, -0.0625);
            this.placeBlockLine(ai, ai1);
        }
    }

    void growTapRoot(int i, int j, int k, double flen) {
        int jj;
        if (!KTreeCfg.rootsEnable) {
            return;
        }
        int len = (int)((6.0 + (double)this.rand.nextFloat() * 6.0) * flen);
        if (len == this.tapRootRand || len == this.tapRootRand + 1 || len == this.tapRootRand - 1) {
            len = (int)((6.0 + (double)this.rand.nextFloat() * 6.0) * flen);
        }
        for (jj = 1; jj <= len; ++jj) {
            int med = this.getMedium(i, j - jj, k);
            if (med == 1) {
                --len;
                continue;
            }
            if (med != 0) continue;
            len = Math.min(len, jj - 1);
            break;
        }
        this.tapRootRand = len;
        for (jj = 1; jj <= len; ++jj) {
            this.setBlockAndMetadata(i, j - jj, k, this.wood);
        }
    }

    void generateLeafNodeBases() {
        int j = this.leafNodes.length;
        int[] ai = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int i = 0; i < j; ++i) {
            int[] ai1 = this.leafNodes[i];
            int[] ai2 = new int[]{ai1[0], ai1[1], ai1[2]};
            ai[1] = ai1[3];
            int k = ai[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(k)) continue;
            this.placeBlockLine(ai, ai2);
        }
    }

    int checkBlockLine(int[] ai, int[] ai1) {
        int j;
        int[] ai2 = new int[]{0, 0, 0};
        int i = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[i])) continue;
            i = byte0;
        }
        if (ai2[i] == 0) {
            return -1;
        }
        byte byte1 = otherCoordPairs[i];
        byte byte2 = otherCoordPairs[i + 3];
        int byte3 = ai2[i] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[i];
        double d1 = (double)ai2[byte2] / (double)ai2[i];
        int[] ai3 = new int[]{0, 0, 0};
        int k = ai2[i] + byte3;
        for (j = 0; j != k; j += byte3) {
            ai3[i] = ai[i] + j;
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)j * d));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)j * d1));
            BlockAndMeta l = this.getBlock(ai3[0], ai3[1], ai3[2]);
            if (!l.isAir() && !l.areEqual(new BlockAndMeta[]{this.wood, this.leaf})) break;
        }
        if (j == k) {
            return -1;
        }
        return Math.abs(j);
    }

    boolean validTreeLocation() {
        return this.isSupportedBaseBlock(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
    }

    public void func_517_a(double d, double d1, double d2) {
        this.heightLimitLimit = (int)(d * 12.0);
    }

    @Override
    public boolean generate(WorldWrapper world, Random random, int x, int y, int z) {
        this.worldObject = world;
        long l = random.nextLong();
        this.rand.setSeed(l);
        this.basePos[0] = x;
        this.basePos[1] = y;
        this.basePos[2] = z;
        if (!this.validTreeLocation()) {
            this.worldObject = null;
            return false;
        }
        int[] heightvector = new int[]{this.heightmin, this.heightmax - this.heightmin};
        this.heightLimit = KTreeCfg.vary(this.rand, heightvector);
        this.rootRand = this.rand.nextInt(4);
        if (this.generateLeafNodeList()) {
            this.generateLeaves();
            this.generateTrunk();
            this.generateLeafNodeBases();
            this.worldObject = null;
            return true;
        }
        this.worldObject = null;
        return false;
    }
}

