/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees.generators;

import java.util.List;
import java.util.Random;
import karob.bigtrees.KTreeCfg;
import karob.bigtrees.compat.BlockPos;
import karob.bigtrees.compat.IWorldGenerator;
import karob.bigtrees.compat.WorldWrapper;
import karob.bigtrees.config.BlockAndMeta;
import karob.bigtrees.config.ITreeConfigurable;
import karob.bigtrees.config.TreeConfiguration;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class AbstractWorldGenerator
extends WorldGenerator
implements IWorldGenerator,
ITreeConfigurable {
    protected WorldWrapper worldObject;
    protected List<BlockAndMeta> baseblocks;
    protected BlockAndMeta leaf;
    protected BlockAndMeta wood;
    protected int rootRand;
    protected int rootAlt;
    protected Random rand;
    protected int trunkSize;
    protected int stuntmin;
    protected int heightmin;
    protected int heightmax;

    protected AbstractWorldGenerator(boolean doBlockNotify) {
        super(doBlockNotify);
    }

    @Override
    public void setTreeConfiguration(TreeConfiguration treeConfiguration) {
        this.wood = treeConfiguration.getWood();
        this.leaf = treeConfiguration.getLeaf();
        this.baseblocks = treeConfiguration.getBaseBlocks();
        this.heightmin = treeConfiguration.getMinHeight();
        this.heightmax = treeConfiguration.getMaxHeight();
        this.stuntmin = treeConfiguration.getMinStunt();
    }

    protected void setBlock(BlockPos pos, BlockAndMeta block) {
        try {
            this.worldObject.setBlock(pos, block, WorldWrapper.BlockFlags.BlockUpdate, WorldWrapper.BlockFlags.SendToClient);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected void setBlock(int x, int y, int z, BlockAndMeta block) {
        this.setBlock(new BlockPos(x, y, z), block);
    }

    protected void setBlockAndMetadataWithNotify(BlockPos pos, BlockAndMeta block) {
        this.setBlock(pos, block);
    }

    protected void setBlockAndMetadataWithNotify(int x, int y, int z, BlockAndMeta blockAndMeta) {
        this.setBlockAndMetadataWithNotify(new BlockPos(x, y, z), blockAndMeta);
    }

    protected BlockAndMeta getBlock(BlockPos pos) {
        try {
            return this.worldObject.getBlock(pos);
        }
        catch (RuntimeException e) {
            return new BlockAndMeta(Blocks.field_150357_h);
        }
    }

    protected boolean setToAir(BlockPos pos) {
        try {
            return this.worldObject.setToAir(pos);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    protected boolean isSupportedBaseBlock(int x, int y, int z) {
        return this.isSupportedBaseBlock(new BlockPos(x, y, z));
    }

    protected boolean isSupportedBaseBlock(BlockPos pos) {
        BlockAndMeta block = this.getBlock(pos);
        for (BlockAndMeta possibleBaseBlock : this.baseblocks) {
            if (!possibleBaseBlock.areEqual(block)) continue;
            return true;
        }
        return false;
    }

    protected int getMedium(int i, int j, int k) {
        int m;
        Block[] canGrowOpen = new Block[]{Blocks.field_150350_a, Blocks.field_150345_g, Blocks.field_150358_i, Blocks.field_150355_j, Blocks.field_150356_k, Blocks.field_150353_l, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150362_t, Blocks.field_150361_u};
        Block[] canGrowSolid = new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n};
        BlockPos pos = new BlockPos(i, j, k);
        BlockAndMeta qq = this.getBlock(pos);
        int medium = 0;
        for (m = 0; m < canGrowOpen.length; ++m) {
            if (qq.getBlock() != canGrowOpen[m]) continue;
            medium = 1;
            break;
        }
        if (medium == 0) {
            for (m = 0; m < canGrowSolid.length; ++m) {
                if (qq.getBlock() != canGrowSolid[m]) continue;
                medium = 2;
                break;
            }
        }
        return medium;
    }

    protected BlockAndMeta getBlock(int i, int j, int k) {
        return this.getBlock(new BlockPos(i, j, k));
    }

    protected void setBlockAndMetadata(int i, int j, int k, BlockAndMeta block) {
        this.setBlock(new BlockPos(i, j, k), block);
    }

    void growRoot(int l, int m, int n, double theta, double phi) {
        if (!KTreeCfg.rootsEnable) {
            return;
        }
        if (this.rootAlt == 1) {
            this.rootRand = this.rand.nextInt(2);
            m -= this.rootRand;
            this.rootAlt = 2;
        } else if (this.rootAlt == 2) {
            if (this.rootRand == 0) {
                --m;
            }
            this.rootAlt = 0;
        } else if (this.rootAlt == 10) {
            m -= this.rand.nextInt(2);
        }
        ++m;
        double direction = Math.PI * 2 * (theta += (double)this.rand.nextFloat() * 0.1 - 0.05);
        double curl = this.rand.nextFloat() * 0.4f - 0.2f;
        double pitch = Math.PI * 2 * (phi -= (double)this.rand.nextFloat() * 0.05);
        int length = 2 + 3 * this.trunkSize + this.rand.nextInt(2);
        double x = l > 0 ? (double)l + 0.5 : (double)l - 0.5;
        double y = (double)m + 0.5;
        double z = n > 0 ? (double)n + 0.5 : (double)n - 0.5;
        int i = (int)x;
        int j = (int)y;
        int k = (int)z;
        int med = this.getMedium(i, j, k);
        int cnt = 0;
        while ((double)length > 0.0) {
            --length;
            curl = curl + (double)(this.rand.nextFloat() * 0.06f) - (double)0.03f;
            pitch = med == 1 ? (pitch + 1.5707963267948966) * 0.7 - 1.5707963267948966 : (pitch + 1.5707963267948966) * 0.9 - 1.5707963267948966;
            double hoz = Math.cos(pitch);
            double x2 = x + Math.cos(direction) * hoz;
            double y2 = y + Math.sin(pitch);
            double z2 = z + Math.sin(direction) * hoz;
            int i2 = (int)x2;
            int j2 = (int)y2;
            int k2 = (int)z2;
            if (i2 == i && j2 == j && k2 == k) continue;
            BlockPos pos = new BlockPos(i, j, k);
            this.setBlock(pos, this.wood);
            if (++cnt < 4 && (j2 != j - 1 || i2 != i || k2 != k)) {
                this.setBlock(new BlockPos(i, j - 1, k), this.wood);
            }
            if ((med = this.getMedium(i2, j2, k2)) != 0) {
                x = x2;
                y = y2;
                z = z2;
                i = i2;
                j = j2;
                k = k2;
                continue;
            }
            med = this.getMedium(i, j - 1, k);
            if (med != 0) {
                y -= 1.0;
                --j;
                pitch = -1.5707963267948966;
                continue;
            }
            x2 = x + Math.cos(direction);
            i2 = (int)x2;
            med = this.getMedium(i2, j, k2 = (int)(z2 = z + Math.sin(direction)));
            if (med != 0) {
                x = x2;
                z = z2;
                i = i2;
                k = k2;
                pitch = 0.0;
                continue;
            }
            int dir = (int)(direction * 8.0 / Math.PI);
            dir = dir < 0 ? 15 - (15 - dir) % 16 : (dir %= 16);
            int pol = dir % 2;
            int di = i2 - i;
            int dk = k2 - k;
            int[] tdir = new int[]{0, 0, 0, 0};
            if (di == 0 && dk == 0) {
                if (dir < 1) {
                    di = 1;
                    dk = 0;
                } else if (dir < 3) {
                    di = 1;
                    dk = 1;
                } else if (dir < 5) {
                    di = 0;
                    dk = 1;
                } else if (dir < 7) {
                    di = -1;
                    dk = 1;
                } else if (dir < 9) {
                    di = -1;
                    dk = 0;
                } else if (dir < 11) {
                    di = -1;
                    dk = -1;
                } else if (dir < 13) {
                    di = 0;
                    dk = -1;
                } else if (dir < 15) {
                    di = 1;
                    dk = -1;
                } else {
                    di = 1;
                    dk = 0;
                }
            }
            if (dk == 0) {
                if (di > 0) {
                    if (pol == 1) {
                        tdir[0] = 2;
                        tdir[1] = 14;
                        tdir[2] = 4;
                        tdir[3] = 12;
                    } else {
                        tdir[0] = 14;
                        tdir[1] = 2;
                        tdir[2] = 12;
                        tdir[3] = 4;
                    }
                } else if (pol == 1) {
                    tdir[0] = 6;
                    tdir[1] = 10;
                    tdir[2] = 4;
                    tdir[3] = 12;
                } else {
                    tdir[0] = 10;
                    tdir[1] = 6;
                    tdir[2] = 12;
                    tdir[3] = 4;
                }
            } else if (di == 0) {
                if (dk > 0) {
                    if (pol == 1) {
                        tdir[0] = 2;
                        tdir[1] = 6;
                        tdir[2] = 0;
                        tdir[3] = 8;
                    } else {
                        tdir[0] = 6;
                        tdir[1] = 2;
                        tdir[2] = 8;
                        tdir[3] = 0;
                    }
                } else if (pol == 1) {
                    tdir[0] = 10;
                    tdir[1] = 14;
                    tdir[2] = 8;
                    tdir[3] = 0;
                } else {
                    tdir[0] = 14;
                    tdir[1] = 10;
                    tdir[2] = 0;
                    tdir[3] = 8;
                }
            } else if (dk > 0) {
                if (di > 0) {
                    if (pol == 1) {
                        tdir[0] = 0;
                        tdir[1] = 4;
                        tdir[2] = 14;
                        tdir[3] = 6;
                    } else {
                        tdir[0] = 4;
                        tdir[1] = 0;
                        tdir[2] = 6;
                        tdir[3] = 14;
                    }
                } else if (pol == 1) {
                    tdir[0] = 4;
                    tdir[1] = 8;
                    tdir[2] = 2;
                    tdir[3] = 10;
                } else {
                    tdir[0] = 8;
                    tdir[1] = 4;
                    tdir[2] = 10;
                    tdir[3] = 2;
                }
            } else if (di > 0) {
                if (pol == 1) {
                    tdir[0] = 12;
                    tdir[1] = 0;
                    tdir[2] = 10;
                    tdir[3] = 2;
                } else {
                    tdir[0] = 0;
                    tdir[1] = 12;
                    tdir[2] = 2;
                    tdir[3] = 10;
                }
            } else if (pol == 1) {
                tdir[0] = 8;
                tdir[1] = 12;
                tdir[2] = 6;
                tdir[3] = 14;
            } else {
                tdir[0] = 12;
                tdir[1] = 8;
                tdir[2] = 14;
                tdir[3] = 6;
            }
            for (int q = 0; q < 4; ++q) {
                if (tdir[q] == 0) {
                    di = 1;
                    dk = 0;
                } else if (tdir[q] == 2) {
                    di = 1;
                    dk = 1;
                } else if (tdir[q] == 4) {
                    di = 0;
                    dk = 1;
                } else if (tdir[q] == 6) {
                    di = -1;
                    dk = 1;
                } else if (tdir[q] == 8) {
                    di = -1;
                    dk = 0;
                } else if (tdir[q] == 10) {
                    di = -1;
                    dk = -1;
                } else if (tdir[q] == 12) {
                    di = 0;
                    dk = -1;
                } else {
                    di = 1;
                    dk = -1;
                }
                i2 = i + di;
                k2 = k + dk;
                med = this.getMedium(i2, j, k2);
                if (med == 0) continue;
                i = i2;
                k = k2;
                x = (double)i + 0.5;
                z = (double)k + 0.5;
                pitch = 0.0;
                direction = (double)tdir[q] * 2.0 * Math.PI / 16.0;
                break;
            }
            if (med != 0) continue;
            return;
        }
    }

    public boolean func_76484_a(World p_76484_1_, Random p_76484_2_, int p_76484_3_, int p_76484_4_, int p_76484_5_) {
        return false;
    }

    public abstract boolean generate(WorldWrapper var1, Random var2, int var3, int var4, int var5);

    @Override
    public boolean generate(WorldWrapper world, Random random, BlockPos pos) {
        return this.generate(world, random, pos.getX(), pos.getY(), pos.getZ());
    }
}

