/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees.config;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import karob.bigtrees.config.Algorithm;
import karob.bigtrees.config.BlockAndMeta;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;

public class TreeConfiguration {
    protected Algorithm algorithm;
    protected String name;
    protected int minHeight;
    protected int maxHeight;
    protected BlockAndMeta wood;
    protected BlockAndMeta leaf;
    protected int minStunt = 7;
    protected List<BlockAndMeta> baseBlocks = new ArrayList<BlockAndMeta>();
    protected boolean hasNoiseField;
    protected int minNoiseValue;
    protected int maxNoiseValue;
    protected double minBranchless;
    protected double maxBranchless;
    protected double longestBranchPercentage;
    protected double branchRotation;
    protected double tapLength;
    protected double branchSpace;
    protected double pitch;
    protected double curl;
    protected int leafRadius;
    protected double subBranchDensity;
    protected double subBranchingLength;
    protected int subBranchingSize;
    protected double subBranchAngle;
    protected double subBranchSize;

    public TreeConfiguration() {
        this.baseBlocks.add(new BlockAndMeta((Block)Blocks.field_150349_c));
        this.baseBlocks.add(new BlockAndMeta(Blocks.field_150346_d));
        this.hasNoiseField = true;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getName() {
        return this.name;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public BlockAndMeta getWood() {
        return this.wood;
    }

    public BlockAndMeta getLeaf() {
        return this.leaf;
    }

    public int getMinStunt() {
        return this.minStunt;
    }

    public List<BlockAndMeta> getBaseBlocks() {
        return this.baseBlocks;
    }

    public boolean hasNoiseField() {
        return this.hasNoiseField;
    }

    public int getMinNoiseValue() {
        return this.minNoiseValue;
    }

    public int getMaxNoiseValue() {
        return this.maxNoiseValue;
    }

    public double getMinBranchless() {
        return this.minBranchless;
    }

    public double getMaxBranchless() {
        return this.maxBranchless;
    }

    public double getLongestBranchPercentage() {
        return this.longestBranchPercentage;
    }

    public double getBranchRotation() {
        return this.branchRotation;
    }

    public double getTapLength() {
        return this.tapLength;
    }

    public double getBranchSpace() {
        return this.branchSpace;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getCurl() {
        return this.curl;
    }

    public int getLeafRadius() {
        return this.leafRadius;
    }

    public double getSubBranchDensity() {
        return this.subBranchDensity;
    }

    public double getSubBranchingLength() {
        return this.subBranchingLength;
    }

    public int getSubBranchingSize() {
        return this.subBranchingSize;
    }

    public double getSubBranchAngle() {
        return this.subBranchAngle;
    }

    public double getSubBranchSize() {
        return this.subBranchSize;
    }

    public void readConfig(Configuration config) {
        TreeConfiguration defaults = this;
        this.algorithm = Algorithm.valueOf(config.get("Tree Configuration Settings", "Algorithm", defaults.algorithm == null ? "" : defaults.algorithm.name(), "TallOak, BlockOak, GreatOak, SwampOak, Cyprus, Hat, BigPine, BigBirch, or Dead").getString());
        this.name = config.get("Tree Configuration Settings", "Unique Tree Name", defaults.getName(), "If it's not different from every other defined tree, settings will mix").getString();
        this.minHeight = config.get("Tree Configuration Settings", "Height Min", defaults.getMinHeight(), "Minimum height in blocks").getInt();
        this.maxHeight = config.get("Tree Configuration Settings", "Height Max", defaults.getMaxHeight(), "Maximum height in blocks").getInt();
        String woodName = config.get("Tree Configuration Settings", "Wood Name", this.getBlockString(defaults.getWood()), "Minecraft names are minecraft:log:meta and minecraft:log2:meta. For mod-added names, use modID:name, e.g., BiomesOPlenty:logs1. Meta values: 0-3 for upward facing logs. For wood name log:0=oak, 1=pine, 2=birch, 3=jungle. For log2, 0=acacia, 1=darkoak.").getString();
        this.wood = new BlockAndMeta(woodName);
        String leafName = config.get("Tree Configuration Settings", "Leaf Name", this.getBlockString(defaults.getLeaf()), "Minecraft names are minecraft:leaves:meta and minecraft:leaves2:meta. For mod-added names, use modID:name, e.g., BiomesOPlenty:leaves1. Meta values: 0-3. For leaf name leaves:0=oak, 1=pine, 2=birch, 3=jungle. For leaves2, 0=acacia, 1=darkoak.").getString();
        this.leaf = new BlockAndMeta(leafName);
        this.minStunt = config.get("Tree Configuration Settings", "Stunt Minimum", defaults.getMinStunt(), "Trees are stunted when blocked by overhead obstacles, but no shorter than this value.").getInt();
        String[] baseblockNames = config.get("Tree Configuration Settings", "Base Blocks", this.getBaseBlockNames(defaults.getBaseBlocks()), "block that the tree can grow on").getStringList();
        this.baseBlocks = this.getBlocksFromNames(baseblockNames);
        this.hasNoiseField = config.get("Tree Configuration Settings", "Use noise field", defaults.hasNoiseField(), "Noise field to determine where in biome tree can grow.").getBoolean();
        this.minNoiseValue = config.get("Tree Configuration Settings", "Noise Min Value", defaults.getMinNoiseValue(), "0 to 144").getInt();
        this.maxNoiseValue = config.get("Tree Configuration Settings", "Noise Max Value", defaults.getMaxNoiseValue(), "0 to 144").getInt();
        if (this.algorithm == Algorithm.TallOak) {
            this.minBranchless = Double.parseDouble(config.get("Tree Configuration Settings", "Branchless Min", defaults.minBranchless, "Fraction of tree height which has no branches").getString());
            this.maxBranchless = Double.parseDouble(config.get("Tree Configuration Settings", "Branchless Max", defaults.maxBranchless, "Fraction of tree height which has no branches").getString());
            this.longestBranchPercentage = Double.parseDouble(config.get("Tree Configuration Settings", "Longest Branch Percentage", defaults.longestBranchPercentage, "as a percentage of tree height").getString());
            this.branchRotation = Double.parseDouble(config.get("Tree Configuration Settings", "Branch Rotation", defaults.branchRotation, "1.0 is a full rotation. The default is the golden mean: (sqrt(5)-1)/2").getString());
            this.tapLength = Double.parseDouble(config.get("Tree Configuration Settings", "Tap Root Length", defaults.tapLength, "Tap root length, as a percentage of tree height. Tap roots grow through wood, leaves, air, water, dirt, sand, and gravel.").getString());
            this.branchSpace = Double.parseDouble(config.get("Tree Configuration Settings", "Branch Spacing", defaults.branchSpace, "0 to 1, abstractly defines average spacing between branches").getString());
            this.pitch = Double.parseDouble(config.get("Tree Configuration Settings", "Branch Pitch", defaults.pitch, "Defines the initial growth angle of a branch. 0=horizontal, 1=45 degrees upwards, -1=45 deg down...").getString());
            this.curl = Double.parseDouble(config.get("Tree Configuration Settings", "Branch Curl", defaults.curl, "Defines the curling growth of a branch. Positive makes the branch curve upwards.").getString());
            this.leafRadius = config.get("Tree Configuration Settings", "Leaf Radius", defaults.leafRadius, "0 = no leaves A radius of 1, 2, or 3 grows non-intrusively. (They won't grow through walls and such.) Leaf radii of 4 or greater can grow through walls, though they won't destroy the walls. Leaves too far from wood will decay. Note leaves must have 4 added to their meta value to prevent them from decaying.").getInt();
            this.subBranchDensity = Double.parseDouble(config.get("Tree Configuration Settings", "SubBranch Density", defaults.subBranchDensity, "Density of branching off of branches.").getString());
            this.subBranchingLength = Double.parseDouble(config.get("Tree Configuration Settings", "Sub Branching Length", defaults.subBranchingLength, "Percent length of branch that can grow sub branches.").getString());
            this.subBranchingSize = config.get("Tree Configuration Settings", "Sub Branching Size", defaults.subBranchingSize, "Minimum branch size to grow sub branches, in meters/blocks.").getInt();
            this.subBranchAngle = Double.parseDouble(config.get("Tree Configuration Settings", "Sub Branch Angle", defaults.subBranchAngle, "Angle between branch and sub branches, degrees.").getString());
            this.subBranchSize = Double.parseDouble(config.get("Tree Configuration Settings", "Sub Branch Size", defaults.subBranchSize, "Size of sub branch as a percent of remaining length of parent branch.").getString());
        }
    }

    private String[] getBaseBlockNames(List<BlockAndMeta> baseBlocks) {
        LinkedList<String> result = new LinkedList<String>();
        for (BlockAndMeta block : baseBlocks) {
            result.add(block.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    private String getBlockString(BlockAndMeta blockAndMeta) {
        if (blockAndMeta == null) {
            return "";
        }
        return blockAndMeta.toString();
    }

    private List<BlockAndMeta> getBlocksFromNames(String[] blockNames) {
        LinkedList<BlockAndMeta> result = new LinkedList<BlockAndMeta>();
        for (String blockName : blockNames) {
            result.add(new BlockAndMeta(blockName));
        }
        return result;
    }
}

