/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees.config;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class BlockAndMeta {
    private Block block;
    private int meta;
    private boolean hasMeta;

    public BlockAndMeta(String codedBlockAndMetaString) {
        String[] nameItems = codedBlockAndMetaString.split(":");
        if (nameItems.length >= 2) {
            this.block = GameRegistry.findBlock((String)nameItems[0], (String)nameItems[1]);
        }
        if (nameItems.length == 3) {
            this.meta = Integer.parseInt(nameItems[2]);
            this.hasMeta = true;
        }
        if (this.block == null) {
            this.block = Block.func_149684_b((String)nameItems[0]);
        }
    }

    public boolean isAir() {
        return this.block == Blocks.field_150350_a;
    }

    public BlockAndMeta(Block block) {
        this.block = block;
    }

    public BlockAndMeta(Block block, int meta) {
        this.block = block;
        this.meta = meta;
        this.hasMeta = true;
    }

    public boolean areEqual(BlockAndMeta ... blocks) {
        for (BlockAndMeta other : blocks) {
            if (!this.areEqual(this, other)) continue;
            return true;
        }
        return false;
    }

    private boolean areEqual(BlockAndMeta me, BlockAndMeta other) {
        if (me.block == other.block) {
            if (me.hasMeta) {
                return me.meta == other.meta;
            }
            return true;
        }
        return false;
    }

    public boolean areEqual(Block ... blocks) {
        for (Block other : blocks) {
            if (this.block != other) continue;
            return true;
        }
        return false;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public boolean hasMeta() {
        return this.hasMeta;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getBlockName());
        if (this.hasMeta) {
            builder.append(":");
            builder.append(this.meta);
        }
        return builder.toString();
    }

    private String getBlockName() {
        if (this.block == null) {
            return "";
        }
        return GameData.getBlockRegistry().func_148750_c((Object)this.block);
    }
}

