/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees.config;

import cpw.mods.fml.common.FMLLog;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import karob.bigtrees.KTreeCfgTrees;
import karob.bigtrees.config.Population;
import karob.bigtrees.config.TreeConfiguration;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;

public class BiomeConfiguration {
    private Set<BiomeDictionary.Type> includedBiomeTypes = new HashSet<BiomeDictionary.Type>();
    private Set<BiomeDictionary.Type> excludedBiomeTypes = new HashSet<BiomeDictionary.Type>();
    private Map<TreeConfiguration, Population> treePopulation = new HashMap<TreeConfiguration, Population>();
    private Set<String> specificBiomes = new HashSet<String>();

    public BiomeConfiguration(ConfigCategory mainConfigSection) {
        for (ConfigCategory child : mainConfigSection.getChildren()) {
            if (child.getName().equals("biometypes")) {
                this.handleBiometypes(child);
            }
            if (!child.getName().equals("treepopulation")) continue;
            this.handleTreePopulation(child);
        }
    }

    private void handleTreePopulation(ConfigCategory treePopulationCategory) {
        for (ConfigCategory treeConfig : treePopulationCategory.getChildren()) {
            String treeName = treeConfig.getName();
            int percentageChancePerChunk = 0;
            int treesPerChunk = 0;
            for (Map.Entry entry : treeConfig.entrySet()) {
                if (((String)entry.getKey()).equals("percentagechancepertree")) {
                    percentageChancePerChunk = ((Property)entry.getValue()).getInt();
                    continue;
                }
                if (!((String)entry.getKey()).equals("treesperchunk")) continue;
                treesPerChunk = ((Property)entry.getValue()).getInt();
            }
            Population population = new Population(percentageChancePerChunk, treesPerChunk);
            this.treePopulation.put(KTreeCfgTrees.getTreeConfiguration(treeName), population);
        }
    }

    private void handleBiometypes(ConfigCategory child) {
        for (Map.Entry entry : child.entrySet()) {
            Property property = (Property)entry.getValue();
            String propertyName = property.getName();
            if (propertyName.toLowerCase().equalsIgnoreCase("Included")) {
                this.includedBiomeTypes = this.toBiomeTypes(property.getStringList());
                continue;
            }
            if (propertyName.equalsIgnoreCase("Excluded")) {
                this.excludedBiomeTypes = this.toBiomeTypes(property.getStringList());
                continue;
            }
            if (propertyName.equalsIgnoreCase("Specific")) {
                for (String specificBiomeName : property.getStringList()) {
                    this.specificBiomes.add(specificBiomeName.toLowerCase());
                }
                continue;
            }
            FMLLog.getLogger().warn("Skipping biome configuration due to unknown property name '%s'", new Object[]{propertyName});
        }
    }

    private Set<BiomeDictionary.Type> toBiomeTypes(String[] biomeTypeNames) {
        HashSet<BiomeDictionary.Type> result = new HashSet<BiomeDictionary.Type>();
        for (String biomeTypeName : biomeTypeNames) {
            result.add(BiomeDictionary.Type.valueOf((String)biomeTypeName));
        }
        return result;
    }

    public Match matches(BiomeGenBase biome) {
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        if (this.hasBiomeSpecificOverride(biome)) {
            return Match.PriorityMatch;
        }
        if (this.existsInSet(this.excludedBiomeTypes, types)) {
            return Match.NoMatch;
        }
        return this.existsInSet(this.includedBiomeTypes, types) ? Match.Match : Match.NoMatch;
    }

    private boolean hasBiomeSpecificOverride(BiomeGenBase biome) {
        return this.specificBiomes.contains(biome.field_76791_y.toLowerCase());
    }

    private boolean existsInSet(Set<BiomeDictionary.Type> toSearch, BiomeDictionary.Type[] toMatch) {
        if (toSearch.isEmpty()) {
            return false;
        }
        for (BiomeDictionary.Type biomeType : toMatch) {
            if (!toSearch.contains(biomeType)) continue;
            return true;
        }
        return false;
    }

    public Population getPopulation(TreeConfiguration treeConfiguration) {
        if (this.treePopulation.containsKey(treeConfiguration)) {
            return this.treePopulation.get(treeConfiguration);
        }
        return Population.NULL;
    }

    public static enum Match {
        NoMatch,
        Match,
        PriorityMatch;

    }
}

