/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees.compat;

import karob.bigtrees.compat.BlockPos;
import karob.bigtrees.config.BlockAndMeta;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class WorldWrapper {
    private World world;

    public WorldWrapper(World world) {
        this.world = world;
    }

    public BiomeGenBase getBiomeGenForCoords(BlockPos pos) {
        return this.world.func_72807_a(pos.getX(), pos.getZ());
    }

    public int getDimensionId() {
        return this.world.field_73011_w.field_76574_g;
    }

    public long getSeed() {
        return this.world.func_72905_C();
    }

    public BlockPos getHeight(BlockPos pos) {
        return new BlockPos(pos.getX(), this.world.func_72976_f(pos.getX(), pos.getZ()), pos.getZ());
    }

    public void setBlock(BlockPos pos, BlockAndMeta block, BlockFlags ... flags) {
        int flag = 0;
        for (BlockFlags f : flags) {
            flag &= f.value;
        }
        this.world.func_147449_b(pos.getX(), pos.getY(), pos.getZ(), block.getBlock());
        if (block.hasMeta()) {
            this.world.func_72921_c(pos.getX(), pos.getY(), pos.getZ(), block.getMeta(), flag);
        }
    }

    public BlockAndMeta getBlock(BlockPos pos) {
        Block block = this.world.func_147439_a(pos.getX(), pos.getY(), pos.getZ());
        int meta = this.world.func_72805_g(pos.getX(), pos.getY(), pos.getZ());
        return new BlockAndMeta(block, meta);
    }

    public boolean setToAir(BlockPos pos) {
        return this.world.func_147468_f(pos.getX(), pos.getY(), pos.getZ());
    }

    public static enum BlockFlags {
        NoAction(0),
        BlockUpdate(1),
        SendToClient(2),
        PreventReRendering(4);

        private final int value;

        private BlockFlags(int flag) {
            this.value = flag;
        }
    }
}

