/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees;

import java.io.File;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import karob.bigtrees.KTreeCfgBiomes;
import karob.bigtrees.KTreeCfgTrees;

public class KTreeCfg {
    public static boolean rootsEnable = true;
    public static Set<Integer> enabledDimensionIds = KTreeCfg.createDefaultEnabledDimensionsIds();
    public static Set<Integer> disabledDimensionIds = new HashSet<Integer>();
    public static boolean disableVanillaTrees = false;

    public static boolean isValidDimension(int dimensionId) {
        Integer cachedInteger = dimensionId;
        if (disabledDimensionIds.contains(cachedInteger)) {
            return false;
        }
        return enabledDimensionIds.isEmpty() || enabledDimensionIds.contains(cachedInteger);
    }

    private static Set<Integer> createDefaultEnabledDimensionsIds() {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(0);
        return set;
    }

    public static int vary(Random rand, int[] opt) {
        return rand.nextInt(opt[1]) + opt[0];
    }

    public static void init(File modConfigurationDirectory) {
        String configDir = modConfigurationDirectory + File.separator + "bigtrees";
        File configDirectory = new File(configDir);
        configDirectory.mkdir();
        File treeConfigFolder = new File(configDir + File.separator + "treeconfigs");
        treeConfigFolder.mkdir();
        KTreeCfgTrees.init(treeConfigFolder);
        File biomeConfiguration = new File(configDir, "bigtrees.cfg");
        KTreeCfgBiomes.init(biomeConfiguration);
    }
}

