/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import karob.bigtrees.KTreeCfg;
import karob.bigtrees.compat.BlockPos;
import karob.bigtrees.generators.TreeWorldGenerator;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

@Mod(modid="bigtrees", name="BigTrees", version="0.2")
public class BigTrees {
    @Mod.Instance(value="bigtrees")
    public static BigTrees instance;
    private final TreeWorldGenerator treeWorldGenerator = new TreeWorldGenerator();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        KTreeCfg.init(event.getModConfigurationDirectory());
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.treeWorldGenerator, (int)1);
        if (KTreeCfg.disableVanillaTrees) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
    }

    @SubscribeEvent
    public boolean decorate(DecorateBiomeEvent.Decorate evt) {
        if (evt.type == DecorateBiomeEvent.Decorate.EventType.TREE) {
            evt.setResult(Event.Result.DENY);
            return true;
        }
        return false;
    }

    private BlockPos getBlockPos(DecorateBiomeEvent evt) {
        return new BlockPos(evt.chunkX, 0, evt.chunkZ);
    }

    public static void registerBlock(Block b, String name) {
        GameRegistry.registerBlock((Block)b, (String)b.func_149739_a());
        LanguageRegistry.addName((Object)b, (String)name);
    }

    public static void registerBlock(Block block, Class<? extends ItemBlock> itemBlockClass) {
        GameRegistry.registerBlock((Block)block, itemBlockClass, (String)block.func_149739_a().replace("tile.", ""));
    }
}

