/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.Net.Packet;

import com.advGenetics.Net.ClientPacketHandler;
import com.advGenetics.Net.CommonPacketHandler;
import com.advGenetics.Net.Packet.AbstractPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;

public class Packet3DNASync
extends AbstractPacket {
    public int packetID;
    public int entityID;
    public String data;

    public Packet3DNASync() {
    }

    public Packet3DNASync(int packetID, String data, int entityID) {
        this.packetID = packetID;
        this.data = data;
        this.entityID = entityID;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.packetID);
        buffer.writeInt(this.data.getBytes().length);
        buffer.writeBytes(this.data.getBytes());
        buffer.writeInt(this.entityID);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.packetID = buffer.readInt();
        int size = buffer.readInt();
        this.data = new String(buffer.readBytes(size).array());
        this.entityID = buffer.readInt();
    }

    @Override
    public void handleClientSide(ByteBuf stream, AbstractPacket packet, EntityPlayer player) {
        ClientPacketHandler.onPacketData(stream, packet, player);
    }

    @Override
    public void handleServerSide(ByteBuf stream, AbstractPacket packet, EntityPlayer player) {
        CommonPacketHandler.onPacketData(stream, packet, player);
    }
}

