/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.Event;

import com.advGenetics.API.Ability;
import com.advGenetics.API.IKeyAction;
import com.advGenetics.API.IPlayerTick;
import com.advGenetics.DNA.AbilityRegistry;
import com.advGenetics.DNA.DNA;
import com.advGenetics.Event.JoinEventHandler;
import com.advGenetics.Lib.AdvGenUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class TickEventHandler {
    private static List<KeyBinding> pressedKeys = new ArrayList<KeyBinding>();
    public static Map<EntityPlayer, AdvGenUtil.EnumSyncType> playersToSync = new HashMap<EntityPlayer, AdvGenUtil.EnumSyncType>();
    private boolean errorWasSend = false;

    @SubscribeEvent
    public void keyInputEvent(InputEvent.KeyInputEvent event) {
        for (Ability ability : AbilityRegistry.ab_key) {
            IKeyAction keyAction = (IKeyAction)((Object)ability);
            if (keyAction.getKeyBinding().func_151468_f() && (keyAction.shouldRepeat() || !pressedKeys.contains(keyAction.getKeyBinding()))) {
                keyAction.keyDown(keyAction.getKeyBinding());
                if (!keyAction.shouldRepeat()) {
                    pressedKeys.add(keyAction.getKeyBinding());
                }
            }
            if (!pressedKeys.contains(keyAction.getKeyBinding()) || keyAction.getKeyBinding().func_151468_f()) continue;
            keyAction.keyUp(keyAction.getKeyBinding());
            pressedKeys.remove(keyAction.getKeyBinding());
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer entity = event.player;
        if (entity != null && entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            DNA dna = new DNA(entity.getEntityData());
            for (Ability ability : AbilityRegistry.ab_tick) {
                if (!dna.hasGene(ability) || !AdvGenUtil.canDebugEvent(ability, (Entity)living)) continue;
                ((IPlayerTick)((Object)ability)).tick((EntityPlayer)living, event.side.isServer());
            }
        }
    }

    public static void addForClientSyncing(EntityPlayer player, AdvGenUtil.EnumSyncType syncType) {
        if (!playersToSync.containsKey(player)) {
            playersToSync.put(player, syncType);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        JoinEventHandler.removeEntityFromDimBuffer((Entity)event.player);
    }

    @SubscribeEvent
    public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.fromDim == 1) {
            DNA dna = new DNA(event.player.getEntityData());
            TickEventHandler.addForClientSyncing(event.player, AdvGenUtil.EnumSyncType.DNA_SYNC);
        }
    }
}

