/*
 * Decompiled with CFR 0.152.
 */
package com.czechmate777.ropebridge.items;

import com.czechmate777.ropebridge.Main;
import com.czechmate777.ropebridge.bridgeMessage;
import com.czechmate777.ropebridge.items.SlabPos;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BBItem
extends Item {
    World world;
    EntityPlayer player;
    boolean viewSnap;
    float playerFov;
    boolean fovNormal;
    Timer smokeTimer;
    Timer buildTimer;
    Timer clickTimer;
    ChatStyle chatStyle = new ChatStyle().func_150238_a(EnumChatFormatting.DARK_AQUA);
    boolean posSet = false;
    int firstX;
    int firstY;
    int firstZ;
    private boolean warningSent = false;

    public BBItem(String unlocalizedName) {
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77625_d(1);
        this.func_77656_e(64);
        this.func_111206_d("ropebridge:bridge_builder");
        this.smokeTimer = new Timer();
        this.buildTimer = new Timer();
        this.clickTimer = new Timer();
        this.viewSnap = false;
        this.fovNormal = true;
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        playerIn.func_71029_a((StatBase)Main.craftAchievement);
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            this.world = worldIn;
        }
        if (playerIn.field_70170_p.field_72995_K) {
            this.player = playerIn;
            if (this.playerFov == 0.0f) {
                this.playerFov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
            }
        }
        playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        if (worldIn.field_72995_K) {
            this.viewSnap = true;
            this.fovNormal = false;
            this.clickTimer = new Timer();
            this.clickTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Main.snw.sendToServer((IMessage)new bridgeMessage(0, 0, 0, 0, 2, 0));
                }
            }, 500L);
        }
        return itemStackIn;
    }

    public ItemStack onItemUseFinish(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public float getDigSpeed(ItemStack itemstack, Block blockIn, int metadata) {
        if (this.player == null) {
            return 1.0f;
        }
        if (this.player.func_70093_af() && this.isBridgeBlock(blockIn)) {
            if (!this.warningSent) {
                this.tellPlayer("WARNING! Breaking whole bridge!");
                this.warningSent = true;
            }
            return 0.3f;
        }
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        tooltip.add("- Hold right-click to build");
        tooltip.add("- Sneak to break whole bridge");
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.none;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityPlayer playerIn, int timeLeft) {
        if (worldIn.field_72995_K) {
            this.viewSnap = false;
            if (72000 - timeLeft > 10) {
                if (!this.player.field_70122_E) {
                    this.tellPlayer("You must be standing on something to build a bridge!");
                } else {
                    MovingObjectPosition hit = this.player.func_70614_a((double)Main.maxBridgeDistance, 1.0f);
                    Main.snw.sendToServer((IMessage)new bridgeMessage(0, 0, 0, 0, 0, 0));
                    if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                        int flooredX = (int)Math.floor(this.player.field_70165_t);
                        int flooredY = (int)(Math.floor(this.player.field_70163_u) - 2.0);
                        int flooredZ = (int)Math.floor(this.player.field_70161_v);
                        double xOffset = 0.0;
                        double yOffset = -1.0;
                        double zOffset = 0.0;
                        if (hit.field_72307_f.field_72450_a % 1.0 == 0.0 && hit.field_72307_f.field_72450_a < (double)flooredX) {
                            xOffset += -0.8;
                        }
                        if (hit.field_72307_f.field_72449_c % 1.0 == 0.0 && hit.field_72307_f.field_72449_c < (double)flooredZ) {
                            zOffset += -0.8;
                        }
                        if (hit.field_72307_f.field_72448_b % 1.0 == 0.0 && this.player.field_70125_A > 0.0f) {
                            yOffset += -0.8;
                        }
                        this.newBridge(stack, flooredX, flooredY, flooredZ, (int)Math.round(hit.field_72307_f.field_72450_a + xOffset), (int)Math.round(hit.field_72307_f.field_72448_b + yOffset), (int)Math.round(hit.field_72307_f.field_72449_c + zOffset));
                    }
                }
            } else {
                this.clickTimer.cancel();
            }
        }
    }

    private void newBridge(ItemStack stack, int pos1X, int pos1Y, int pos1Z, int pos2X, int pos2Y, int pos2Z) {
        int z2;
        int z;
        int y2;
        int x2;
        int y1;
        int x1;
        boolean rotate;
        int Zdiff;
        LinkedList<SlabPos> bridge = new LinkedList<SlabPos>();
        boolean allClear = true;
        int Xdiff = Math.abs(pos1X - pos2X);
        if (Xdiff > (Zdiff = Math.abs(pos1Z - pos2Z))) {
            rotate = false;
            x1 = pos1X;
            y1 = pos1Y;
            x2 = pos2X;
            y2 = pos2Y;
            z = pos1Z;
            z2 = pos2Z;
        } else {
            rotate = true;
            x1 = pos1Z;
            y1 = pos1Y;
            x2 = pos2Z;
            y2 = pos2Y;
            z = pos1X;
            z2 = pos2X;
        }
        if (Math.abs(z2 - z) > 3) {
            this.tellPlayer("Sorry, bridge must be built in a cardinal dirrection. Please try again.");
            return;
        }
        double m = (double)(y2 - y1) / (double)(x2 - x1);
        if (!Main.ignoreSlopeWarnings && Math.abs(m) > 0.2) {
            this.tellPlayer("Sorry, your slope is too great. Please try again.");
            return;
        }
        double b = (double)y1 - m * (double)x1;
        double distance = Math.abs(x2 - x1);
        int distInt = Math.abs(x2 - x1);
        if (distInt < 2) {
            return;
        }
        if (!this.hasMaterials(distInt - 1) && !this.player.field_71075_bZ.field_75098_d) {
            return;
        }
        for (int x = Math.min(x1, x2) + 1; x <= Math.max(x1, x2) - 1; ++x) {
            for (int y = Math.max(y1, y2); y >= Math.min(y1, y2) - distInt / 8 - 1; --y) {
                double funcVal = m * (double)x + b - distance / 1000.0 * Math.sin((double)(x - Math.min(x1, x2)) * (Math.PI / distance)) * (double)Main.bridgeDroopFactor + (double)Main.bridgeYOffset;
                if (!((double)y + 0.5 > funcVal) || !((double)y - 0.5 <= funcVal)) continue;
                int level = funcVal >= (double)y ? (funcVal >= (double)y + 0.25 ? 4 : 3) : (funcVal >= (double)y - 0.25 ? 2 : 1);
                allClear = !this.addSlab(bridge, x, y + 1, z, level, rotate) ? false : allClear;
            }
        }
        if (allClear) {
            int type = this.getWoodType();
            if (!this.player.field_71075_bZ.field_75098_d) {
                this.takeMaterials(distInt - 1);
                if (stack.func_77960_j() == stack.func_77958_k()) {
                    this.zoomTo(this.playerFov);
                }
                Main.snw.sendToServer((IMessage)new bridgeMessage(3, 0, 0, 0, 0, 0));
            }
            Main.snw.sendToServer((IMessage)new bridgeMessage(4, 0, 0, 0, 0, 0));
            this.tellPlayer("Building Bridge!");
            this.buildBridge(bridge, type);
        } else {
            this.tellPlayer("Oops! Looks like there's something in the way. Look for the Smoke to see where that is and try again.");
        }
    }

    private int getWoodType() {
        for (int i = 0; i < this.player.field_71071_by.field_70462_a.length; ++i) {
            String name;
            ItemStack stack = this.player.field_71071_by.field_70462_a[i];
            if (stack == null || !(name = stack.func_77973_b().func_77658_a()).equals("tile.woodSlab")) continue;
            System.out.println("Type is number " + stack.func_77960_j());
            return stack.func_77960_j();
        }
        return 0;
    }

    private void tell(EntityPlayer playerIn, String message) {
        playerIn.func_145747_a(new ChatComponentText("[Rope Bridge]: " + message).func_150255_a(this.chatStyle));
    }

    private void tellPlayer(String message) {
        this.tell(this.player, message);
    }

    private boolean addSlab(LinkedList<SlabPos> list, int x, int y, int z, int level, boolean rotate) {
        int posZ;
        int posY;
        int posX;
        if (rotate) {
            posX = z;
            posY = y;
            posZ = x;
        } else {
            posX = x;
            posY = y;
            posZ = z;
        }
        boolean isClear = Main.breakThroughBlocks || this.world.func_147437_c(posX, posY, posZ) || this.world.func_147439_a(posX, posY, posZ).isReplaceable((IBlockAccess)this.world, posX, posY, posZ);
        list.add(new SlabPos(posX, posY, posZ, level, rotate));
        if (!isClear) {
            this.spawnSmoke(posX, posY, posZ, 15);
        }
        return isClear;
    }

    private void spawnSmoke(int posX, int posY, int posZ, int times) {
        if (times > 0) {
            this.world.func_72869_a("explode", (double)posX + 0.5, (double)posY + 0.5, (double)posZ + 0.5, 0.0, 0.0, 0.0);
            final int finPosX = posX;
            final int finPosY = posY;
            final int finPosZ = posZ;
            final int finTimes = times - 1;
            this.smokeTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    BBItem.this.spawnSmoke(finPosX, finPosY, finPosZ, finTimes);
                }
            }, 1000L);
        }
    }

    private void buildBridge(LinkedList<SlabPos> bridge, int type) {
        if (!bridge.isEmpty()) {
            SlabPos slab = bridge.pop();
            int meta = (!slab.rotate ? 0 : 1) + 2 * type;
            Main.snw.sendToServer((IMessage)new bridgeMessage(1, slab.x, slab.y, slab.z, slab.level, meta));
            this.spawnSmoke(slab.x, slab.y, slab.z, 1);
            Main.snw.sendToServer((IMessage)new bridgeMessage(0, slab.x, slab.y, slab.z, 1, 0));
            final LinkedList<SlabPos> finBridge = bridge;
            final int finType = type;
            this.buildTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    BBItem.this.buildBridge(finBridge, finType);
                }
            }, 100L);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.field_72995_K) {
            if (((EntityPlayer)entityIn).func_71045_bC() != null) {
                if (((EntityPlayer)entityIn).func_71045_bC().func_77977_a().equals(stack.func_77977_a())) {
                    if (this.viewSnap) {
                        if (isSelected) {
                            this.rotatePlayerTowards(this.getNearestYaw());
                            this.zoomTowards(30.0f);
                        }
                    } else {
                        this.zoomTowards(this.playerFov);
                    }
                } else {
                    this.zoomTowards(this.playerFov);
                    this.viewSnap = false;
                    this.clickTimer.cancel();
                }
            } else {
                this.zoomTowards(this.playerFov);
                this.viewSnap = false;
                this.clickTimer.cancel();
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int posX, int posY, int posZ, EntityPlayer playerIn) {
        if (playerIn.field_70170_p.field_72995_K) {
            Block blk = playerIn.field_70170_p.func_147439_a(posX, posY, posZ);
            if (playerIn.func_70093_af() && this.isBridgeBlock(blk)) {
                this.breakBridge(playerIn.field_70170_p, posX, posY, posZ, playerIn.field_70170_p.func_72805_g(posX, posY, posZ));
            }
        }
        return false;
    }

    private boolean isBridgeBlock(Block blockIn) {
        return blockIn.func_149739_a().contains("bridge_block");
    }

    private void breakBridge(World worldIn, int posInX, int posInY, int posInZ, int meta) {
        Main.snw.sendToServer((IMessage)new bridgeMessage(1, posInX, posInY, posInZ, 0, 0));
        int xRange = 0;
        int zRange = 0;
        if (meta % 2 == 0) {
            xRange = 1;
        } else {
            zRange = 1;
        }
        for (int x = posInX - xRange; x <= posInX + xRange; ++x) {
            for (int y = posInY - 1; y <= posInY + 1; ++y) {
                for (int z = posInZ - zRange; z <= posInZ + zRange; ++z) {
                    if (x - posInX == 0 && z - posInZ == 0) continue;
                    Block currentBlock = worldIn.func_147439_a(x, y, z);
                    int currentMeta = worldIn.func_72805_g(x, y, z);
                    if (!this.isBridgeBlock(currentBlock) || currentMeta != meta) continue;
                    final World worldInFinal = worldIn;
                    final int xFinal = x;
                    final int yFinal = y;
                    final int zFinal = z;
                    final int metaFinal = meta;
                    this.buildTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            BBItem.this.breakBridge(worldInFinal, xFinal, yFinal, zFinal, metaFinal);
                        }
                    }, 100L);
                }
            }
        }
    }

    private boolean hasMaterials(int dist) {
        if (this.player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int slabsNeeded = dist;
        int stringNeeded = 1 + Math.round(dist / 2);
        int slabsHad = 0;
        int stringHad = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = this.player.field_71071_by.field_70462_a[i];
            if (stack == null) continue;
            String name = stack.func_77973_b().func_77658_a();
            if (name.equals("item.string")) {
                stringHad += stack.field_77994_a;
            }
            if (!name.equals("tile.woodSlab")) continue;
            slabsHad += stack.field_77994_a;
        }
        if (slabsHad >= slabsNeeded && stringHad >= stringNeeded) {
            return true;
        }
        this.tellPlayer("You need at least " + slabsNeeded + " slabs and " + stringNeeded + " strings to build this bridge.");
        return false;
    }

    private void takeMaterials(int dist) {
        if (this.player.field_71075_bZ.field_75098_d) {
            return;
        }
        int slabsNeeded = dist;
        int stringNeeded = 1 + Math.round(dist / 2);
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = this.player.field_71071_by.field_70462_a[i];
            if (stack == null) continue;
            String name = stack.func_77973_b().func_77658_a();
            if (name.equals("item.string")) {
                if (stack.field_77994_a > stringNeeded) {
                    Main.snw.sendToServer((IMessage)new bridgeMessage(2, 0, 0, 0, i, stack.field_77994_a - stringNeeded));
                    stringNeeded = 0;
                } else {
                    stringNeeded -= stack.field_77994_a;
                    Main.snw.sendToServer((IMessage)new bridgeMessage(2, 0, 0, 0, i, 0));
                    continue;
                }
            }
            if (!name.equals("tile.woodSlab")) continue;
            if (stack.field_77994_a > slabsNeeded) {
                Main.snw.sendToServer((IMessage)new bridgeMessage(2, 0, 0, 0, i, stack.field_77994_a - slabsNeeded));
                slabsNeeded = 0;
                continue;
            }
            slabsNeeded -= stack.field_77994_a;
            Main.snw.sendToServer((IMessage)new bridgeMessage(2, 0, 0, 0, i, 0));
        }
    }

    private float getNearestYaw() {
        float yaw = this.player.field_70177_z % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw < 45.0f) {
            return 0.0f;
        }
        if (yaw > 45.0f && yaw <= 135.0f) {
            return 90.0f;
        }
        if (yaw > 135.0f && yaw <= 225.0f) {
            return 180.0f;
        }
        if (yaw > 225.0f && yaw <= 315.0f) {
            return 270.0f;
        }
        return 360.0f;
    }

    private void rotatePlayerTowards(float target) {
        float yaw = this.player.field_70177_z % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        this.rotatePlayerTo(yaw + (target - yaw) / 4.0f);
    }

    private void rotatePlayerTo(float yaw) {
        float original = this.player.field_70177_z;
        this.player.field_70177_z = yaw;
        this.player.field_70126_B += this.player.field_70177_z - original;
    }

    private void zoomTowards(float toFov) {
        if (Main.zoomOnAim && toFov != 0.0f && !this.fovNormal) {
            float currentFov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
            if ((float)Math.round(currentFov) != toFov) {
                this.zoomTo(currentFov + (toFov - currentFov) / 4.0f);
            } else if ((float)Math.round(currentFov) == this.playerFov) {
                this.fovNormal = true;
            }
        }
    }

    private void zoomTo(float toFov) {
        if (Main.zoomOnAim && toFov != 0.0f) {
            Minecraft.func_71410_x().field_71474_y.field_74334_X = toFov;
        }
    }
}

