/*
 * Decompiled with CFR 0.152.
 */
package farseek.world.storage;

import cpw.mods.fml.common.FMLContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.StartupQuery;
import farseek.FarseekBaseMod;
import farseek.core.ReplacedMethod;
import farseek.util.ImplicitConversions$;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.RichInt$;

public final class SaveHandlerExtensions$ {
    public static final SaveHandlerExtensions$ MODULE$;

    static {
        new SaveHandlerExtensions$();
    }

    public void readData(SaveHandler handler, WorldInfo worldInfo, Map<String, NBTBase> properties, NBTTagCompound tags, ReplacedMethod<FMLContainer> super_readData, FMLContainer container) {
        Set savedModIds = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        NBTTagList modTags = tags.func_150295_c("ModList", 10);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), modTags.func_74745_c()).foreach((Function1)new Serializable(savedModIds, modTags){
            private final Set savedModIds$1;
            private final NBTTagList modTags$1;

            public final Set<String> apply(int i) {
                return (Set)this.savedModIds$1.$plus$eq((Object)this.modTags$1.func_150305_b(i).func_74779_i("ModId"));
            }
            {
                this.savedModIds$1 = savedModIds$1;
                this.modTags$1 = modTags$1;
            }
        });
        Buffer loadedModContainers = ImplicitConversions$.MODULE$.scalaBuffer(Loader.instance().getModList());
        Seq missingFarseekMods = (Seq)((TraversableLike)loadedModContainers.map((Function1)new Serializable(){

            public final Object apply(ModContainer x$1) {
                return x$1.getMod();
            }
        }, Buffer$.MODULE$.canBuildFrom())).collect((PartialFunction)new Serializable(savedModIds){
            private final Set savedModIds$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                FarseekBaseMod farseekBaseMod;
                A1 A1 = x1;
                Object object = A1 instanceof FarseekBaseMod && !this.savedModIds$1.contains((Object)(farseekBaseMod = (FarseekBaseMod)A1).id()) ? farseekBaseMod : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                FarseekBaseMod farseekBaseMod;
                Object object = x1;
                boolean bl = object instanceof FarseekBaseMod && !this.savedModIds$1.contains((Object)(farseekBaseMod = (FarseekBaseMod)object).id());
                return bl;
            }
            {
                this.savedModIds$1 = savedModIds$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Seq missingMandatoryMods = (Seq)missingFarseekMods.filter((Function1)new Serializable(){

            public final boolean apply(FarseekBaseMod x$2) {
                return x$2.requiresNewWorld();
            }
        });
        if (missingMandatoryMods.nonEmpty()) {
            String missingModsList = ((TraversableOnce)missingMandatoryMods.map((Function1)new Serializable(){

                public final String apply(FarseekBaseMod x$3) {
                    return x$3.name();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
            String errorMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The following mod(s) can only be used with new worlds:\\n\\n", "\\n\\nTo load this save, remove the listed mod(s) and restart."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingModsList}));
            StartupQuery.notify((String)errorMessage);
            StartupQuery.abort();
        } else {
            Seq missingWarningMods = (Seq)missingFarseekMods.filter((Function1)new Serializable(){

                public final boolean apply(FarseekBaseMod x$4) {
                    return x$4.existingWorldWarning().isDefined();
                }
            });
            if (missingWarningMods.nonEmpty()) {
                Seq existingWorldWarnings = (Seq)missingWarningMods.map((Function1)new Serializable(){

                    public final String apply(FarseekBaseMod mod) {
                        return new StringBuilder().append((Object)mod.name()).append((Object)": ").append(mod.existingWorldWarning().get()).toString();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String warningsList = existingWorldWarnings.mkString("\n");
                String warningMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The following mod(s) can cause issues with existing worlds:\\n\\n", "\\n\\nIt is recommended to make backups of your world before proceeding.\\n\\nContinue?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{warningsList}));
                if (StartupQuery.confirm((String)warningMessage)) {
                    super_readData.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{handler, worldInfo, properties, tags}), container);
                } else {
                    StartupQuery.abort();
                }
            } else {
                super_readData.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{handler, worldInfo, properties, tags}), container);
            }
        }
    }

    private SaveHandlerExtensions$() {
        MODULE$ = this;
    }
}

