/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.tile;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityBeaconRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDye;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import team.chisel.block.tileentity.TileEntityCarvableBeacon;

public class RenderCarvableBeacon
extends TileEntityBeaconRenderer
implements ISimpleBlockRenderingHandler {
    private static final ResourceLocation texture = new ResourceLocation("textures/entity/beacon_beam.png");
    private int renderId = RenderingRegistry.getNextAvailableRenderId();

    public void renderTileEntityAt(TileEntityCarvableBeacon beacon, double x, double y, double z, float partialTicks) {
        float f1 = beacon.func_146002_i();
        if (f1 > 0.1f) {
            this.renderBeam(f1, beacon.func_145831_w(), x, y, z, beacon.func_145832_p(), partialTicks);
        }
    }

    private void renderBeam(float f1, World world, double x, double y, double z, int meta, float partialTicks) {
        Color color;
        GL11.glAlphaFunc((int)516, (float)0.1f);
        if (meta < 15) {
            color = new Color(ItemDye.field_150922_c[meta]);
        } else {
            float hue = (float)world.func_82737_E() % 256.0f / 256.0f;
            color = new Color(Color.HSBtoRGB(hue + partialTicks / 256.0f, 1.0f, 1.0f));
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        this.func_147499_a(texture);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        float f2 = (float)world.func_82737_E() + partialTicks;
        float f3 = -f2 * 0.2f - (float)MathHelper.func_76141_d((float)(-f2 * 0.1f));
        boolean b0 = true;
        double d3 = (double)f2 * 0.025 * (1.0 - (double)(b0 & true) * 2.5);
        tessellator.func_78382_b();
        tessellator.func_78370_a(color.getRed(), color.getGreen(), color.getBlue(), 32);
        double d5 = (double)b0 * 0.2;
        double d7 = 0.5 + Math.cos(d3 + 2.356194490192345) * d5;
        double d9 = 0.5 + Math.sin(d3 + 2.356194490192345) * d5;
        double d11 = 0.5 + Math.cos(d3 + 0.7853981633974483) * d5;
        double d13 = 0.5 + Math.sin(d3 + 0.7853981633974483) * d5;
        double d15 = 0.5 + Math.cos(d3 + 3.9269908169872414) * d5;
        double d17 = 0.5 + Math.sin(d3 + 3.9269908169872414) * d5;
        double d19 = 0.5 + Math.cos(d3 + 5.497787143782138) * d5;
        double d21 = 0.5 + Math.sin(d3 + 5.497787143782138) * d5;
        double d23 = 256.0f * f1;
        double d25 = 0.0;
        double d27 = 1.0;
        double d28 = -1.0f + f3;
        double d29 = (double)(256.0f * f1) * (0.5 / d5) + d28;
        tessellator.func_78374_a(x + d7, y + d23, z + d9, d27, d29);
        tessellator.func_78374_a(x + d7, y, z + d9, d27, d28);
        tessellator.func_78374_a(x + d11, y, z + d13, d25, d28);
        tessellator.func_78374_a(x + d11, y + d23, z + d13, d25, d29);
        tessellator.func_78374_a(x + d19, y + d23, z + d21, d27, d29);
        tessellator.func_78374_a(x + d19, y, z + d21, d27, d28);
        tessellator.func_78374_a(x + d15, y, z + d17, d25, d28);
        tessellator.func_78374_a(x + d15, y + d23, z + d17, d25, d29);
        tessellator.func_78374_a(x + d11, y + d23, z + d13, d27, d29);
        tessellator.func_78374_a(x + d11, y, z + d13, d27, d28);
        tessellator.func_78374_a(x + d19, y, z + d21, d25, d28);
        tessellator.func_78374_a(x + d19, y + d23, z + d21, d25, d29);
        tessellator.func_78374_a(x + d15, y + d23, z + d17, d27, d29);
        tessellator.func_78374_a(x + d15, y, z + d17, d27, d28);
        tessellator.func_78374_a(x + d7, y, z + d9, d25, d28);
        tessellator.func_78374_a(x + d7, y + d23, z + d9, d25, d29);
        tessellator.func_78381_a();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDepthMask((boolean)false);
        tessellator.func_78382_b();
        tessellator.func_78370_a(color.getRed(), color.getGreen(), color.getBlue(), 32);
        double d30 = 0.2;
        double d4 = 0.2;
        double d6 = 0.8;
        double d8 = 0.2;
        double d10 = 0.2;
        double d12 = 0.8;
        double d14 = 0.8;
        double d16 = 0.8;
        double d18 = 256.0f * f1;
        double d20 = 0.0;
        double d22 = 1.0;
        double d24 = -1.0f + f3;
        double d26 = (double)(256.0f * f1) + d24;
        tessellator.func_78374_a(x + d30, y + d18, z + d4, d22, d26);
        tessellator.func_78374_a(x + d30, y, z + d4, d22, d24);
        tessellator.func_78374_a(x + d6, y, z + d8, d20, d24);
        tessellator.func_78374_a(x + d6, y + d18, z + d8, d20, d26);
        tessellator.func_78374_a(x + d14, y + d18, z + d16, d22, d26);
        tessellator.func_78374_a(x + d14, y, z + d16, d22, d24);
        tessellator.func_78374_a(x + d10, y, z + d12, d20, d24);
        tessellator.func_78374_a(x + d10, y + d18, z + d12, d20, d26);
        tessellator.func_78374_a(x + d6, y + d18, z + d8, d22, d26);
        tessellator.func_78374_a(x + d6, y, z + d8, d22, d24);
        tessellator.func_78374_a(x + d14, y, z + d16, d20, d24);
        tessellator.func_78374_a(x + d14, y + d18, z + d16, d20, d26);
        tessellator.func_78374_a(x + d10, y + d18, z + d12, d22, d26);
        tessellator.func_78374_a(x + d10, y, z + d12, d22, d24);
        tessellator.func_78374_a(x + d30, y, z + d4, d20, d24);
        tessellator.func_78374_a(x + d30, y + d18, z + d4, d20, d26);
        tessellator.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        this.renderTileEntityAt((TileEntityCarvableBeacon)tile, x, y, z, partialTicks);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        renderer.func_147800_a((Block)Blocks.field_150461_bJ, 0, 1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        this.renderBeam(0.00195f, (World)Minecraft.func_71410_x().field_71441_e, 0.0, 0.0, 0.0, metadata, 0.0f);
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        float f = 0.1875f;
        boolean breaking = renderer.func_147744_b();
        if (!breaking) {
            renderer.func_147757_a(renderer.func_147745_b(Blocks.field_150359_w));
        }
        renderer.func_147751_a(block, x, y, z, 1.0f, 1.0f, 1.0f);
        renderer.field_147837_f = true;
        if (!breaking) {
            renderer.func_147757_a(renderer.func_147745_b(Blocks.field_150343_Z));
        }
        renderer.func_147782_a(0.125, 0.00625, 0.125, 0.875, (double)f, 0.875);
        renderer.func_147751_a(block, x, y, z, 1.0f, 1.0f, 1.0f);
        if (!breaking) {
            renderer.func_147757_a(renderer.func_147745_b((Block)Blocks.field_150461_bJ));
        }
        renderer.func_147782_a(0.1875, (double)f, 0.1875, 0.8125, 0.875, 0.8125);
        renderer.func_147751_a(block, x, y, z, 1.0f, 1.0f, 1.0f);
        renderer.field_147837_f = false;
        renderer.func_147771_a();
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.renderId;
    }
}

