/*
 * Decompiled with CFR 0.152.
 */
package me.vierdant.playeremotes.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import me.vierdant.playeremotes.data.Animation;
import me.vierdant.playeremotes.screen.ScreenTextures;
import me.vierdant.playeremotes.screen.widget.IEmoteListWidgetHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEmoteListWidget<E extends AbstractEmoteEntry<E>>
extends ObjectSelectionList<E>
implements IEmoteListWidgetHelper {
    private final Screen screen;
    protected List<E> emotes = new ArrayList();

    public AbstractEmoteListWidget(Minecraft minecraftClient, int i, int j, int k, int l, int m) {
        super(minecraftClient, i, j, k, l, m);
        this.m_93488_(false);
        this.screen = null;
    }

    @Override
    public IEmoteListWidgetHelper.IEmoteEntry getSelectedEntry() {
        return (IEmoteListWidgetHelper.IEmoteEntry)this.m_93511_();
    }

    public AbstractEmoteListWidget(Minecraft minecraftClient, int i, int j, int k, int l, int m, Screen screen) {
        super(minecraftClient, i, j, k, l, m);
        this.f_93394_ = false;
        this.m_93488_(false);
        this.m_93496_(false);
        this.screen = screen;
    }

    public int m_5759_() {
        return this.f_93388_ - 5;
    }

    protected abstract E newEmoteEntry(Minecraft var1, Animation var2);

    @Override
    public void animationsSetLeftPos(int x) {
        this.m_93507_(x);
    }

    @Override
    public void setAnimations(Iterable<Animation> animations, boolean showInvalid) {
        this.emotes = new ArrayList();
        for (Animation animation : animations) {
            this.emotes.add(this.newEmoteEntry(Minecraft.m_91087_(), animation));
        }
        this.emotes.sort(Comparator.comparing(o -> o.emote.name.toLowerCase()));
        this.filter(() -> "");
    }

    @Override
    public void filter(Supplier<String> string) {
        this.m_93516_();
        for (AbstractEmoteEntry emote : this.emotes) {
            if (!emote.emote.name.toLowerCase().contains(string.get()) && !emote.emote.description.toLowerCase().contains(string.get()) && !emote.emote.author.toLowerCase().equals(string.get())) continue;
            this.m_7085_((AbstractSelectionList.Entry)emote);
        }
        this.m_93410_(0.0);
    }

    @Override
    public void renderThis(GuiGraphics context, int mouseX, int mouseY, float tickDelta) {
        RenderSystem.enableBlend();
        context.m_280163_(ScreenTextures.MENU_BACKGROUND_TEXTURE, this.getLeft(), this.getTop(), (float)this.getRight(), (float)(this.getBottom() + (int)this.m_93517_()), this.getRight() - this.getLeft(), this.getBottom() - this.getTop(), 32, 32);
        context.m_280163_(ScreenTextures.MENU_BACKGROUND_TEXTURE, this.getLeft(), 0, 0.0f, 0.0f, this.f_93388_, this.getTop(), 32, 32);
        context.m_280163_(ScreenTextures.MENU_BACKGROUND_TEXTURE, this.getLeft(), this.getBottom(), 0.0f, (float)this.getBottom(), this.f_93388_, this.f_93389_ - this.getBottom(), 32, 32);
        context.m_285978_(RenderType.m_286086_(), this.getLeft(), this.getTop(), this.getRight(), this.getTop() + 4, -16777216, 0, 0);
        context.m_285978_(RenderType.m_286086_(), this.getLeft(), this.getBottom() - 4, this.getRight(), this.getBottom(), 0, -16777216, 0);
        this.m_88315_(context, mouseX, mouseY, tickDelta);
        RenderSystem.disableBlend();
    }

    protected int m_5756_() {
        return this.getLeft() + this.f_93388_ - 6;
    }

    public boolean m_93696_() {
        if (this.screen == null) {
            return false;
        }
        return this.screen.m_7222_() == this;
    }

    public static abstract class AbstractEmoteEntry<T extends AbstractEmoteEntry<T>>
    extends ObjectSelectionList.Entry<T>
    implements IEmoteListWidgetHelper.IEmoteEntry {
        protected final Minecraft client;
        public final Animation emote;

        public AbstractEmoteEntry(Minecraft client, Animation emote) {
            this.client = client;
            this.emote = emote;
        }

        public void m_6311_(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.renderThis(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
        }

        @Override
        public Animation getAnimation() {
            return this.emote;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.onPressed();
                return true;
            }
            return false;
        }

        protected abstract void onPressed();
    }
}

