/*
 * Decompiled with CFR 0.152.
 */
package me.vierdant.playeremotes.screen;

import me.vierdant.playeremotes.PlayeremotesClient;
import me.vierdant.playeremotes.data.Animation;
import me.vierdant.playeremotes.data.AnimationRegistry;
import me.vierdant.playeremotes.screen.EmoteScreen;
import me.vierdant.playeremotes.screen.widget.AbstractEmoteListWidget;
import me.vierdant.playeremotes.screen.widget.AbstractQuickWheelWidget;
import me.vierdant.playeremotes.screen.widget.IQuickWheel;
import me.vierdant.playeremotes.screen.widget.IWidgetLogic;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmoteListScreen
extends EmoteScreen {
    protected int activeKeyTime = 0;
    private AbstractEmoteListWidget<?> emoteList;
    private QuickWheelWidget quickWheel;
    private boolean save = false;
    private EditBox searchBox;

    protected EmoteListScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"screen.playeremotes.emoteconfig"), parent);
    }

    public void m_7856_() {
        int x1 = this.getWidth() / 2 - (int)((double)this.getWidth() / 2.2 - 16.0) - 12;
        int width1 = (int)((double)this.getWidth() / 2.2 - 16.0);
        MutableComponent title1 = Component.m_237115_((String)"playeremotes.search");
        this.searchBox = new EditBox(Minecraft.m_91087_().f_91062_, x1, 12, width1, 20, (Component)title1);
        this.searchBox.m_94151_(string -> this.emoteList.filter(string::toLowerCase));
        this.m_142416_((GuiEventListener)this.searchBox);
        this.emoteList = this.newEmoteList((int)((double)this.getWidth() / 2.2 - 16.0), this.getHeight());
        this.emoteList.animationsSetLeftPos(this.getWidth() / 2 - (int)((double)this.getWidth() / 2.2 - 16.0) - 12);
        this.addToChildren(this.emoteList);
        int x = Math.min(this.getWidth() / 4, (int)((double)this.getHeight() / 2.5));
        this.quickWheel = this.newQuickWheelWidget(this.getWidth() / 2 + 2, this.getHeight() / 2 - 8, x - 7);
        this.addToChildren(this.quickWheel);
        int x4 = this.getWidth() / 2 + 10;
        int y = this.getHeight() - 30;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"playeremotes.done"), button1 -> this.openParent()).m_252794_(x4, y).m_253046_(96, 20).m_253136_());
        this.emoteList.setAnimations(AnimationRegistry.getAnimations(), true);
        this.m_264313_((GuiEventListener)this.searchBox);
    }

    protected QuickWheelWidget newQuickWheelWidget(int x, int y, int size) {
        return new QuickWheelImpl(x, y, size);
    }

    public void setFocusedElement(@Nullable GuiEventListener focused) {
        if (this.activeKeyTime == 0) {
            this.m_7522_(focused);
        }
    }

    public void m_86600_() {
        if (this.activeKeyTime == 1) {
            this.setFocusedElement(null);
        }
        if (this.activeKeyTime != 0) {
            --this.activeKeyTime;
        }
        super.m_86600_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_88315_(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderDarkening(context);
        this.emoteList.renderThis(context, mouseX, mouseY, delta);
        this.searchBox.m_88315_(context, mouseX, mouseY, delta);
        this.quickWheel.render(context, mouseX, mouseY, delta);
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    public void m_7861_() {
        if (this.save) {
            this.saveConfig();
        }
    }

    private void saveConfig() {
        PlayeremotesClient.config.save();
    }

    public boolean m_7933_(int keyCode, int scanCode, int mod) {
        return super.m_7933_(keyCode, scanCode, mod);
    }

    protected AbstractEmoteListWidget<?> newEmoteList(int width, int height) {
        return new EmoteListImpl(this.getMinecraft(), width, height, 51, height - 32, 36, this);
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }

    protected abstract class QuickWheelWidget
    extends AbstractQuickWheelWidget {
        public QuickWheelWidget(int x, int y, int size) {
            super(x, y, size);
        }

        @Override
        protected boolean isValidClickButton(int button) {
            return (button == 0 || button == 1) && EmoteListScreen.this.activeKeyTime == 0;
        }

        @Override
        protected boolean onClick(IQuickWheel.IQuickElement element, int button) {
            if (EmoteListScreen.this.activeKeyTime != 0) {
                return false;
            }
            if (button == 1) {
                element.clearAnimation();
                EmoteListScreen.this.save = true;
                return true;
            }
            if (EmoteListScreen.this.emoteList.getSelectedEntry() != null) {
                element.setAnimation(EmoteListScreen.this.emoteList.getSelectedEntry().getAnimation());
                EmoteListScreen.this.save = true;
                return true;
            }
            return false;
        }

        @Override
        protected boolean doHoverPart(IQuickWheel.IQuickElement part) {
            return EmoteListScreen.this.activeKeyTime == 0;
        }

        @Override
        protected boolean doesShowInvalid() {
            return true;
        }
    }

    public class QuickWheelImpl
    extends QuickWheelWidget
    implements IWidgetLogic {
        private boolean focused;

        public QuickWheelImpl(int x, int y, int size) {
            super(x, y, size);
            this.focused = true;
        }

        public void m_93692_(boolean bl) {
            this.focused = bl;
        }

        public boolean m_93696_() {
            return this.focused;
        }
    }

    public static class EmoteListImpl
    extends AbstractEmoteListWidget<EmoteListEntryImpl> {
        public EmoteListImpl(Minecraft minecraftClient, int i, int j, int k, int l, int m, Screen screen) {
            super(minecraftClient, i, j, k, l, m, screen);
        }

        @Override
        protected EmoteListEntryImpl newEmoteEntry(Minecraft client, Animation animation) {
            return new EmoteListEntryImpl(client, animation);
        }

        public class EmoteListEntryImpl
        extends AbstractEmoteListWidget.AbstractEmoteEntry<EmoteListEntryImpl> {
            public EmoteListEntryImpl(Minecraft client, Animation animation) {
                super(client, animation);
            }

            @Override
            protected void onPressed() {
                EmoteListImpl.this.m_6987_((AbstractSelectionList.Entry)this);
            }

            @NotNull
            public Component m_142172_() {
                return Component.m_237113_((String)"Emote Entry");
            }
        }
    }
}

