/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api;

import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import toni.sodiumdynamiclights.ExplosiveLightingMode;
import toni.sodiumdynamiclights.SodiumDynamicLights;

public interface DynamicLightHandler<T> {
    public int getLuminance(T var1);

    default public boolean isWaterSensitive(T lightSource) {
        return false;
    }

    @NotNull
    public static <T extends LivingEntity> DynamicLightHandler<T> makeHandler(final Function<T, Integer> luminance, final Function<T, Boolean> waterSensitive) {
        return new DynamicLightHandler<T>(){

            @Override
            public int getLuminance(T lightSource) {
                return (Integer)luminance.apply(lightSource);
            }

            @Override
            public boolean isWaterSensitive(T lightSource) {
                return (Boolean)waterSensitive.apply(lightSource);
            }
        };
    }

    @NotNull
    public static <T extends LivingEntity> DynamicLightHandler<T> makeLivingEntityHandler(@NotNull DynamicLightHandler<T> handler) {
        return entity -> {
            int luminance = 0;
            for (ItemStack equipped : entity.m_20158_()) {
                luminance = Math.max(luminance, SodiumDynamicLights.getLuminanceFromItemStack(equipped, entity.m_5842_()));
            }
            return Math.max(luminance, handler.getLuminance(entity));
        };
    }

    @NotNull
    public static <T extends Creeper> DynamicLightHandler<T> makeCreeperEntityHandler(final @Nullable DynamicLightHandler<T> handler) {
        return new DynamicLightHandler<T>(){

            @Override
            public int getLuminance(T entity) {
                int luminance = 0;
                if ((double)entity.m_32320_(0.0f) > 0.001) {
                    switch ((ExplosiveLightingMode)((Object)SodiumDynamicLights.get().config.getCreeperLightingMode().get())) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case OFF: {
                            int n = 0;
                            break;
                        }
                        case SIMPLE: {
                            int n = 10;
                            break;
                        }
                        case FANCY: {
                            int n = luminance = (int)((double)entity.m_32320_(0.0f) * 10.0);
                        }
                    }
                }
                if (handler != null) {
                    luminance = Math.max(luminance, handler.getLuminance(entity));
                }
                return luminance;
            }

            @Override
            public boolean isWaterSensitive(T lightSource) {
                return true;
            }
        };
    }
}

