/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils;

import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import earth.terrarium.adastra.common.utils.ItemUtils;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;

public class FluidUtils {
    public static FluidHolder getTank(ItemStack stack) {
        return FluidUtils.getTank(stack, 0);
    }

    public static FluidHolder getTank(ItemStack stack, int tank) {
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)new ItemStackHolder(stack));
        if (container == null) {
            return FluidHolder.empty();
        }
        return (FluidHolder)container.getFluids().get(tank);
    }

    public static boolean hasFluid(ItemStack stack) {
        return FluidUtils.hasFluid(stack, 0);
    }

    public static boolean hasFluid(ItemStack stack, int tank) {
        return !FluidUtils.getTank(stack, tank).isEmpty();
    }

    public static long getTankCapacity(ItemStack stack) {
        return FluidUtils.getTankCapacity(stack, 0);
    }

    public static long getTankCapacity(ItemStack stack, int tank) {
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)new ItemStackHolder(stack));
        if (container == null) {
            return 0L;
        }
        return container.getTankCapacity(tank);
    }

    public static ItemStack fluidFilledItem(RegistryEntry<Item> item, RegistryEntry<Fluid> fluid) {
        ItemStackHolder stack = new ItemStackHolder(((Item)item.get()).m_7968_());
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)stack);
        if (container == null) {
            return ItemStack.f_41583_;
        }
        FluidHolder holder = FluidHolder.ofMillibuckets((Fluid)((Fluid)fluid.get()), (long)container.getTankCapacity(0));
        container.insertFluid(holder, false);
        return stack.getStack();
    }

    public static void moveItemToContainer(Container container, FluidContainer fluidContainer, int slot, int resultSlot, int tank) {
        ItemStack emptyStack;
        ItemStack stack = container.m_8020_(slot);
        if (stack.m_41619_() || !FluidContainer.holdsFluid((ItemStack)stack)) {
            return;
        }
        ItemStack resultStack = container.m_8020_(resultSlot);
        ItemStackHolder stackHolder = new ItemStackHolder(stack.m_255036_(1));
        ItemFluidContainer itemFluidContainer = FluidContainer.of((ItemStackHolder)stackHolder);
        if (itemFluidContainer == null) {
            return;
        }
        FluidHolder amount = ((FluidHolder)itemFluidContainer.getFluids().get(tank)).copyHolder();
        if (amount.isEmpty()) {
            return;
        }
        if (!resultStack.m_41619_() && !ItemUtils.canAddItem(emptyStack = FluidUtils.getEmptyStack(stackHolder, amount), resultStack)) {
            return;
        }
        if (FluidApi.moveFluid((FluidContainer)itemFluidContainer, (FluidContainer)fluidContainer, (FluidHolder)amount, (boolean)true) == 0L) {
            return;
        }
        FluidApi.moveFluid((FluidContainer)itemFluidContainer, (FluidContainer)fluidContainer, (FluidHolder)amount, (boolean)false);
        ItemStack result = stackHolder.getStack();
        if (resultStack.m_41619_()) {
            stack.m_41774_(1);
            container.m_6836_(resultSlot, result);
        } else if (ItemUtils.canAddItem(result, resultStack)) {
            stack.m_41774_(1);
            resultStack.m_41769_(1);
        }
    }

    public static void moveContainerToItem(Container container, FluidContainer fluidContainer, int slot, int resultSlot, int tank) {
        ItemStack filledStack;
        ItemStack stack = container.m_8020_(slot);
        if (stack.m_41619_() || !FluidContainer.holdsFluid((ItemStack)stack)) {
            return;
        }
        ItemStack resultStack = container.m_8020_(resultSlot);
        ItemStackHolder stackHolder = new ItemStackHolder(stack.m_255036_(1));
        ItemFluidContainer itemFluidContainer = FluidContainer.of((ItemStackHolder)stackHolder);
        if (itemFluidContainer == null) {
            return;
        }
        FluidHolder amount = ((FluidHolder)fluidContainer.getFluids().get(tank)).copyHolder();
        if (amount.isEmpty()) {
            return;
        }
        if (!resultStack.m_41619_() && !ItemUtils.canAddItem(filledStack = FluidUtils.getFilledStack(stackHolder, amount), resultStack)) {
            return;
        }
        if (FluidApi.moveFluid((FluidContainer)fluidContainer, (FluidContainer)itemFluidContainer, (FluidHolder)amount, (boolean)true) == 0L) {
            return;
        }
        FluidApi.moveFluid((FluidContainer)fluidContainer, (FluidContainer)itemFluidContainer, (FluidHolder)amount, (boolean)false);
        ItemStack result = stackHolder.getStack();
        if (resultStack.m_41619_()) {
            stack.m_41774_(1);
            container.m_6836_(resultSlot, result);
        } else if (ItemUtils.canAddItem(result, resultStack)) {
            stack.m_41774_(1);
            resultStack.m_41769_(1);
        }
    }

    public static ItemStack getFilledStack(ItemStackHolder emptyStack, FluidHolder amount) {
        ItemStackHolder copy = emptyStack.copy();
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)copy);
        if (container == null) {
            return ItemStack.f_41583_;
        }
        container.insertFluid(amount, false);
        return copy.getStack();
    }

    public static ItemStack getEmptyStack(ItemStackHolder filledStack, FluidHolder amount) {
        ItemStackHolder copy = filledStack.copy();
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)copy);
        if (container == null) {
            return ItemStack.f_41583_;
        }
        container.extractFluid(amount, false);
        return copy.getStack();
    }
}

