/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.items;

import dev.architectury.injectables.annotations.PlatformOnly;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.utils.DistributionMode;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyItem;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedItemEnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EtrionicCapacitorItem
extends Item
implements BotariumEnergyItem<WrappedItemEnergyContainer> {
    public static final String ACTIVE_TAG = "Active";
    public static final String MODE_TAG = "Mode";

    public EtrionicCapacitorItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean active(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(ACTIVE_TAG)) {
            return tag.m_128471_(ACTIVE_TAG);
        }
        return true;
    }

    public static boolean toggleActive(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        boolean active = EtrionicCapacitorItem.active(stack);
        tag.m_128379_(ACTIVE_TAG, !active);
        return !active;
    }

    public static DistributionMode mode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(MODE_TAG)) {
            return DistributionMode.values()[tag.m_128445_(MODE_TAG)];
        }
        return DistributionMode.SEQUENTIAL;
    }

    public static DistributionMode toggleMode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        DistributionMode mode = EtrionicCapacitorItem.mode(stack);
        DistributionMode toggled = mode == DistributionMode.SEQUENTIAL ? DistributionMode.ROUND_ROBIN : DistributionMode.SEQUENTIAL;
        tag.m_128344_(MODE_TAG, (byte)toggled.ordinal());
        return toggled;
    }

    public WrappedItemEnergyContainer getEnergyStorage(ItemStack holder) {
        return new WrappedItemEnergyContainer(holder, (EnergyContainer)new SimpleEnergyContainer(250000L){

            public long maxInsert() {
                return 250L;
            }

            public long maxExtract() {
                return 500L;
            }
        });
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        WrappedItemEnergyContainer energy = this.getEnergyStorage(stack);
        tooltipComponents.add(TooltipUtils.getEnergyComponent(energy.getStoredEnergy(), energy.getMaxCapacity()));
        tooltipComponents.add(TooltipUtils.getActiveInactiveComponent(EtrionicCapacitorItem.active(stack)));
        tooltipComponents.add(TooltipUtils.getDistributionModeComponent(EtrionicCapacitorItem.mode(stack)));
        tooltipComponents.add(TooltipUtils.getMaxEnergyInComponent(energy.maxInsert()));
        tooltipComponents.add(TooltipUtils.getMaxEnergyOutComponent(energy.maxExtract()));
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.ETRIONIC_CAPACITOR_INFO);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(usedHand));
        }
        ItemStack stack = player.m_21120_(usedHand);
        if (player.m_6144_()) {
            DistributionMode mode = EtrionicCapacitorItem.toggleMode(stack);
            player.m_5661_(mode == DistributionMode.SEQUENTIAL ? ConstantComponents.CHANGE_MODE_SEQUENTIAL : ConstantComponents.CHANGE_MODE_ROUND_ROBIN, true);
        } else {
            boolean active = EtrionicCapacitorItem.toggleActive(stack);
            player.m_5661_(active ? ConstantComponents.CAPACITOR_ENABLED : ConstantComponents.CAPACITOR_DISABLED, true);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        if (level.m_5776_()) {
            return;
        }
        if (entity.f_19797_ % 5 == 0) {
            return;
        }
        if (!EtrionicCapacitorItem.active(stack)) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Inventory inventory = player.m_150109_();
        WrappedItemEnergyContainer container = this.getEnergyStorage(stack);
        if (container.getStoredEnergy() == 0L) {
            return;
        }
        ItemStackHolder from = new ItemStackHolder(stack);
        switch (EtrionicCapacitorItem.mode(stack)) {
            case SEQUENTIAL: {
                this.distributeSequential(from, container.maxExtract() * 5L, inventory);
                break;
            }
            case ROUND_ROBIN: {
                this.distributeRoundRobin(from, container.maxExtract() * 5L, inventory);
            }
        }
        inventory.m_6836_(slotId, from.getStack());
    }

    public void distributeSequential(ItemStackHolder from, long maxExtract, Inventory inventory) {
        for (int i = inventory.m_6643_() - 1; i >= 0; --i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || stack.m_150930_((Item)this)) continue;
            ItemStackHolder to = new ItemStackHolder(stack);
            long moved = EnergyApi.moveEnergy((ItemStackHolder)from, (ItemStackHolder)to, (long)maxExtract, (boolean)false);
            inventory.m_6836_(i, to.getStack());
            if (moved <= 0L) continue;
            return;
        }
    }

    public void distributeRoundRobin(ItemStackHolder from, long maxExtract, Inventory inventory) {
        int i;
        int energyItems = 0;
        for (i = 0; i < inventory.m_6643_(); ++i) {
            if (!EnergyContainer.holdsEnergy((ItemStack)inventory.m_8020_(i)) || inventory.m_8020_(i).m_150930_((Item)this)) continue;
            ++energyItems;
        }
        if (energyItems == 0) {
            return;
        }
        for (i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_150930_((Item)this) || stack.m_41619_() || stack.m_150930_((Item)this)) continue;
            ItemStackHolder to = new ItemStackHolder(stack);
            EnergyApi.moveEnergy((ItemStackHolder)from, (ItemStackHolder)to, (long)(maxExtract / (long)energyItems), (boolean)false);
            inventory.m_6836_(i, to.getStack());
        }
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getEnergyStorage(stack).getStoredEnergy() > 0L;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        WrappedItemEnergyContainer energyStorage = this.getEnergyStorage(stack);
        return (int)((double)energyStorage.getStoredEnergy() / (double)energyStorage.getMaxCapacity() * 13.0);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return 6544578;
    }

    @PlatformOnly(value={"forge"})
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

