/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.SortedSet;

public class SortedArraySet<E>
implements SortedSet<E> {
    private final ArrayList<E> list;
    private final Comparator<? super E> comparator;

    public SortedArraySet() {
        this.list = new ArrayList();
        this.comparator = null;
    }

    public SortedArraySet(Comparator<? super E> comparator) {
        this.list = new ArrayList();
        this.comparator = comparator;
    }

    public SortedArraySet(Collection<? extends E> collection) {
        this.list = new ArrayList<E>(collection);
        this.comparator = null;
        this.list.sort(null);
    }

    public SortedArraySet(Collection<? extends E> collection, Comparator<? super E> comparator) {
        this.list = new ArrayList<E>(collection);
        this.comparator = comparator;
        this.list.sort(comparator);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public E first() {
        return this.list.get(0);
    }

    @Override
    public E last() {
        return this.list.get(this.list.size() - 1);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        int index = Collections.binarySearch(this.list, e, this.comparator);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        }
        this.list.add(index, e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            changed |= this.add(e);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public String toString() {
        return "SortedArraySet{list=" + this.list + ", comparator=" + this.comparator + '}';
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        int toIndex;
        int fromIndex = Collections.binarySearch(this.list, fromElement, this.comparator);
        if (fromIndex < 0) {
            fromIndex ^= 0xFFFFFFFF;
        }
        if ((toIndex = Collections.binarySearch(this.list, toElement, this.comparator)) < 0) {
            toIndex ^= 0xFFFFFFFF;
        }
        return new SortedArraySet<E>(this.list.subList(fromIndex, toIndex), this.comparator);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        int toIndex = Collections.binarySearch(this.list, toElement, this.comparator);
        if (toIndex < 0) {
            toIndex ^= 0xFFFFFFFF;
        }
        return new SortedArraySet<E>(this.list.subList(0, toIndex), this.comparator);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        int fromIndex = Collections.binarySearch(this.list, fromElement, this.comparator);
        if (fromIndex < 0) {
            fromIndex ^= 0xFFFFFFFF;
        }
        return new SortedArraySet<E>(this.list.subList(fromIndex, this.list.size()), this.comparator);
    }
}

