/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

public class RayCastUtil {
    public static boolean rayIntersectsSquare(double rayX, double rayY, double rayXDirection, double rayYDirection, double squareMinX, double squareMinY, double squareWidth) {
        double roundingValue = 0.05;
        double squareMaxX = squareMinX + squareWidth;
        double squareMaxY = squareMinY + squareWidth;
        if (rayX >= squareMinX && rayX <= squareMaxX && rayY >= squareMinY && rayY <= squareMaxY) {
            return true;
        }
        if (RayCastUtil.isRoughly(rayXDirection, 0.0, roundingValue) && RayCastUtil.isRoughly(rayYDirection, 0.0, roundingValue)) {
            return false;
        }
        if (RayCastUtil.isRoughly(Math.abs(rayYDirection), 1.0, roundingValue) || RayCastUtil.isRoughly(Math.abs(rayXDirection), 0.0, roundingValue)) {
            if (rayYDirection > 0.0 && rayY > squareMaxY || rayYDirection < 0.0 && rayY < squareMinY) {
                return false;
            }
            return rayX >= squareMinX && rayX <= squareMaxX;
        }
        if (RayCastUtil.isRoughly(Math.abs(rayXDirection), 1.0, roundingValue) || RayCastUtil.isRoughly(rayYDirection, 0.0, roundingValue)) {
            if (rayXDirection > 0.0 && rayX > squareMaxX || rayXDirection < 0.0 && rayX < squareMinX) {
                return false;
            }
            return rayY >= squareMinY && rayY <= squareMaxY;
        }
        double slope = rayYDirection / rayXDirection;
        squareMinX -= rayX;
        squareMaxX -= rayX;
        squareMinY -= rayY;
        squareMaxY -= rayY;
        boolean intersectsX = false;
        boolean intersectsY = false;
        double yIntersectMin = slope * squareMinX;
        double yIntersectMax = slope * squareMaxX;
        if (rayYDirection > 0.0 && yIntersectMin <= rayY && yIntersectMax <= rayY || rayYDirection < 0.0 && yIntersectMin >= rayY && yIntersectMax >= rayY) {
            return false;
        }
        if (yIntersectMin >= squareMinY && yIntersectMin <= squareMaxY) {
            intersectsY = true;
        } else if (yIntersectMax >= squareMinY && yIntersectMax <= squareMaxY) {
            intersectsY = true;
        }
        double xIntersectMin = squareMinY / slope;
        double xIntersectMax = squareMaxY / slope;
        if (rayXDirection > 0.0 && xIntersectMin <= rayX && xIntersectMax <= rayX || rayXDirection < 0.0 && xIntersectMin >= rayX && xIntersectMax >= rayX) {
            return false;
        }
        if (xIntersectMin >= squareMinX && xIntersectMin <= squareMaxX) {
            intersectsX = true;
        } else if (xIntersectMax >= squareMinX && xIntersectMax <= squareMaxX) {
            intersectsX = true;
        }
        return intersectsX && intersectsY;
    }

    private static boolean isRoughly(double input, double equalsVal, double errorValue) {
        return input >= equalsVal - errorValue && input <= equalsVal + errorValue;
    }
}

