/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.logging;

import com.seibel.distanthorizons.api.enums.config.EDhApiLoggerMode;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ConfigBasedLogger {
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public static final List<WeakReference<ConfigBasedLogger>> loggers = Collections.synchronizedList(new LinkedList());
    private EDhApiLoggerMode mode;
    private final Supplier<EDhApiLoggerMode> getter;
    private final Logger logger;

    public static synchronized void updateAll() {
        loggers.removeIf(logger -> logger.get() == null);
        loggers.forEach(logger -> {
            ConfigBasedLogger l = (ConfigBasedLogger)logger.get();
            if (l != null) {
                l.update();
            }
        });
    }

    public ConfigBasedLogger(Logger logger, Supplier<EDhApiLoggerMode> configQuery) {
        this.getter = configQuery;
        this.mode = this.getter.get();
        this.logger = logger;
        loggers.add(new WeakReference<ConfigBasedLogger>(this));
    }

    private String _throwableToDetailString(Throwable t) {
        StringBuilder sb = new StringBuilder();
        sb.append(t.toString()).append('\n');
        StackTraceElement[] stacks = t.getStackTrace();
        if (stacks == null || stacks.length == 0) {
            return sb.append("  at {Stack trace unavailable}").toString();
        }
        for (StackTraceElement stack : stacks) {
            sb.append("  at ").append(stack.toString()).append("\n");
        }
        return sb.toString();
    }

    public void update() {
        this.mode = this.getter.get();
    }

    public boolean canMaybeLog() {
        return this.mode != EDhApiLoggerMode.DISABLED;
    }

    public void log(Level level, String str, Object ... param) {
        Message msg = this.logger.getMessageFactory().newMessage(str, param);
        String msgStr = msg.getFormattedMessage();
        if (this.mode.levelForFile.isLessSpecificThan(level)) {
            Level logLevel;
            Level level2 = logLevel = level.isLessSpecificThan(Level.INFO) ? Level.INFO : level;
            if (param.length > 0 && param[param.length - 1] instanceof Throwable) {
                this.logger.log(logLevel, msgStr, (Throwable)param[param.length - 1]);
            } else {
                this.logger.log(logLevel, msgStr);
            }
        }
        if (this.mode.levelForChat.isLessSpecificThan(level)) {
            if (param.length > 0 && param[param.length - 1] instanceof Throwable) {
                MC.logToChat(level, msgStr + "\n" + this._throwableToDetailString((Throwable)param[param.length - 1]));
            } else {
                MC.logToChat(level, msgStr);
            }
        }
    }

    public void error(String str, Object ... param) {
        this.log(Level.ERROR, str, param);
    }

    public void warn(String str, Object ... param) {
        this.log(Level.WARN, str, param);
    }

    public void info(String str, Object ... param) {
        this.log(Level.INFO, str, param);
    }

    public void debug(String str, Object ... param) {
        this.log(Level.DEBUG, str, param);
    }

    public void trace(String str, Object ... param) {
        this.log(Level.TRACE, str, param);
    }

    public Exception errorAndThrow(String str, Exception e) {
        this.log(Level.ERROR, str, new Object[0]);
        return e;
    }
}

