/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.stronghold;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.world.components.structures.stronghold.StrongholdAccessChamberComponent;
import twilightforest.world.components.structures.stronghold.StrongholdBossRoomComponent;
import twilightforest.world.components.structures.stronghold.StrongholdDeadEndComponent;
import twilightforest.world.components.structures.stronghold.StrongholdDecorator;
import twilightforest.world.components.structures.stronghold.StrongholdPieces;
import twilightforest.world.components.structures.stronghold.StrongholdSmallStairsComponent;
import twilightforest.world.components.structures.stronghold.StrongholdTreasureCorridorComponent;
import twilightforest.world.components.structures.stronghold.StrongholdTreasureRoomComponent;
import twilightforest.world.components.structures.stronghold.StructureTFStrongholdComponent;

public class StrongholdEntranceComponent
extends StructureTFStrongholdComponent {
    public final StrongholdPieces lowerPieces;

    public StrongholdEntranceComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFSEnter.get(), nbt);
        this.deco = new StrongholdDecorator();
        this.lowerPieces = new StrongholdPieces();
    }

    public StrongholdEntranceComponent(int i, int x, int y, int z) {
        super((StructurePieceType)TFStructurePieceTypes.TFSEnter.get(), i, Direction.SOUTH, x, y - 10, z);
        this.deco = new StrongholdDecorator();
        this.lowerPieces = new StrongholdPieces();
    }

    @Override
    public void m_214092_(StructurePiece parent, StructurePieceAccessor old, RandomSource random) {
        super.m_214092_(parent, old, random);
        if (old instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)old;
            List list = start.f_192778_;
            this.lowerPieces.prepareStructurePieces();
            this.addNewComponent(parent, old, random, Rotation.NONE, 4, 1, 18);
            this.lowerPieces.prepareStructurePieces();
            if (this.listContainsBossRoom(list)) {
                this.lowerPieces.markBossRoomUsed();
            }
            this.addNewComponent(parent, old, random, Rotation.CLOCKWISE_90, -1, 1, 13);
            this.lowerPieces.prepareStructurePieces();
            if (this.listContainsBossRoom(list)) {
                this.lowerPieces.markBossRoomUsed();
            }
            this.addNewComponent(parent, old, random, Rotation.CLOCKWISE_180, 13, 1, -1);
            this.lowerPieces.prepareStructurePieces();
            if (this.listContainsBossRoom(list)) {
                this.lowerPieces.markBossRoomUsed();
            }
            this.addNewComponent(parent, old, random, Rotation.COUNTERCLOCKWISE_90, 18, 1, 4);
            if (!this.listContainsBossRoom(list)) {
                TwilightForestMod.LOGGER.fatal("Did not find boss room from exit 3 - EPIC FAIL");
            }
            BoundingBox shieldBox = BoundingBoxUtils.clone(this.f_73383_);
            int tStairs = 0;
            int tCorridors = 0;
            int deadEnd = 0;
            int tRooms = 0;
            int bossRooms = 0;
            for (StructurePiece component : list) {
                shieldBox.m_162386_(component.m_73547_());
                if (component instanceof StrongholdSmallStairsComponent && ((StrongholdSmallStairsComponent)component).hasTreasure) {
                    ++tStairs;
                }
                if (component instanceof StrongholdTreasureCorridorComponent) {
                    ++tCorridors;
                }
                if (component instanceof StrongholdDeadEndComponent) {
                    ++deadEnd;
                }
                if (component instanceof StrongholdTreasureRoomComponent) {
                    ++tRooms;
                }
                if (!(component instanceof StrongholdBossRoomComponent)) continue;
                ++bossRooms;
            }
            StrongholdAccessChamberComponent accessChamber = new StrongholdAccessChamberComponent(2, this.m_73549_(), this.f_73383_.m_162395_() + 8, this.f_73383_.m_162396_() + 7, this.f_73383_.m_162398_() + 4);
            list.add(accessChamber);
            ((StructureTFStrongholdComponent)accessChamber).m_214092_(this, old, random);
        }
    }

    private boolean listContainsBossRoom(List<StructurePiece> list) {
        for (StructurePiece component : list) {
            if (!(component instanceof StrongholdBossRoomComponent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BoundingBox generateBoundingBox(Direction facing, int x, int y, int z) {
        return BoundingBox.m_71031_((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)18, (int)7, (int)18, (Direction)facing);
    }

    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.placeStrongholdWalls(world, sbb, 0, 0, 0, 17, 6, 17, rand, this.deco.randomBlocks);
        this.placeCornerStatue(world, 5, 1, 5, 0, sbb);
        this.placeCornerStatue(world, 5, 1, 12, 1, sbb);
        this.placeCornerStatue(world, 12, 1, 5, 2, sbb);
        this.placeCornerStatue(world, 12, 1, 12, 3, sbb);
        this.placeWallStatue(world, 9, 1, 16, Rotation.NONE, sbb);
        this.placeWallStatue(world, 1, 1, 9, Rotation.CLOCKWISE_90, sbb);
        this.placeWallStatue(world, 8, 1, 1, Rotation.CLOCKWISE_180, sbb);
        this.placeWallStatue(world, 16, 1, 8, Rotation.COUNTERCLOCKWISE_90, sbb);
        this.placeDoors(world, sbb);
    }
}

