/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators.warp;

import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.chunkgenerators.warp.NoiseModifier;
import twilightforest.world.components.chunkgenerators.warp.NoiseSlider;
import twilightforest.world.components.chunkgenerators.warp.TFBlendedNoise;
import twilightforest.world.components.chunkgenerators.warp.TerrainColumn;

public class TFTerrainWarp {
    private final int cellWidth;
    private final int cellHeight;
    private final int cellCountY;
    private final BiomeSource biomeSource;
    private final NoiseSettings noiseSettings;
    private final NoiseSlider topSlide;
    private final NoiseSlider bottomSlide;
    private final BlendedNoise blendedNoise;
    private final double dimensionDensityFactor;
    private final double dimensionDensityOffset;
    public final NoiseModifier caveNoiseModifier;
    public static final float[] BIOME_WEIGHTS = (float[])Util.m_137469_((Object)new float[25], afloat -> {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                float weight;
                afloat[x + 2 + (z + 2) * 5] = weight = 10.0f / Mth.m_14116_((float)((float)(x * x + z * z) + 0.2f));
            }
        }
    });

    public TFTerrainWarp(int width, int height, int yCount, BiomeSource source, NoiseSlider topslide, NoiseSlider bottomslide, NoiseSettings settings, BlendedNoise blend, NoiseModifier modifier) {
        double d;
        TFBiomeProvider tfsource;
        this.cellWidth = width;
        this.cellHeight = height;
        this.cellCountY = yCount;
        this.biomeSource = source;
        this.noiseSettings = settings;
        this.topSlide = topslide;
        this.bottomSlide = bottomslide;
        this.blendedNoise = blend;
        if (source instanceof TFBiomeProvider) {
            tfsource = (TFBiomeProvider)source;
            v0 = tfsource.getBaseFactor();
        } else {
            v0 = this.dimensionDensityFactor = 1.0;
        }
        if (source instanceof TFBiomeProvider) {
            tfsource = (TFBiomeProvider)source;
            d = tfsource.getBaseOffset();
        } else {
            d = 0.0;
        }
        this.dimensionDensityOffset = d;
        this.caveNoiseModifier = modifier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fillNoiseColumn(double[] adouble, int x, int z, int min, int max) {
        BiomeSource biomeSource = this.biomeSource;
        if (!(biomeSource instanceof TFBiomeProvider)) throw new IllegalArgumentException("BiomeSource is not an instance of TFBiomeProvider");
        TFBiomeProvider source = (TFBiomeProvider)biomeSource;
        float totalScale = 0.0f;
        float totalDepth = 0.0f;
        float totalContribution = 0.0f;
        float centerDepth = source.getBiomeDepth(x, z);
        for (int offX = -2; offX <= 2; ++offX) {
            for (int offZ = -2; offZ <= 2; ++offZ) {
                Optional<TerrainColumn> terrainColumn = source.getTerrainColumn(x + offX, z + offZ);
                if (terrainColumn.isEmpty()) continue;
                float neighborDepth = terrainColumn.get().depth();
                float neighborScale = terrainColumn.get().scale();
                float topographicContribution = neighborDepth > centerDepth ? 0.5f : 1.0f;
                float piecewiseInfluence = topographicContribution * BIOME_WEIGHTS[offX + 2 + (offZ + 2) * 5] / (neighborDepth + 2.0f);
                totalDepth += neighborDepth * piecewiseInfluence;
                totalScale += neighborScale * piecewiseInfluence;
                totalContribution += piecewiseInfluence;
            }
        }
        float depthNormalized = totalDepth / totalContribution;
        float scaleNormalized = totalScale / totalContribution;
        double modifiedDepth = depthNormalized * 0.5f - 0.125f;
        double modifiedScale = scaleNormalized * 0.9f + 0.1f;
        double offset = modifiedDepth * 0.265625;
        double factor = 96.0 / modifiedScale;
        BlendedNoise blendedNoise = this.blendedNoise;
        if (!(blendedNoise instanceof TFBlendedNoise)) throw new IllegalArgumentException("BlendedNoise is not an instance of TFBlendedNoise");
        TFBlendedNoise blend = (TFBlendedNoise)blendedNoise;
        double scaleXZ = 684.412 * blend.f_192799_;
        double scaleY = 684.412 * blend.f_192800_;
        double factorXZ = scaleXZ / blend.f_230458_;
        double factorY = scaleY / blend.f_230459_;
        double density = -0.46875;
        for (int index = 0; index <= max; ++index) {
            int y = index + min;
            double noise = blend.sampleAndClampNoise(x, y, z, scaleXZ, scaleY, factorXZ, factorY);
            double totaldensity = this.computeInitialDensity(y, offset, factor, density) + noise;
            totaldensity = this.caveNoiseModifier.modifyNoise(totaldensity, y * this.cellHeight, z * this.cellWidth, x * this.cellWidth);
            adouble[index] = totaldensity = this.applySlide(totaldensity, y);
        }
    }

    protected double computeInitialDensity(int y, double offset, double factor, double density) {
        double total;
        double base = 1.0 - (double)y * 2.0 / 32.0 + density;
        double factored = base * this.dimensionDensityFactor + this.dimensionDensityOffset;
        return total * (double)((total = (factored + offset) * factor) > 0.0 ? 4 : 1);
    }

    protected double applySlide(double density, int height) {
        int i = Math.floorDiv(this.noiseSettings.f_158688_(), this.cellHeight);
        int j = height - i;
        density = this.topSlide.applySlide(density, this.cellCountY - j);
        density = this.bottomSlide.applySlide(density, j);
        return density;
    }
}

