/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.biomesources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import twilightforest.world.components.biomesources.SpecialBiomePalette;

public class LandmarkBiomeSource
extends BiomeSource {
    public static final Codec<LandmarkBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").forGetter(o -> o.seed), (App)SpecialBiomePalette.CODEC.fieldOf("palette").forGetter(o -> o.palette)).apply((Applicative)instance, LandmarkBiomeSource::new));
    private static final int LANDMARK_POW_2 = 9;
    private static final int LANDMARK_SCALE = 1024;
    private static final int LANDMARK_HALF_SCALE = 256;
    private static final int MAP_POW_2 = 10;
    private static final int MAP_SCALE = 2048;
    private final long seed;
    private final SpecialBiomePalette palette;

    protected LandmarkBiomeSource(long seed, SpecialBiomePalette palette) {
        this.seed = seed;
        this.palette = palette;
    }

    protected Codec<LandmarkBiomeSource> m_5820_() {
        return CODEC;
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return this.palette.allBiomes().stream();
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler climateSampler) {
        int mapX = x >> 10;
        int mapZ = z >> 10;
        long cellSeed = Mth.m_14130_((int)mapX, (int)((int)this.seed), (int)mapZ);
        int landmarkIndex = LandmarkBiomeSource.indexForQuadrant(x, z);
        float distance = (float)Mth.m_184645_((double)(x % 1024 - 256), (double)(z % 1024 - 256));
        Holder<Biome> biome = this.palette.getNearestLandmark(distance * 1.5f, landmarkIndex, cellSeed);
        if (biome != null) {
            return biome;
        }
        return this.getNoiseBiome(climateSampler.m_183445_(x, y, z));
    }

    public Holder<Biome> getNoiseBiome(Climate.TargetPoint climateSample) {
        return (Holder)this.palette.regularBiomes().m_204252_(climateSample);
    }

    private static int indexForQuadrant(int x, int z) {
        return (z >> 8 & 2) + (x >> 9 & 1);
    }
}

