/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.Multimap;
import com.mojang.authlib.EnvironmentParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.InsufficientPrivilegesException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.exceptions.UserBannedException;
import com.mojang.authlib.exceptions.UserMigratedException;
import com.mojang.authlib.minecraft.client.ObjectMapper;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilEnvironment;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.network.SyncUncraftingTableConfigPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.PlayerHelper;

@Mod.EventBusSubscriber(modid="twilightforest", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TFConfig {
    public static Common COMMON_CONFIG;
    public static Client CLIENT_CONFIG;
    private static final String config = "config.twilightforest";
    public static final List<GameProfile> GAME_PROFILES;

    public static int getClientCloudBlockPrecipitationDistance() {
        return (Integer)((Integer)TFConfig.CLIENT_CONFIG.cloudBlockPrecipitationDistanceClient.get() == -1 ? TFConfig.COMMON_CONFIG.cloudBlockPrecipitationDistanceCommon : TFConfig.CLIENT_CONFIG.cloudBlockPrecipitationDistanceClient).get();
    }

    @Nullable
    public static ResourceLocation getPortalLockingAdvancement(Player player) {
        if (!((String)TFConfig.COMMON_CONFIG.portalAdvancementLock.get()).isEmpty() && TFConfig.COMMON_CONFIG.portalLockingAdvancement == null) {
            if (!ResourceLocation.m_135830_((String)((String)TFConfig.COMMON_CONFIG.portalAdvancementLock.get())) || PlayerHelper.getAdvancement(player, ResourceLocation.m_135820_((String)((String)TFConfig.COMMON_CONFIG.portalAdvancementLock.get()))) == null) {
                TwilightForestMod.LOGGER.fatal("The portal locking advancement is not a valid advancement! Setting to null!");
                TFConfig.COMMON_CONFIG.portalAdvancementLock.set((Object)"");
            } else {
                TFConfig.COMMON_CONFIG.portalLockingAdvancement = ResourceLocation.m_135820_((String)((String)TFConfig.COMMON_CONFIG.portalAdvancementLock.get()));
                TwilightForestMod.LOGGER.debug("Portal Locking Advancement reloaded.");
            }
        }
        return TFConfig.COMMON_CONFIG.portalLockingAdvancement;
    }

    public static List<ResourceLocation> getValidAuroraBiomes(RegistryAccess access) {
        if (TFConfig.CLIENT_CONFIG.validAuroraBiomes.isEmpty() && !((List)TFConfig.CLIENT_CONFIG.auroraBiomes.get()).isEmpty()) {
            ((List)TFConfig.CLIENT_CONFIG.auroraBiomes.get()).forEach(s -> {
                ResourceLocation key = ResourceLocation.m_135820_((String)s);
                if (key == null || !access.m_175515_(Registries.f_256952_).m_7804_(key)) {
                    TwilightForestMod.LOGGER.warn("Biome {} in Twilight Forest's validAuroraBiomes config option is not a valid biome. Skipping!", s);
                } else {
                    TFConfig.CLIENT_CONFIG.validAuroraBiomes.add(key);
                }
            });
        }
        return TFConfig.CLIENT_CONFIG.validAuroraBiomes;
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent event) {
        if (Objects.equals(event.getConfig().getModId(), "twilightforest")) {
            if (event.getConfig().getType() == ModConfig.Type.COMMON) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null && server.m_6982_()) {
                    TFPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncUncraftingTableConfigPacket((Double)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.uncraftingXpCostMultiplier.get(), (Double)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.repairingXpCostMultiplier.get(), (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.allowShapelessUncrafting.get(), (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingOnly.get(), (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableEntireTable.get(), (List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingRecipes.get(), (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.reverseRecipeBlacklist.get(), (List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.blacklistedUncraftingModIds.get(), (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.flipUncraftingModIdList.get()));
                }
                TFConfig.COMMON_CONFIG.portalLockingAdvancement = null;
            } else if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
                TFConfig.CLIENT_CONFIG.validAuroraBiomes.clear();
            }
        }
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        if (Objects.equals(event.getConfig().getModId(), "twilightforest") && event.getConfig().getType() == ModConfig.Type.CLIENT) {
            TFConfig.reloadGiantSkins();
        }
    }

    public static void reloadGiantSkins() {
        if (!((List)TFConfig.CLIENT_CONFIG.giantSkinUUIDs.get()).isEmpty()) {
            new Thread(){

                @Override
                public void run() {
                    GAME_PROFILES.clear();
                    YggdrasilAuthenticationService service = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
                    String baseUrl = EnvironmentParser.getEnvironmentFromProperties().orElse(YggdrasilEnvironment.PROD.getEnvironment()).getSessionHost() + "/session/minecraft/";
                    boolean requireSecure = false;
                    for (String stringUUID : (List)TFConfig.CLIENT_CONFIG.giantSkinUUIDs.get()) {
                        try {
                            UUID uuid = UUID.fromString(stringUUID);
                            URL url = HttpAuthenticationService.constantURL((String)(baseUrl + "profile/" + uuid));
                            url = HttpAuthenticationService.concatenateURL((URL)url, (String)("unsigned=" + !requireSecure));
                            MinecraftProfilePropertiesResponse response = (MinecraftProfilePropertiesResponse)ObjectMapper.create().readValue(service.performGetRequest(url), MinecraftProfilePropertiesResponse.class);
                            if (StringUtils.isNotBlank((CharSequence)response.getError())) {
                                if ("UserMigratedException".equals(response.getCause())) {
                                    throw new UserMigratedException(response.getErrorMessage());
                                }
                                if ("ForbiddenOperationException".equals(response.getError())) {
                                    throw new InvalidCredentialsException(response.getErrorMessage());
                                }
                                if ("InsufficientPrivilegesException".equals(response.getError())) {
                                    throw new InsufficientPrivilegesException(response.getErrorMessage());
                                }
                                if ("multiplayer.access.banned".equals(response.getError())) {
                                    throw new UserBannedException();
                                }
                                throw new AuthenticationException(response.getErrorMessage());
                            }
                            if (response.getId() == null) continue;
                            GameProfile result = new GameProfile(response.getId(), response.getName());
                            if (response.getProperties() != null) {
                                result.getProperties().putAll((Multimap)response.getProperties());
                            }
                            GAME_PROFILES.add(result);
                        }
                        catch (IllegalArgumentException e) {
                            TwilightForestMod.LOGGER.error("\"{}\" is not a valid UUID!", (Object)stringUUID);
                        }
                        catch (AuthenticationException | IOException e) {
                            e.printStackTrace();
                        }
                    }
                    super.run();
                }
            }.start();
        }
    }

    static {
        GAME_PROFILES = new ArrayList<GameProfile>();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue silentCicadas;
        public final ForgeConfigSpec.BooleanValue silentCicadasOnHead;
        public final ForgeConfigSpec.BooleanValue firstPersonEffects;
        public final ForgeConfigSpec.BooleanValue rotateTrophyHeadsGui;
        public final ForgeConfigSpec.BooleanValue disableOptifineNagScreen;
        public final ForgeConfigSpec.BooleanValue disableLockedBiomeToasts;
        public final ForgeConfigSpec.BooleanValue showQuestRamCrosshairIndicator;
        public final ForgeConfigSpec.IntValue cloudBlockPrecipitationDistanceClient;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> giantSkinUUIDs;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> auroraBiomes;
        private final List<ResourceLocation> validAuroraBiomes = new ArrayList<ResourceLocation>();

        public Client(ForgeConfigSpec.Builder builder) {
            this.silentCicadas = builder.translation("config.twilightforestsilent_cicadas").comment("Make cicadas silent for those having sound library problems, or otherwise finding them annoying.").define("silentCicadas", false);
            this.silentCicadasOnHead = builder.translation("config.twilightforestsilent_cicadas_on_head").comment("Make cicadas silent when sitting on your head. If the above option is already true, this won't have any effect.").define("silentCicadasOnHead", false);
            this.firstPersonEffects = builder.translation("config.twilightforestfirst_person_effects").comment("Controls whether various effects from the mod are rendered while in first-person view. Turn this off if you find them distracting.").define("firstPersonEffects", true);
            this.rotateTrophyHeadsGui = builder.translation("config.twilightforestanimate_trophyitem").comment("Rotate trophy heads on item model. Has no performance impact at all. For those who don't like fun.").define("rotateTrophyHeadsGui", true);
            this.disableOptifineNagScreen = builder.translation("config.twilightforestoptifine").comment("Disable the nag screen when Optifine is installed.").define("disableOptifineNagScreen", false);
            this.disableLockedBiomeToasts = builder.translation("config.twilightforestlocked_toasts").comment("Disables the toasts that appear when a biome is locked. Not recommended if you're not familiar with progression.").define("disableLockedBiomeToasts", false);
            this.showQuestRamCrosshairIndicator = builder.translation("config.twilightforestram_indicator").comment("Renders a little check mark or x above your crosshair depending on if fed the Quest Ram that color of wool. Turn this off if you find it intrusive.").define("questRamWoolIndicator", true);
            this.cloudBlockPrecipitationDistanceClient = builder.translation("config.twilightforestcloud_block_precipitation_distance").comment("Renders precipitation underneath cloud blocks. -1 sets it to be synced with the common config.\nSet this to a lower number if you're experiencing poor performance, or set it to 0 if you wish to turn it off").defineInRange("cloudBlockPrecipitationDistance", -1, -1, Integer.MAX_VALUE);
            this.giantSkinUUIDs = builder.translation("config.twilightforestgiant_skin_uuid_list").comment("List of player UUIDs whose skins the giants of Twilight Forest should use.\nIf left empty, the giants will appear the same as the player viewing them does.").defineListAllowEmpty("giantSkinUUIDs", new ArrayList(), s -> s instanceof String);
            this.auroraBiomes = builder.translation("config.twilightforestaurora_biomes").comment("Defines which biomes the aurora shader effect will appear in. Leave the list empty to disable the effect.").defineList("auroraBiomes", List.of("twilightforest:glacier"), s -> s instanceof String);
        }
    }

    public static class Common {
        public final Dimension DIMENSION = new Dimension();
        public final ForgeConfigSpec.ConfigValue<String> originDimension;
        public final ForgeConfigSpec.BooleanValue allowPortalsInOtherDimensions;
        public final ForgeConfigSpec.BooleanValue adminOnlyPortals;
        public final ForgeConfigSpec.BooleanValue disablePortalCreation;
        public final ForgeConfigSpec.BooleanValue checkPortalDestination;
        public final ForgeConfigSpec.BooleanValue portalLightning;
        public final ForgeConfigSpec.BooleanValue shouldReturnPortalBeUsable;
        public final ForgeConfigSpec.ConfigValue<String> portalAdvancementLock;
        public final ForgeConfigSpec.IntValue maxPortalSize;
        public final ForgeConfigSpec.BooleanValue casketUUIDLocking;
        public final ForgeConfigSpec.BooleanValue disableSkullCandles;
        public final ForgeConfigSpec.BooleanValue defaultItemEnchants;
        public final ForgeConfigSpec.BooleanValue bossDropChests;
        public final ForgeConfigSpec.IntValue cloudBlockPrecipitationDistanceCommon;
        public final MagicTrees MAGIC_TREES = new MagicTrees();
        public final UncraftingStuff UNCRAFTING_STUFFS = new UncraftingStuff();
        public final ShieldInteractions SHIELD_INTERACTIONS = new ShieldInteractions();
        @Nullable
        public ResourceLocation portalLockingAdvancement;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings that are not reversible without consequences.").push("Dimension Settings");
            this.DIMENSION.newPlayersSpawnInTF = builder.translation("config.twilightforestspawn_in_tf").comment("If true, players spawning for the first time will spawn in the Twilight Forest.").define("newPlayersSpawnInTF", false);
            this.DIMENSION.portalForNewPlayerSpawn = builder.translation("config.twilightforestportal_for_new_player").comment("If true, the return portal will spawn for new players that were sent to the TF if `spawn_in_tf` is true.").define("portalForNewPlayer", false);
            builder.pop();
            this.originDimension = builder.translation("config.twilightforestorigin_dimension").comment("The dimension you can always travel to the Twilight Forest from, as well as the dimension you will return to. Defaults to the overworld. (domain:regname).").define("originDimension", (Object)"minecraft:overworld");
            this.allowPortalsInOtherDimensions = builder.translation("config.twilightforestportals_in_other_dimensions").comment("Allow portals to the Twilight Forest to be made outside of the 'origin' dimension. May be considered an exploit.").define("allowPortalsInOtherDimensions", false);
            this.adminOnlyPortals = builder.translation("config.twilightforestadmin_portals").comment("Allow portals only for admins (Operators). This severely reduces the range in which the mod usually scans for valid portal conditions, and it scans near ops only.").define("adminOnlyPortals", false);
            this.disablePortalCreation = builder.translation("config.twilightforestportals").comment("Disable Twilight Forest portal creation entirely. Provided for server operators looking to restrict action to the dimension.").define("disablePortalCreation", false);
            this.checkPortalDestination = builder.translation("config.twilightforestcheck_portal_destination").comment("Determines if new portals should be pre-checked for safety. If enabled, portals will fail to form rather than redirect to a safe alternate destination.\nNote that enabling this also reduces the rate at which portal formation checks are performed.").define("checkPortalDestination", false);
            this.portalLightning = builder.translation("config.twilightforestportal_lighting").comment("Set this true if you want the lightning that zaps the portal to not set things on fire. For those who don't like fun.").define("portalLightning", false);
            this.shouldReturnPortalBeUsable = builder.translation("config.twilightforestportal_return").comment("If false, the return portal will require the activation item.").define("shouldReturnPortalBeUsable", true);
            this.portalAdvancementLock = builder.translation("config.twilightforestportal_unlocked_by_advancement").comment("Use a valid advancement resource location as a string. For example, using the string \"minecraft:story/mine_diamond\" will lock the portal behind the \"Diamonds!\" advancement. Invalid/Empty Advancement resource IDs will leave the portal entirely unlocked.").define("portalUnlockedByAdvancement", (Object)"");
            this.maxPortalSize = builder.translation("config.twilightforestmax_portal_size").comment("The max amount of water spaces the mod will check for when creating a portal. Very high numbers may cause issues.").defineInRange("maxPortalSize", 64, 4, Integer.MAX_VALUE);
            this.casketUUIDLocking = builder.worldRestart().translation("config.twilightforestcasket_uuid_locking").comment("If true, Keepsake Caskets that are spawned when a player dies will not be accessible by other players. Use this if you dont want people taking from other people's death caskets. NOTE: server operators will still be able to open locked caskets.").define("uuid_locking", false);
            this.disableSkullCandles = builder.translation("config.twilightforestdisable_skull_candles").comment("If true, disables the ability to make Skull Candles by right clicking a vanilla skull with a candle. Turn this on if you're having mod conflict issues for some reason.").define("skull_candles", false);
            this.defaultItemEnchants = builder.translation("config.twilightforestdefault_item_enchantments").worldRestart().comment("If false, items that come enchanted when you craft them (such as ironwood or steeleaf gear) will not show this way in the creative inventory.\nPlease note that this doesnt affect the crafting recipes themselves, you will need a datapack to change those.").define("default_item_enchantments", true);
            this.bossDropChests = builder.translation("config.twilightforestboss_drop_chests").comment("If true, Twilight Forest's bosses will put their drops inside of a chest where they originally spawned instead of dropping the loot directly.\nNote that the Knight Phantoms are not affected by this as their drops work differently.").define("boss_drop_chests", true);
            this.cloudBlockPrecipitationDistanceCommon = builder.translation("config.twilightforestcloud_block_precipitation_distance_server").comment("Dictates how many blocks down from a cloud block should the game logic check for handling weather related code.\nLower if experiencing low tick rate. Set to 0 to turn all cloud precipitation logic off.").defineInRange("cloudBlockPrecipitationDistance", 32, 0, Integer.MAX_VALUE);
            builder.comment("Settings for all things related to the uncrafting table.").push("Uncrafting Table");
            this.UNCRAFTING_STUFFS.uncraftingXpCostMultiplier = builder.worldRestart().translation("config.twilightforestuncrafting_xp_cost").comment("Multiplies the total XP cost of uncrafting an item and rounds up.\nHigher values means the recipe will cost more to uncraft, lower means less. Set to 0 to disable the cost altogether.\nNote that this only affects reversed crafting recipes, uncrafting recipes will still use the same cost as they normally would.").defineInRange("uncraftingXpCostMultiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.UNCRAFTING_STUFFS.repairingXpCostMultiplier = builder.worldRestart().translation("config.twilightforestrepairing_xp_cost").comment("Multiplies the total XP cost of repairing an item and rounds up.\nHigher values means the recipe will cost more to repair, lower means less. Set to 0 to disable the cost altogether.").defineInRange("repairingXpCostMultiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.UNCRAFTING_STUFFS.disableUncraftingRecipes = builder.worldRestart().translation("config.twilightforestuncrafting_recipes").comment("If you don't want to disable uncrafting altogether, and would rather disable certain recipes, this is for you.\nTo add a recipe, add the mod id followed by the name of the recipe. You can check this in things like JEI.\nExample: \"twilightforest:firefly_particle_spawner\" will disable uncrafting the particle spawner into a firefly jar, firefly, and poppy.\nIf an item has multiple crafting recipes and you wish to disable them all, add the item to the \"twilightforest:banned_uncraftables\" item tag.\nIf you have a problematic ingredient, like infested towerwood for example, add the item to the \"twilightforest:banned_uncrafting_ingredients\" item tag.").defineList("disableUncraftingRecipes", List.of("twilightforest:giant_log_to_oak_planks"), s -> s instanceof String);
            this.UNCRAFTING_STUFFS.reverseRecipeBlacklist = builder.worldRestart().translation("config.twilightforestuncrafting_recipes_flip").comment("If true, this will invert the above uncrafting recipe list from a blacklist to a whitelist.").define("flipRecipeList", false);
            this.UNCRAFTING_STUFFS.blacklistedUncraftingModIds = builder.worldRestart().translation("config.twilightforestuncrafting_mod_ids").comment("Here, you can disable all items from certain mods from being uncrafted.\nInput a valid mod id to disable all uncrafting recipes from that mod.\nExample: \"twilightforest\" will disable all uncrafting recipes from this mod.").defineList("blacklistedUncraftingModIds", new ArrayList(), s -> s instanceof String);
            this.UNCRAFTING_STUFFS.flipUncraftingModIdList = builder.worldRestart().translation("config.twilightforestuncrafting_mod_id_flip").comment("If true, this will invert the above option from a blacklist to a whitelist.").define("flipIdList", false);
            this.UNCRAFTING_STUFFS.allowShapelessUncrafting = builder.worldRestart().translation("config.twilightforestshapeless_uncrafting").comment("If true, the uncrafting table will also be allowed to uncraft shapeless recipes.\nThe table was originally intended to only take shaped recipes, but this option remains for people who wish to keep the functionality.").define("enableShapelessCrafting", false);
            this.UNCRAFTING_STUFFS.disableUncraftingOnly = builder.worldRestart().translation("config.twilightforestdisable_uncrafting").comment("Disables the uncrafting function of the uncrafting table. Recommended as a last resort if there's too many things to change about its behavior (or you're just lazy, I dont judge).\nDo note that special uncrafting recipes are not disabled as the mod relies on them for other things.").define("disableUncrafting", false);
            this.UNCRAFTING_STUFFS.disableEntireTable = builder.worldRestart().translation("config.twilightforestdisable_uncrafting_table").comment("Disables any usage of the uncrafting table, as well as prevents it from showing up in loot or crafted.\nPlease note that table has more uses than just uncrafting, you can read about them here! http://benimatic.com/tfwiki/index.php?title=Uncrafting_Table\nIt is highly recommended to keep the table enabled as the mod has special uncrafting exclusive recipes, but the option remains for people that dont want the table to be functional at all.\nIf you are looking to just prevent normal crafting recipes from being reversed, consider using the 'disableUncrafting' option instead.").define("disableUncraftingTable", false);
            builder.pop();
            builder.comment("Settings for all things related to the magic trees.").push("Magic Trees");
            this.MAGIC_TREES.disableTime = builder.worldRestart().translation("config.twilightforestdisable_time").comment("If true, prevents the Timewood Core from functioning.").define("disableTimeCore", false);
            this.MAGIC_TREES.timeRange = builder.worldRestart().translation("config.twilightforesttime_range").comment("Defines the radius at which the Timewood Core works. Can be a number anywhere between 1 and 128.").defineInRange("timeCoreRange", 16, 1, 128);
            this.MAGIC_TREES.disableTransformation = builder.worldRestart().translation("config.twilightforestdisable_transformation").comment("If true, prevents the Transformation Core from functioning.").define("disableTransformationCore", false);
            this.MAGIC_TREES.transformationRange = builder.worldRestart().translation("config.twilightforesttransformation_range").comment("Defines the radius at which the Transformation Core works. Can be a number anywhere between 1 and 128.").defineInRange("transformationCoreRange", 16, 1, 128);
            this.MAGIC_TREES.disableMining = builder.worldRestart().translation("config.twilightforestdisable_mining").comment("If true, prevents the Minewood Core from functioning.").define("disableMiningCore", false);
            this.MAGIC_TREES.miningRange = builder.worldRestart().translation("config.twilightforestmining_range").comment("Defines the radius at which the Minewood Core works. Can be a number anywhere between 1 and 128.").defineInRange("miningCoreRange", 16, 1, 128);
            this.MAGIC_TREES.disableSorting = builder.worldRestart().translation("config.twilightforestdisable_sorting").comment("If true, prevents the Sortingwood Core from functioning.").define("disableSortingCore", false);
            this.MAGIC_TREES.sortingRange = builder.worldRestart().translation("config.twilightforestsorting_range").comment("Defines the radius at which the Sortingwood Core works. Can be a number anywhere between 1 and 128.").defineInRange("sortingCoreRange", 16, 1, 128);
            builder.pop();
            builder.comment("We recommend downloading the Shield Parry mod for parrying, but these controls remain for without.").push("Shield Parrying");
            this.SHIELD_INTERACTIONS.parryNonTwilightAttacks = builder.translation("config.twilightforestparry_non_twilight").comment("Set to true to parry non-Twilight projectiles.").define("parryNonTwilightAttacks", false);
            this.SHIELD_INTERACTIONS.shieldParryTicks = builder.translation("config.twilightforestparry_window").comment("The amount of ticks after raising a shield that makes it OK to parry a projectile.").defineInRange("shieldParryTicksArrow", 40, 0, Integer.MAX_VALUE);
            builder.pop();
        }

        public static class Dimension {
            public ForgeConfigSpec.BooleanValue newPlayersSpawnInTF;
            public ForgeConfigSpec.BooleanValue portalForNewPlayerSpawn;
        }

        public static class MagicTrees {
            public ForgeConfigSpec.BooleanValue disableTime;
            public ForgeConfigSpec.IntValue timeRange;
            public ForgeConfigSpec.BooleanValue disableTransformation;
            public ForgeConfigSpec.IntValue transformationRange;
            public ForgeConfigSpec.BooleanValue disableMining;
            public ForgeConfigSpec.IntValue miningRange;
            public ForgeConfigSpec.BooleanValue disableSorting;
            public ForgeConfigSpec.IntValue sortingRange;
        }

        public static class UncraftingStuff {
            public ForgeConfigSpec.DoubleValue uncraftingXpCostMultiplier;
            public ForgeConfigSpec.DoubleValue repairingXpCostMultiplier;
            public ForgeConfigSpec.BooleanValue allowShapelessUncrafting;
            public ForgeConfigSpec.BooleanValue disableUncraftingOnly;
            public ForgeConfigSpec.BooleanValue disableEntireTable;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> disableUncraftingRecipes;
            public ForgeConfigSpec.BooleanValue reverseRecipeBlacklist;
            public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedUncraftingModIds;
            public ForgeConfigSpec.BooleanValue flipUncraftingModIdList;
        }

        public static class ShieldInteractions {
            public ForgeConfigSpec.BooleanValue parryNonTwilightAttacks;
            public ForgeConfigSpec.IntValue shieldParryTicks;
        }
    }

    @Mod.EventBusSubscriber(modid="twilightforest")
    public static class ConfigSync {
        @SubscribeEvent
        public static void syncConfigOnLogin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null && server.m_6982_() && (player = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SyncUncraftingTableConfigPacket((Double)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.uncraftingXpCostMultiplier.get(), (Double)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.repairingXpCostMultiplier.get(), (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.allowShapelessUncrafting.get(), (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingOnly.get(), (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableEntireTable.get(), (List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingRecipes.get(), (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.reverseRecipeBlacklist.get(), (List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.blacklistedUncraftingModIds.get(), (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.flipUncraftingModIdList.get()));
            }
        }
    }
}

